/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import java.text.MessageFormat;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractFunctionTag;
import org.eclipse.jet.taglib.FunctionTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;

public abstract class AbstractCaseShiftTag
extends AbstractFunctionTag
implements FunctionTag {
    private static final String LENGTH_ATTR = "length";
    private static final String OFFSET_ATTR = "offset";

    public final String doFunction(TagInfo td, JET2Context context, String bodyContent) throws JET2TagException {
        int offset = 0;
        if (td.hasAttribute(OFFSET_ATTR)) {
            try {
                offset = Integer.valueOf(this.getAttribute(OFFSET_ATTR));
                if (offset < 0) {
                    throw new JET2TagException(MessageFormat.format(JET2Messages.AnyTag_AttributeMustBeInteger, OFFSET_ATTR));
                }
            }
            catch (NumberFormatException e) {
                throw new JET2TagException(MessageFormat.format(JET2Messages.AnyTag_AttributeMustBeInteger, OFFSET_ATTR), (Throwable)e);
            }
        }
        int length = bodyContent.length() - offset;
        if (td.hasAttribute(LENGTH_ATTR)) {
            try {
                length = Integer.valueOf(this.getAttribute(LENGTH_ATTR));
                if (length < 0) {
                    throw new JET2TagException(MessageFormat.format(JET2Messages.AnyTag_AttributeMustBeInteger, LENGTH_ATTR));
                }
            }
            catch (NumberFormatException e) {
                throw new JET2TagException(MessageFormat.format(JET2Messages.AnyTag_AttributeMustBeInteger, LENGTH_ATTR), (Throwable)e);
            }
        }
        StringBuffer buffer = new StringBuffer(bodyContent);
        if (length < 0) {
            length = 0;
        }
        if (length > buffer.length() - offset) {
            length = buffer.length() - offset;
        }
        if (offset < buffer.length()) {
            String textToCaseShift = bodyContent.substring(offset, offset + length);
            buffer.replace(offset, offset + length, this.doCaseShift(textToCaseShift));
        }
        return buffer.toString();
    }

    protected abstract String doCaseShift(String var1);
}

