/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.xtend.shared.ui.editor.EnableDisableBreakpointAction;
import org.eclipse.xtend.shared.ui.editor.ToggleBreakpointAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointActionGroup
extends ActionGroup {
    private EnableDisableBreakpointAction enableAction;
    private ToggleBreakpointAction toggleAction;
    private int lastSelectedLine;
    private int lastSelectedOffset;
    private IVerticalRuler verticalRuler;
    private boolean rulerSelected;
    private StyledText textWidget;

    public BreakpointActionGroup(TextEditor editor) {
        Assert.isNotNull((Object)editor);
        Object obj = this.getterMethod("getSourceViewer", editor);
        if (obj == null) {
            return;
        }
        this.textWidget = ((ISourceViewer)obj).getTextWidget();
        obj = this.getterMethod("getVerticalRuler", editor);
        if (obj == null) {
            return;
        }
        this.verticalRuler = (IVerticalRuler)obj;
        this.enableAction = new EnableDisableBreakpointAction(editor, this);
        this.toggleAction = new ToggleBreakpointAction(editor, this);
        this.textWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    BreakpointActionGroup.this.updateLastSelectedOffset(e.x, e.y);
                }
            }
        });
        this.verticalRuler.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    BreakpointActionGroup.this.updateLastSelectedLine(e.y);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                BreakpointActionGroup.this.updateLastSelectedLine(e.y);
                BreakpointActionGroup.this.toggleAction.run();
            }
        });
    }

    private void updateLastSelectedLine(int y) {
        this.rulerSelected = true;
        int oldLine = this.lastSelectedLine;
        int oldOffset = this.lastSelectedOffset;
        try {
            this.lastSelectedLine = this.verticalRuler.toDocumentLineNumber(y);
            this.lastSelectedOffset = this.textWidget.getOffsetAtLocation(new Point(0, y));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.lastSelectedLine = oldLine;
            this.lastSelectedOffset = oldOffset;
        }
    }

    private void updateLastSelectedOffset(int x, int y) {
        this.rulerSelected = false;
        int oldLine = this.lastSelectedLine;
        try {
            this.lastSelectedLine = this.verticalRuler.toDocumentLineNumber(y);
            try {
                this.lastSelectedOffset = this.textWidget.getOffsetAtLocation(new Point(x, y));
            }
            catch (Exception exception) {
                try {
                    this.lastSelectedOffset = this.textWidget.getOffsetAtLocation(new Point(0, y));
                    int lineIndex = this.textWidget.getLineAtOffset(this.lastSelectedOffset);
                    this.lastSelectedOffset += this.textWidget.getLine(lineIndex).length();
                }
                catch (Exception exception2) {
                    this.lastSelectedOffset = this.textWidget.getText().length();
                }
            }
        }
        catch (Exception exception) {
            this.lastSelectedLine = oldLine;
        }
    }

    public boolean isRulerSelected() {
        return this.rulerSelected;
    }

    public int getLastSelectedLine() {
        return this.lastSelectedLine;
    }

    public int getLastSelectedOffset() {
        return this.lastSelectedOffset;
    }

    public int getOffsetAtLine(int line) {
        return this.textWidget.getOffsetAtLine(line);
    }

    public void fillContextMenu(IMenuManager manager) {
        this.toggleAction.updateText();
        manager.appendToGroup("Xpand", (IAction)this.toggleAction);
        this.enableAction.updateText();
        manager.appendToGroup("Xpand", (IAction)this.enableAction);
    }

    public void dispose() {
        this.enableAction = null;
        this.toggleAction = null;
        super.dispose();
    }

    private Object getterMethod(String name, Object element) {
        try {
            Method m = this.findMethod(name, element.getClass());
            if (m != null) {
                m.setAccessible(true);
                return m.invoke(element, new Object[0]);
            }
        }
        catch (Exception exception) {
            System.out.println("BreakpointActionGroup.getterMethod() caused an error");
        }
        return null;
    }

    private Method findMethod(String name, Class<?> clazz) {
        if (!Object.class.equals(clazz)) {
            Method[] methods;
            Method[] methodArray = methods = clazz.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(name)) {
                    return method;
                }
                ++n2;
            }
            return this.findMethod(name, clazz.getSuperclass());
        }
        return null;
    }
}

