/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: ParserException.java,v 1.3 2007/03/18 08:39:03 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * The root abstract class for all Exception classes
 */
public class ParserException extends RuntimeException {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    /*
     * Nested cause is supported since Java <font size="-2"> <sup>TM </sup>
     * </font> 1.4, RDF Parser is implemented based on Java <font size="-2">
     * <sup>TM </sup> </font> 1.3, so the feature is added.
     */
    private Throwable _cause = this;

    public ParserException() {
        super();
    }

    public ParserException(String message) {
        super(message);
    }

    public ParserException(Throwable cause) {
        this._cause = cause;
    }

    public ParserException(String message, Throwable cause) {
        super(message);
        this._cause = cause;
    }

    /**
     * get the cause of the exception
     */
    public Throwable getCause() {
        return (this._cause == this ? null : this._cause);
    }

    /**
     * get the message of the exception
     */
    public String getMessage() {
        if (this._cause == null || this._cause == this) {
            return super.getMessage();
        } else {
            return super.getMessage()
                   + "; nested exception is "
                   + this._cause.getClass().getName() + ": "
                   + this._cause.getMessage();
        }
    }

    /**
     * Prints this exception and its backtrace to the specified print stream.
     */
    public void printStackTrace(PrintStream ps) {
        if (this._cause == null || this._cause == this) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            this._cause.printStackTrace(ps);
        }
    }

    /**
     * Prints this exception and its backtrace to the specified print writer.
     */
    public void printStackTrace(PrintWriter pw) {
        if (this._cause == null || this._cause == this) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            this._cause.printStackTrace(pw);
        }
    }
}