/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLGraphImpl.java,v 1.1 2007/03/18 08:10:11 lzhang Exp $
 */
package org.eclipse.eodm.impl;

import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.OWLFactory;
import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.exceptions.AddingTripleException;
import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.owl.owlbase.*;
import org.eclipse.eodm.owl.owlbase.util.OWLBasePackage;
import org.eclipse.eodm.rdf.rdfbase.BlankNode;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.impl.RDFGraphImpl;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.RDFList;
import org.eclipse.eodm.util.*;
import org.eclipse.eodm.vocabulary.OWL;



/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>OWL Graph</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.impl.OWLGraphImpl#getGraphontology <em>Graphontology</em>}</li>
 *   <li>{@link org.eclipse.eodm.impl.OWLGraphImpl#getOwlGraphStatement <em>Owl Graph Statement</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OWLGraphImpl extends RDFGraphImpl implements OWLGraph {
	/**
	 * The cached value of the '{@link #getGraphontology() <em>Graphontology</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGraphontology()
	 * @generated
	 * @ordered
	 */
	protected EList graphontology = null;

	/**
	 * The cached value of the '{@link #getOwlGraphStatement() <em>Owl Graph Statement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwlGraphStatement()
	 * @generated
	 * @ordered
	 */
	protected EList owlGraphStatement = null;

	/**
	 * Special properties and predicates that need be processed differently
	 */
		
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLGraphImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return OWLBasePackage.eINSTANCE.getOWLGraph();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getGraphontology() {
		if (graphontology == null) {
			graphontology = new EObjectWithInverseResolvingEList.ManyInverse(OWLOntology.class, this, OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY, OWLBasePackage.OWL_ONTOLOGY__OWL_GRAPH);
		}
		return graphontology;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOwlGraphStatement() {
		if (owlGraphStatement == null) {
			owlGraphStatement = new EObjectResolvingEList(Statement.class, this, OWLBasePackage.OWL_GRAPH__OWL_GRAPH_STATEMENT);
		}
		return owlGraphStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case OWLBasePackage.OWL_GRAPH__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case OWLBasePackage.OWL_GRAPH__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				case OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY:
					return ((InternalEList)getGraphontology()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case OWLBasePackage.OWL_GRAPH__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case OWLBasePackage.OWL_GRAPH__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case OWLBasePackage.OWL_GRAPH__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case OWLBasePackage.OWL_GRAPH__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				case OWLBasePackage.OWL_GRAPH__GRAPH_NAME:
					return basicSetGraphName(null, msgs);
				case OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY:
					return ((InternalEList)getGraphontology()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OWLBasePackage.OWL_GRAPH__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case OWLBasePackage.OWL_GRAPH__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case OWLBasePackage.OWL_GRAPH__RD_FTYPE:
				return getRDFtype();
			case OWLBasePackage.OWL_GRAPH__RDF_SMEMBER:
				return getRDFSmember();
			case OWLBasePackage.OWL_GRAPH__NODE_ID:
				return getNodeID();
			case OWLBasePackage.OWL_GRAPH__RDF_SCOMMENT:
				return getRDFScomment();
			case OWLBasePackage.OWL_GRAPH__RDF_SLABEL:
				return getRDFSlabel();
			case OWLBasePackage.OWL_GRAPH__URI_REF:
				return getUriRef();
			case OWLBasePackage.OWL_GRAPH__SUBJECT_STATEMENT:
				return getSubjectStatement();
			case OWLBasePackage.OWL_GRAPH__GRAPHSTATEMENT:
				return getGraphstatement();
			case OWLBasePackage.OWL_GRAPH__GRAPH_NAME:
				return getGraphName();
			case OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY:
				return getGraphontology();
			case OWLBasePackage.OWL_GRAPH__OWL_GRAPH_STATEMENT:
				return getOwlGraphStatement();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OWLBasePackage.OWL_GRAPH__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__NODE_ID:
				setNodeID((String)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__GRAPHSTATEMENT:
				getGraphstatement().clear();
				getGraphstatement().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__GRAPH_NAME:
				setGraphName((URIReference)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY:
				getGraphontology().clear();
				getGraphontology().addAll((Collection)newValue);
				return;
			case OWLBasePackage.OWL_GRAPH__OWL_GRAPH_STATEMENT:
				getOwlGraphStatement().clear();
				getOwlGraphStatement().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OWLBasePackage.OWL_GRAPH__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__RD_FTYPE:
				getRDFtype().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__URI_REF:
				getUriRef().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__GRAPHSTATEMENT:
				getGraphstatement().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__GRAPH_NAME:
				setGraphName((URIReference)null);
				return;
			case OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY:
				getGraphontology().clear();
				return;
			case OWLBasePackage.OWL_GRAPH__OWL_GRAPH_STATEMENT:
				getOwlGraphStatement().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case OWLBasePackage.OWL_GRAPH__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case OWLBasePackage.OWL_GRAPH__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case OWLBasePackage.OWL_GRAPH__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case OWLBasePackage.OWL_GRAPH__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case OWLBasePackage.OWL_GRAPH__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case OWLBasePackage.OWL_GRAPH__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case OWLBasePackage.OWL_GRAPH__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case OWLBasePackage.OWL_GRAPH__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case OWLBasePackage.OWL_GRAPH__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
			case OWLBasePackage.OWL_GRAPH__GRAPHSTATEMENT:
				return graphstatement != null && !graphstatement.isEmpty();
			case OWLBasePackage.OWL_GRAPH__GRAPH_NAME:
				return graphName != null;
			case OWLBasePackage.OWL_GRAPH__GRAPHONTOLOGY:
				return graphontology != null && !graphontology.isEmpty();
			case OWLBasePackage.OWL_GRAPH__OWL_GRAPH_STATEMENT:
				return owlGraphStatement != null && !owlGraphStatement.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}
	
	protected void specialProcessHasValue(Triple triple) throws UnsupportedViewTypeException 
	{
		String subjectTag = triple.isSubjectURI()?triple.getSubjectURI():triple.getSubjectNodeID();
		HasValueRestriction hasvaluerestriction= null ;
		
		if(this.entities.containsKey(subjectTag))
		{
			hasvaluerestriction = (HasValueRestriction) 
										((RDFSResource)this.entities.get(subjectTag)).
											forceAsType( HasValueRestriction.class );			
		}		
		else if(triple.isSubjectURI())
		{
			hasvaluerestriction = (HasValueRestriction)((OWLFactoryImpl)OWLFactory.eINSTANCE).internalCreate(this,HasValueRestriction.class,triple.getSubjectUriRef());
		}
		else
		{
			hasvaluerestriction = (HasValueRestriction)RDFFactory.eINSTANCE.createBlankNode(this, triple.getSubjectNodeID()).forceAsType(HasValueRestriction.class);
		}
		
		if(triple.isObjectLiteral())
		{
			hasvaluerestriction.setHasLiteralValue(triple.getObjectLiteral());
		}
		else if(triple.isObjectURI())
			{
				hasvaluerestriction.setHasIndividualValue((Individual)((OWLFactoryImpl)OWLFactory.eINSTANCE).internalCreate(this,Individual.class,triple.getObjectUriRef()));
			}
			else{
				hasvaluerestriction.setHasIndividualValue((Individual)RDFFactory.eINSTANCE.createBlankNode(this, triple.getSubjectNodeID()).forceAsType(Individual.class));
			}	
	}
	
	protected void specialProcessAllValuesFrom(Triple triple) 
	throws AddingTripleException, UnsupportedViewTypeException
	{
		String subjectTag = triple.isSubjectURI()?triple.getSubjectURI():triple.getSubjectNodeID();
		AllValuesFromRestriction allvaluesfromrestriction = null ;
		
		if(this.entities.containsKey(subjectTag))
		{
			allvaluesfromrestriction = (AllValuesFromRestriction) 
										((RDFSResource)this.entities.get(subjectTag)).
											forceAsType( AllValuesFromRestriction.class );			
		}		
		else if(triple.isSubjectURI())
		{
			allvaluesfromrestriction = (AllValuesFromRestriction)((OWLFactoryImpl)OWLFactory.eINSTANCE).internalCreate(this,AllValuesFromRestriction.class,triple.getSubjectUriRef());
		}
		else
		{
			allvaluesfromrestriction = (AllValuesFromRestriction)RDFFactory.eINSTANCE.createBlankNode(this, triple.getSubjectNodeID()).forceAsType(AllValuesFromRestriction.class);
		}
        //The allvaluesfrom predicate requires a OWLClass or OWLDataRange as object 
		//If the object uri in the triple is not an OWLClass or OWLDataRange or not defined
		//Exception will be thrown
		if(triple.isObjectURI()||triple.isObjectBlankNode())
		{
			String tag = triple.isObjectURI()?triple.getObjectURI():triple.getObjectNodeID();
			RDFSResource rdfsResource = this.getRDFSResource(tag);
			if(rdfsResource!=null)
			{
				if(rdfsResource.canAsType(OWLClass.class))
				{
					allvaluesfromrestriction.setAllValuesFromClass((OWLClass)rdfsResource.asType(OWLClass.class));
					return ;
				}
				else if(rdfsResource.canAsType(OWLDataRange.class))
				{
					allvaluesfromrestriction.setAllValuesFromDataRange((OWLDataRange)rdfsResource.asType(OWLDataRange.class));
					return ;
				}
			}
		}
		throw new AddingTripleException(); 
	}
	
	protected void specialProcessSomeValuesFrom(Triple triple) 
	throws AddingTripleException, UnsupportedViewTypeException
	{
		String subjectTag = triple.isSubjectURI()?triple.getSubjectURI():triple.getSubjectNodeID();
		SomeValuesFromRestriction somevaluesfromrestriction = null ;
		
		if(this.entities.containsKey(subjectTag))
		{
			somevaluesfromrestriction = (SomeValuesFromRestriction) 
										((RDFSResource)this.entities.get(subjectTag)).
											forceAsType( SomeValuesFromRestriction.class );			
		}		
		else if(triple.isSubjectURI())
		{
			somevaluesfromrestriction = (SomeValuesFromRestriction)((OWLFactoryImpl)OWLFactory.eINSTANCE).internalCreate(this,SomeValuesFromRestriction.class,triple.getSubjectUriRef());
		}
		else
		{
			somevaluesfromrestriction = (SomeValuesFromRestriction)RDFFactory.eINSTANCE.createBlankNode(this, triple.getSubjectNodeID()).forceAsType(SomeValuesFromRestriction.class);
		}
		
		if(triple.isObjectURI()||triple.isObjectBlankNode())
		{
            //The allvaluesfrom predicate requires a OWLClass or OWLDataRange as object 
			//If the object uri in the triple is not an OWLClass or OWLDataRange or not defined
			//Exception will be thrown
			String tag = triple.isObjectURI()?triple.getObjectURI():triple.getObjectNodeID();
			RDFSResource rdfsResource = this.getRDFSResource(tag);
			if(rdfsResource!=null)
			{
				if(rdfsResource.canAsType(OWLClass.class))
				{
					somevaluesfromrestriction.setSomeValuesFromClass((OWLClass)rdfsResource.asType(OWLClass.class));
					return ;
				}
				else if(rdfsResource.canAsType(OWLDataRange.class))
				{
					somevaluesfromrestriction.setSomeValuesFromDataRange((OWLDataRange)rdfsResource.asType(OWLDataRange.class));
					return ;
				}
			}
		}
		throw new AddingTripleException();
	}
	
	protected void specialProcessOneOf( Triple triple ) 
	throws AddingTripleException, UnsupportedViewTypeException
	{
		String subjTag = triple.isSubjectURI()? triple.getSubjectURI():triple.getSubjectNodeID();
		RDFSResource subjectResource = this.getRDFSResource( subjTag );
		// we need know the subject's type and it must be created before this triple
		if ( subjectResource != null && ( triple.isObjectURI() || triple.isObjectBlankNode() ) )
		{
			// create the object of the triple if it does not exist
			String objTag = triple.isObjectURI()? triple.getObjectURI() : triple.getObjectNodeID() ;
			RDFSResource obj = (RDFSResource) this.entities.get( objTag );
			if ( null == obj )
			{
				if(triple.isObjectURI())
				{
					obj = (RDFSResource)((RDFFactoryImpl)RDFFactory.eINSTANCE).internalCreate(this, RDFList.class, triple.getObjectUriRef());
				}
				else
				{
					obj = RDFFactory.eINSTANCE.createBlankNode(this, triple.getObjectNodeID());
					obj.setNodeID(triple.getObjectNodeID());
				}				
			}
			RDFList listObj = (RDFList) obj.forceAsType( RDFList.class );
			
			// remember the list in the subject resource
			InternalCoreImpl subjCore = (InternalCoreImpl) ((EODMInvocationHandler)Proxy.getInvocationHandler( 
										subjectResource )).getDelegatedObject();
			if ( subjectResource.canAsType( OWLDataRange.class ))
			{
				subjCore.setDataRangeOneOfList( listObj );
				return ;
			}
			else if ( subjectResource.canAsType( OWLClass.class ))
			{
				subjectResource.forceAsType( EnumeratedClass.class );
				subjCore.setEnumClsOneOfList( listObj );
				return ;
			}
		}
		throw new AddingTripleException();
	}
	
	protected void specialProcessOWLProperty( Triple triple ) 
	throws AddingTripleException, UnsupportedViewTypeException
	{
		String subjectTag = triple.isSubjectURI()? triple.getSubjectURI() : triple.getSubjectNodeID();
		RDFSResource subjectRes = (RDFSResource) this.entities.get( subjectTag );
		String objURI = triple.getObjectURI();
		
		if ( objURI.endsWith(OWL.OBJECT_PROPERTY) )
		{
			OWLObjectProperty op = (OWLObjectProperty) subjectRes.forceAsType( OWLObjectProperty.class );
			op.setIsObjectProperty( true );
		}
		else if ( objURI.endsWith(OWL.DATATYPE_PROPERTY) )
		{
			OWLDatatypeProperty dp = (OWLDatatypeProperty) subjectRes.forceAsType( OWLDatatypeProperty.class );
			dp.setIsDatatypeProperty( true );
		}
		else if ( objURI.endsWith(OWL.INVERSE_FUNCTIONAL_PROPERTY) )
		{
			OWLObjectProperty op = (OWLObjectProperty) subjectRes.forceAsType( OWLObjectProperty.class );
			op.setIsInverseFunctional( true );
		}
		else if ( objURI.endsWith(OWL.SYMMETRIC_PROPERTY) )
		{
			OWLObjectProperty op = (OWLObjectProperty) subjectRes.forceAsType( OWLObjectProperty.class );
			op.setIsSymmetric( true );
		}
		else if ( objURI.endsWith(OWL.TRANSITIVE_PROPERTY) )
		{
			OWLObjectProperty op = (OWLObjectProperty) subjectRes.forceAsType( OWLObjectProperty.class );
			op.setIsTransitive( true );
		}
		else if ( objURI.endsWith(OWL.FUNCTIONAL_PROPERTY) )
		{
			Property prop = (Property) subjectRes.forceAsType(Property.class);
			prop.setIsFunctional( true );
		}
	}
	
	
	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFGraph#addTriple(org.eclipse.eodm.util.Triple)
	 */
	public void addTriple(Triple triple) 
	throws AddingTripleException, UnsupportedViewTypeException, URISyntaxException
	{	
		//	triple.print();
		
		// In the recent proposal of ODM2, some properties defined in owl specification including 
		// hasvalue allvaluesfrom and somevaluesfrom
		// are further separated into two properties in ODM2 proposal  
		// by the different kinds of types of the object of the property predicate.
		String predicate = triple.getPredicate();
		EReference predicateERef = (EReference) RDFUtility.getEReferenceList().get( predicate );
		if ( predicateERef != null )
		{
			super.addTriple( triple );
			
			// special processing type predicate for Funtional, Inverse Functional, Symmetric and Transitive Properties
			if ( predicateERef == RDFBasePackage.eINSTANCE.getRDFSResource_RDFtype() && 
					triple.isObjectURI() && OWLUtility.SpecialProp.contains( triple.getObjectURI() ) )
				specialProcessOWLProperty( triple );
		}	
		else if ( OWLUtility.SpecialValuePred.contains( predicate ))
		{
			if(predicate.equals(OWLUtility.hasValue))
			{
				specialProcessHasValue( triple );
			}
			else if(predicate.equals(OWLUtility.allValuesFrom))
			{
				specialProcessAllValuesFrom( triple );
			}
			else if(predicate.equals(OWLUtility.someValuesFrom))
			{
				specialProcessSomeValuesFrom( triple );
			}
			else if (predicate.equals(OWLUtility.oneOf) )
			{
				specialProcessOneOf( triple );
			}			
		}
		else if(OWLUtility.getEReferenceList().containsKey( predicate ))
		{
			EReference ePredicate = (EReference)OWLUtility.getEReferenceList().get( predicate );
			RDFSResource subjectResource,objectResource;
			String subjectTag;
			String objectTag;
			
			// creat the subject resource if it does not exist
			subjectTag = triple.isSubjectURI()?triple.getSubjectURI():triple.getSubjectNodeID();
			if(this.entities.containsKey(subjectTag))
			{
				subjectResource = (RDFSResource)this.entities.get(subjectTag);			
				subjectResource = subjectResource.forceAsType(ePredicate.getEContainingClass().getInstanceClass());
			}
			else
			{
				if(triple.isSubjectURI())
				{
					subjectResource = (RDFSResource)((OWLFactoryImpl)OWLFactory.eINSTANCE).internalCreate(this,ePredicate.getEContainingClass().getInstanceClass(),triple.getSubjectUriRef());
				}
				else
				{
					subjectResource = RDFFactory.eINSTANCE.createBlankNode(this,triple.getSubjectNodeID()).forceAsType(ePredicate.getEContainingClass().getInstanceClass());
				}
			}
			
			// The object resource's type 
			Class objType = ePredicate.getEReferenceType().getInstanceClass();
			boolean specialPredicate = false ;
			if ( OWLUtility.SpecialSetPred.contains( predicate ) )
			{
				specialPredicate = true ;
				objType = RDFList.class ;
			}
			
			// create the object resource if it does not exist
			if(!triple.isObjectLiteral())
			{
				objectTag = triple.isObjectURI()?triple.getObjectURI():triple.getObjectNodeID();
				
				if(this.entities.containsKey(objectTag))
				{
					objectResource = (RDFSResource)this.entities.get(objectTag);
					objectResource = objectResource.forceAsType(objType);
				}
				else
				{
					if(triple.isObjectURI())
					{
						objectResource = (RDFSResource)((OWLFactoryImpl)OWLFactory.eINSTANCE).internalCreate(
								this, objType, triple.getObjectUriRef());
					}
					else
					{
						objectResource = RDFFactory.eINSTANCE.createBlankNode(this,triple.getObjectNodeID());
						objectResource.setNodeID(triple.getObjectNodeID());
						objectResource = objectResource.forceAsType( objType );
					}
				}				
			}			
			else
			{
				RDFSLiteral objLiteral = triple.getObjectLiteral();
				if ( ePredicate == OWLBasePackage.eINSTANCE.getOWLOntology_OWLversionInfo() )
					// clone the literal for contaiment properties
					objectResource = (RDFSResource) objLiteral.clone();
				else
					objectResource = objLiteral ;
			}
			
			// set the value in the OO model, treat special predicates with care
			if ( specialPredicate ) 
			{
				InternalCoreImpl subjCore = (InternalCoreImpl) ((EODMInvocationHandler)Proxy.getInvocationHandler(
													subjectResource)).getDelegatedObject();
				if ( predicate.equals( OWLUtility.intersectionOf ))
					subjCore.setIntersectionList( (RDFList)objectResource );
				else if ( predicate.equals( OWLUtility.unionOf ))
					subjCore.setUnionList( (RDFList)objectResource );
				else if ( predicate.equals( OWLUtility.distinctMembers ))
					subjCore.setDistinctMembersList( (RDFList)objectResource );
			}
			else 
			{
				int featureid =  OWLUtility.getFeatureIDbyPredicateURI(predicate);
				if(ePredicate.getUpperBound()==-1)
				{
					((EList)subjectResource.eGet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid))).add(objectResource);
				}
				else if(ePredicate.getUpperBound()==1)
				{
					subjectResource.eSet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid),objectResource);
				}
			}
		} 
		else //If the predicate of the triple is customer defined
			super.addCustomTriple( triple );
	}
	
	public ArrayList exportTriples()
	{
		ArrayList triples = new ArrayList();
		for(Iterator iterator = this.getEntityHashMap().keySet().iterator();iterator.hasNext();)
		{
			String uri = (String)iterator.next();
			InternalCore coreObject = (InternalCore)this.getEntityHashMap().get(uri);
			
			
			
			for(Iterator iterator1= OWLUtility.getEReferenceList().keySet().iterator();iterator1.hasNext();)
			{
				String predicate = (String)iterator1.next();
				int featureid = OWLUtility.getFeatureIDbyPredicateURI(predicate);
				if(coreObject.eIsSet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid)))
				{
					EReference reference = (EReference)EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid);
				    if(reference.getUpperBound()==-1)
				    {
				    	EList referedList = (EList)coreObject.eGet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid));
				    	for(int i=0;i<referedList.size();i++)
				    	{
				    		Triple triple  = new Triple();
				    		if(coreObject.getNodeID()!=null&&!coreObject.getNodeID().equals(""))
				    		{
				    			triple.setSubjectNodeID(coreObject.getNodeID());
				    		}
				    		else
				    		{
				    			triple.setSubjectURI(coreObject.getURI());
				    		}
				    		triple.setPredicate(predicate);
				    		RDFSResource objRes = (RDFSResource) referedList.get(i);
				    		if ( objRes.canAsType( RDFSLiteral.class ))
				    		{
								triple.setObjectLiteral( (RDFSLiteral) objRes );
				    		}
				    		else if( objRes.canAsType( BlankNode.class ) )
				    		{
					    		triple.setObjectNodeID( objRes.getNodeID() );
				    		}
				    		else
				    		{
				    			triple.setObjectUriRef((URIReference)(objRes.getUriRef().get(0)));
				    		}
				    		triples.add(triple);
				    	}
				    }
				    else if(reference.getUpperBound()==1)
				    {
				    	Triple triple  = new Triple();
			    		if(coreObject.getNodeID()!=null&&!coreObject.getNodeID().equals(""))
			    		{
			    			triple.setSubjectNodeID(coreObject.getNodeID());
			    		}
			    		else
			    		{
			    			triple.setSubjectURI(coreObject.getURI());
			    		}
			    		triple.setPredicate(predicate);
			    		RDFSResource rdfsResource = (RDFSResource)coreObject.eGet(EODMImplPackage.eINSTANCE.getInternalCore().getEStructuralFeature(featureid));
			    		if(rdfsResource instanceof RDFSLiteral)
			    		{
				    		triple.setObjectLiteral((RDFSLiteral)rdfsResource);
			    		}
			    		else if(rdfsResource.getNodeID()!=null&&!rdfsResource.getNodeID().equals(""))
			    		{
			    			triple.setObjectNodeID(rdfsResource.getNodeID());
			    		}
			    		else
			    		{
			    			triple.setObjectURI(rdfsResource.getURI());
			    		}
			    		
						if ( OWLUtility.ExtendedValuePred.contains( triple.getPredicate() ))
						{
							if(triple.getPredicate().startsWith(OWL.ALL_VALUES_FROM_URI))
				    		{
				    			triple.setPredicate(OWL.ALL_VALUES_FROM_URI);
				    		}
							else if(triple.getPredicate().startsWith(OWL.SOME_VALUES_FROM_URI))
				    		{
				    			triple.setPredicate(OWL.SOME_VALUES_FROM_URI);
				    		}
							else if(triple.getPredicate().startsWith(OWL.HAS_VALUE_URI))
				    		{
				    			triple.setPredicate(OWL.HAS_VALUE_URI);
				    		}
			    		}
			    		triples.add(triple);
				    }
				}
			    
			}
			for(int i= 0;i<coreObject.getCustomTriples().size();i++)
			{
				Triple customerTriple = ((Triple)coreObject.getCustomTriples().get(i)).cloneTriple();
				triples.add(customerTriple);
			}
		}
		return triples;
	}
	
	public ArrayList getTypeResources(String uri,boolean withSpec)throws UnsupportedViewTypeException
	{
		ArrayList list = new ArrayList();
		HashMap graphEntity = this.getEntityHashMap();
		boolean isType = false;
		for(Iterator iterator = graphEntity.keySet().iterator(); iterator.hasNext();)
		{
			isType = false;
			String keyword = (String)iterator.next();
			InternalCore coreObject  = (InternalCore)graphEntity.get(keyword);
			if(OWLUtility.getEClass().containsKey(uri))
			{
				if(withSpec ||coreObject.getUriRef().size()==0||!OWLUtility.getEClass().containsKey(coreObject.getURI()))
				{
					EClass classType = (EClass)OWLUtility.getEClass().get(uri);
					for(Iterator iterator1 = coreObject.getProxyList().iterator();iterator1.hasNext();)
					{
						ProxyEntity pe = (ProxyEntity)iterator1.next();
						if(classType.isSuperTypeOf(pe.getEClass()))
						{
							list.add(pe.getProxyObject());
							isType = true;
							break;
						}
					}
				}
			}
			if(!isType)
			{
				for(int i =0;i< coreObject.getRDFtype().size();i++)
				{
					RDFSResource rdfsResource = (RDFSResource)coreObject.getRDFtype().get(i);
					if(uri.equals(rdfsResource.getURI()))
					{
						if(OWLUtility.getEClass().containsKey(uri))
						{
							list.add(coreObject.forceAsType(((EClass)OWLUtility.getEClass().get(uri)).getInstanceClass()));
						}
						else
						{
							list.add(coreObject.forceAsType(RDFBasePackage.eINSTANCE.getRDFSResource().getInstanceClass()));
						}
					}
				}
			}
			
		}
		
			return list;

	}
	
	public Iterator getAllResources(boolean withSpec) {
		return new RDFGraphImpl.GraphResourceIterator(withSpec, OWLUtility.getEClass());
	}
	
	/**
	 * Return the Elist of the given type of Resources in current 
	 * @param classType the class type of the resources in current graph required 
	 * @return
	 */
	public ArrayList getTypeResources(String uri)throws UnsupportedViewTypeException
	{
		return this.getTypeResources(uri,false);
	}
	
	public Iterator getTriples()
	{
		return new OWLGraphIterator(this);
	}

} //OWLGraphImpl
