package world;

public class Account {
	private static int lastNumber = 0;
	
	private int balance;
	private int number;
	private String holder;
	
	public Account(String holder) {
		this.holder = holder;
		this.number = ++lastNumber;
		this.balance = 0;
	}
	
	public void increaseBalance(int amount) {
		if (amount < 0)
			throw new IllegalArgumentException("Cannot add negative amount");
		this.balance += amount;
	}

	public void decreaseBalance(int amount) {
		if (amount < 0)
			throw new IllegalArgumentException("Cannot subtract negative amount");
		int newBalance = this.balance - amount;
		checkNewBalance(newBalance);
		this.balance = newBalance;
	}

	protected void checkNewBalance(int newBalance) {
		if (newBalance < 0)
			throw new IllegalStateException("Account cannot have negative balance");
	}
	
	public int getBalance() {
		return this.balance;
	}
	
	public String toString() {
		return "Account #"+this.number+" of "+this.holder+", balance="+this.balance;
	}
}
