/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.gitbash.Activator;
import org.eclipse.oomph.gitbash.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class GitBash {
    private static final String DEFAULT_EXECUTABLE = "C:\\Program Files (x86)\\Git\\bin\\sh.exe";
    public static boolean quiet;
    private static String executable;

    public static synchronized String getExecutable(Shell shell) {
        if (executable == null) {
            File stateFile = Activator.getDefault().getStateLocation().append("git-bash.txt").toFile();
            if (stateFile.isFile()) {
                executable = GitBash.loadFile(stateFile);
            }
            if (executable == null && (executable = GitBash.openInputDialog(DEFAULT_EXECUTABLE, shell)) == null) {
                return null;
            }
            if (!new File(executable).isFile()) {
                executable = GitBash.openInputDialog(executable, shell);
            }
            GitBash.saveFile(stateFile, executable);
        }
        return executable;
    }

    public static void executeCommand(Shell shell, File workTree, String command) {
        try {
            String gitBash = GitBash.getExecutable(shell);
            if (gitBash != null) {
                String line;
                ProcessBuilder builder = new ProcessBuilder(gitBash, "--login", "-c", command);
                builder.directory(workTree);
                builder.redirectErrorStream(true);
                Process process = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder output = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    output.append(line);
                    output.append("\n");
                }
                int exitValue = process.waitFor();
                if (exitValue == 0) {
                    String message = NLS.bind((String)Messages.GitBash_Success_message, (Object)command);
                    if (!quiet) {
                        Activator.log(String.valueOf(message) + "\n" + output, 1);
                        MessageDialog.openInformation((Shell)shell, (String)Messages.GitBash_GitBash_title, (String)message);
                    }
                } else {
                    String message = NLS.bind((String)Messages.GitBash_Failed_message, (Object)command, (Object)exitValue);
                    if (!quiet) {
                        Activator.log(String.valueOf(message) + "\n" + output, 4);
                        MessageDialog.openError((Shell)shell, (String)Messages.GitBash_GitBash_title, (String)message);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String openInputDialog(String initial, Shell shell) {
        InputDialog dialog = new InputDialog(shell, Messages.GitBash_GitBash_title, Messages.GitBash_Location_label, initial, new IInputValidator(){

            public String isValid(String newText) {
                return new File(newText).isFile() ? null : Messages.GitBash_NotFile_imessage;
            }
        });
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getValue();
    }

    /*
     * Loose catch block
     */
    private static String loadFile(File file) {
        String string;
        FileReader in;
        block12: {
            in = null;
            in = new FileReader(file);
            string = new BufferedReader(in).readLine();
            if (in == null) break block12;
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (IOException ex) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private static void saveFile(File file, String content) {
        FileWriter out = null;
        try {
            try {
                out = new FileWriter(file);
                out.write(content);
            }
            catch (IOException ex) {
                throw new IllegalStateException(NLS.bind((String)Messages.GitBash_WriteFailuire_exception, (Object)file), ex);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

