/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ChannelStreamer;
import org.eclipse.packagedrone.repo.adapter.p2.internal.servlet.BinaryLocator;
import org.eclipse.packagedrone.repo.adapter.p2.internal.servlet.DownloadHandler;
import org.eclipse.packagedrone.repo.adapter.p2.internal.servlet.ZippedHandler;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;
import org.eclipse.packagedrone.repo.channel.util.DownloadHelper;
import org.eclipse.packagedrone.repo.servlet.Handler;
import org.eclipse.packagedrone.repo.web.utils.ChannelCacheHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2Servlet
extends AbstractChannelServiceServlet {
    private static final Logger logger = LoggerFactory.getLogger(P2Servlet.class);
    private static final long serialVersionUID = 1L;
    private static final ChannelCacheHandler artifactsXml = new ChannelCacheHandler(new MetaKey("p2.repo", "artifacts.xml"));
    private static final ChannelCacheHandler artifactsJar = new ChannelCacheHandler(new MetaKey("p2.repo", "artifacts.jar"));
    private static final ChannelCacheHandler contentXml = new ChannelCacheHandler(new MetaKey("p2.repo", "content.xml"));
    private static final ChannelCacheHandler contentJar = new ChannelCacheHandler(new MetaKey("p2.repo", "content.jar"));

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Request: {} / {} / {}", new Object[]{req.getMethod(), req.getServletPath(), req.getPathInfo()});
        }
        super.service(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo() == null ? "/" : req.getPathInfo();
        String[] paths = path.split("/");
        if (paths.length < 2) {
            this.showHelp(resp);
            return;
        }
        String channelIdOrName = this.decode(paths[1]);
        ChannelService service = this.getService(req);
        try {
            service.accessRun(ChannelService.By.nameOrId((String)channelIdOrName), ReadableChannel.class, channel -> {
                String channelId = channel.getId().getId();
                if (paths.length < 3) {
                    if (!path.endsWith("/")) {
                        resp.setStatus(301);
                        resp.sendRedirect(String.valueOf(req.getRequestURI()) + "/");
                        return;
                    }
                    String title = ChannelStreamer.makeTitle(channel.getId().getId(), channel.getMetaData());
                    req.setAttribute("p2Title", (Object)title);
                    req.setAttribute("id", (Object)channel.getId().getId());
                    req.setAttribute("title", (Object)channel.getInformation().makeTitle());
                    req.setAttribute("description", (Object)channel.getId().getDescription());
                    req.getRequestDispatcher("/WEB-INF/views/channel.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                } else if ("p2.index".equals(paths[2]) && paths.length == 3) {
                    req.getRequestDispatcher("/WEB-INF/views/p2index.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                } else if ("content.xml".equals(paths[2]) && paths.length == 3) {
                    contentXml.process(channel, req, resp);
                } else if ("artifacts.xml".equals(paths[2]) && paths.length == 3) {
                    artifactsXml.process(channel, req, resp);
                } else if ("content.jar".equals(paths[2]) && paths.length == 3) {
                    contentJar.process(channel, req, resp);
                } else if ("artifacts.jar".equals(paths[2]) && paths.length == 3) {
                    artifactsJar.process(channel, req, resp);
                } else if ("repo.zip".equals(paths[2]) && paths.length == 3) {
                    this.process(req, resp, new ZippedHandler((ReadableChannel)channel));
                } else if (paths.length == 6 && "plugins".equals(paths[2])) {
                    logger.debug("Download plugin: {}", (Object)req.getPathInfo());
                    String id = paths[3];
                    String version = paths[4];
                    String fileName = paths[5];
                    this.process(req, resp, new DownloadHandler(channelId, service, id, version, fileName, "bundle"));
                } else if (paths.length == 6 && "features".equals(paths[2])) {
                    logger.debug("Download feature: {}", (Object)path);
                    String id = paths[3];
                    String version = paths[4];
                    String fileName = paths[5];
                    this.process(req, resp, new DownloadHandler(channelId, service, id, version, fileName, "eclipse.feature"));
                } else if (paths.length == 6 && "binary".equals(paths[2])) {
                    logger.debug("Download binary: {}", (Object)path);
                    String id = paths[3];
                    String version = paths[4];
                    String fileName = paths[5];
                    this.processBinary(req, resp, (ReadableChannel)channel, id, version, fileName);
                } else {
                    logger.info("Not found for: {}", (Object)path);
                    this.notFound(req, resp, "Resource not found: " + path);
                }
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            this.notFound(req, resp, String.format("Channel '%s' not found.", channelIdOrName));
            return;
        }
    }

    private void processBinary(HttpServletRequest request, HttpServletResponse response, ReadableChannel channel, String id, String version, String fileName) throws IOException {
        Optional<ArtifactInformation> ai = BinaryLocator.findByMaven(channel, id, version);
        if (ai.isPresent()) {
            DownloadHelper.streamArtifact((HttpServletResponse)response, (ArtifactInformation)ai.get(), Optional.empty(), (boolean)true, (ReadableChannel)channel, art -> fileName);
        } else {
            this.notFound(request, response, String.format("Binary not found: %s / %s / %s", id, version, fileName));
        }
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void notFound(HttpServletRequest req, HttpServletResponse resp, String message) throws IOException {
        resp.setStatus(404);
        PrintWriter w = resp.getWriter();
        resp.setContentType("text/plain");
        w.println(message);
    }

    private void showHelp(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.getWriter().println("This is the package drone P2 adapter.\n\nAlways know where your towel is!");
    }

    private void process(HttpServletRequest req, HttpServletResponse resp, Handler handler) throws ServletException {
        try {
            handler.process(req, resp);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

