/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.str;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.scada.utils.lang.Apply;

public class StringHelper {
    public static String join(Collection<?> items, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        Iterator<?> iter = items.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String join(Collection<?> items, String delimiter, Apply<String> toApply) {
        StringBuilder buffer = new StringBuilder();
        Iterator<?> iter = items.iterator();
        while (iter.hasNext()) {
            if (toApply != null) {
                buffer.append(toApply.apply(String.valueOf(iter.next())));
            } else {
                buffer.append(iter.next());
            }
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String join(Object[] items, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < items.length) {
            if (i != 0) {
                buffer.append(delimiter);
            }
            buffer.append(items[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String toUpperFirst(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 1) {
            return text.toUpperCase();
        }
        return String.valueOf(text.substring(0, 1).toUpperCase()) + text.substring(1);
    }

    public static String toLowerFirst(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 1) {
            return text.toLowerCase();
        }
        return String.valueOf(text.substring(0, 1).toLowerCase()) + text.substring(1);
    }

    public static String toHex(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            sb.append(String.format("%02x", data[i]));
            ++i;
        }
        return sb.toString();
    }
}

