/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.breadcrumbs;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.packagedrone.web.LinkTarget;

public class Breadcrumbs {
    private final List<Entry> entries;

    public Breadcrumbs(List<Entry> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    public Breadcrumbs(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static Entry create(String label, Class<?> controllerClazz, String methodName) {
        return new Entry(label, LinkTarget.createFromController(controllerClazz, (String)methodName).getUrl());
    }

    public static Entry create(String label, Class<?> controllerClazz, String methodName, Map<String, ?> model) {
        return new Entry(label, LinkTarget.createFromController(controllerClazz, (String)methodName).expand(model).getUrl());
    }

    public static Entry create(String label, Class<?> controllerClazz, String methodName, String key, Object value) {
        return new Entry(label, LinkTarget.createFromController(controllerClazz, (String)methodName).expand(Collections.singletonMap(key, value)).getUrl());
    }

    public static class Builder {
        private final List<Entry> entries = new LinkedList<Entry>();

        public Builder add(Entry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder add(String label) {
            this.entries.add(new Entry(label));
            return this;
        }

        public Builder add(String label, String target) {
            this.entries.add(new Entry(label, target));
            return this;
        }

        public Builder add(String label, String targetPattern, String ... pathSegments) {
            Objects.requireNonNull(targetPattern);
            Objects.requireNonNull(pathSegments);
            Escaper esc = UrlEscapers.urlPathSegmentEscaper();
            Object[] encoded = new String[pathSegments.length];
            int i = 0;
            while (i < pathSegments.length) {
                encoded[i] = esc.escape(pathSegments[i]);
                ++i;
            }
            this.entries.add(new Entry(label, MessageFormat.format(targetPattern, encoded)));
            return this;
        }

        public Breadcrumbs build() {
            return new Breadcrumbs(this.entries);
        }

        public void buildTo(Map<String, Object> model) {
            model.put("breadcrumbs", this.build());
        }
    }

    public static class Entry {
        private final String label;
        private final String target;

        public Entry(String label, String target) {
            this.label = label;
            this.target = target;
        }

        public Entry(String label) {
            this.label = label;
            this.target = null;
        }

        public String getLabel() {
            return this.label;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isLink() {
            return this.target != null && !this.target.isEmpty();
        }
    }
}

