/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.maven.upload.ArtifactNotFoundException;
import org.eclipse.packagedrone.repo.adapter.maven.upload.ChecksumValidationException;
import org.eclipse.packagedrone.repo.adapter.maven.upload.Coordinates;
import org.eclipse.packagedrone.repo.adapter.maven.upload.InvalidChecksumException;
import org.eclipse.packagedrone.repo.adapter.maven.upload.MultipleArtifactsFoundException;
import org.eclipse.packagedrone.repo.adapter.maven.upload.UploadTarget;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;

public class ChannelUploadTarget
implements UploadTarget {
    private static final MetaKey KEY_EXTENSION = new MetaKey("mvn", "extension");
    private static final MetaKey KEY_CLASSIFIER = new MetaKey("mvn", "classifier");
    private static final MetaKey KEY_SNAPSHOT_VERSION = new MetaKey("mvn", "snapshotVersion");
    private static final MetaKey KEY_VERSION = new MetaKey("mvn", "version");
    private static final MetaKey KEY_ARTIFACT_ID = new MetaKey("mvn", "artifactId");
    private static final MetaKey KEY_GROUP_ID = new MetaKey("mvn", "groupId");
    private final ModifiableChannel channel;

    public ChannelUploadTarget(ModifiableChannel channel) {
        this.channel = channel;
    }

    @Override
    public String createArtifact(String parentId, Coordinates coordinates, InputStream stream, Map<MetaKey, String> metaData) throws IOException {
        HashMap<MetaKey, String> providedMetaData = new HashMap<MetaKey, String>();
        if (metaData != null) {
            providedMetaData.putAll(metaData);
        }
        ChannelUploadTarget.fillMetaData(coordinates, providedMetaData);
        ArtifactInformation result = this.channel.getContext().createArtifact(parentId, stream, coordinates.toFileName(), providedMetaData);
        if (result != null) {
            return result.getId();
        }
        return null;
    }

    @Override
    public Set<String> findArtifacts(Coordinates coordinates) {
        return this.internalFindArtifacts(coordinates).stream().map(ArtifactInformation::getId).collect(Collectors.toSet());
    }

    @Override
    public void validateChecksum(Coordinates coordinates, String algorithm, String value) throws ChecksumValidationException {
        Collection<ArtifactInformation> arts = this.internalFindArtifacts(coordinates);
        if (arts.isEmpty()) {
            throw new ArtifactNotFoundException(coordinates);
        }
        if (arts.size() > 1) {
            throw new MultipleArtifactsFoundException(coordinates, arts);
        }
        ArtifactInformation art = arts.iterator().next();
        String actualValue = (String)art.getMetaData().get(new MetaKey("hasher", algorithm));
        if (actualValue == null) {
            return;
        }
        if (!actualValue.equalsIgnoreCase(value)) {
            throw new InvalidChecksumException(coordinates, value, actualValue);
        }
    }

    protected Collection<ArtifactInformation> internalFindArtifacts(Coordinates coordinates) {
        String name = coordinates.toFileName();
        HashMap<MetaKey, String> search = new HashMap<MetaKey, String>();
        ChannelUploadTarget.fillMetaData(coordinates, search);
        List candidates = this.channel.findByName(name);
        return candidates.stream().filter(a -> ChannelUploadTarget.matches(a.getMetaData(), search)).collect(Collectors.toList());
    }

    private static boolean matches(Map<MetaKey, String> metaData, Map<MetaKey, String> search) {
        if (metaData.size() < search.size()) {
            return false;
        }
        for (Map.Entry<MetaKey, String> entry : search.entrySet()) {
            String otherEntry = metaData.get(entry.getKey());
            if (otherEntry == entry.getValue()) continue;
            if (otherEntry == null) {
                return false;
            }
            return otherEntry.equals(entry.getValue());
        }
        return true;
    }

    private static void fillMetaData(Coordinates c, Map<MetaKey, String> metaData) {
        metaData.put(KEY_GROUP_ID, c.getGroupId());
        metaData.put(KEY_ARTIFACT_ID, c.getArtifactId());
        metaData.put(KEY_VERSION, c.getVersion());
        metaData.put(KEY_SNAPSHOT_VERSION, c.getQualifiedVersion());
        metaData.put(KEY_CLASSIFIER, c.getClassifier());
        metaData.put(KEY_EXTENSION, c.getExtension());
    }
}

