/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.eclipse.packagedrone.utils.converter.ConvertBy;
import org.eclipse.packagedrone.utils.converter.ConverterManager;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binder;
import org.eclipse.packagedrone.web.controller.binding.Binding;
import org.eclipse.packagedrone.web.controller.binding.BindingManager;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParameterBinder
implements Binder {
    private static final Logger logger = LoggerFactory.getLogger(RequestParameterBinder.class);
    private final HttpServletRequest request;

    public RequestParameterBinder(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public Binding performBind(BindTarget target, ConverterManager converter, BindingManager bindingManager) {
        RequestParameter rp = target.getAnnotation(RequestParameter.class);
        if (rp == null) {
            return null;
        }
        Class<Part> type = target.getType();
        if (type.isAssignableFrom(Part.class)) {
            try {
                Part value = this.request.getPart(rp.value());
                return Binding.simpleBinding(value);
            }
            catch (Exception exception) {
                logger.info("Failed to get part '{}'", (Object)rp.value());
                return null;
            }
        }
        String valueString = this.request.getParameter(rp.value());
        try {
            if (valueString == null) {
                if (rp.required()) {
                    throw new IllegalStateException(String.format("Request parameter '%s' is required but missing.", rp.value()));
                }
                Object value = converter.convertToBy(null, type, () -> target.getAnnotationsByType(ConvertBy.class));
                return Binding.simpleBinding(value);
            }
            Object value = converter.convertToBy((Object)valueString, type, () -> target.getAnnotationsByType(ConvertBy.class));
            return Binding.simpleBinding(value);
        }
        catch (Exception e) {
            logger.debug("Failed to bind", (Throwable)e);
            return Binding.errorBinding(e);
        }
    }
}

