/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.tags;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.utils.Strings;
import org.eclipse.packagedrone.web.util.Requests;

public class Functions {
    private static final Comparator<Object> COMPARATOR = new AnyComparator();
    private static final MessageDigest MD;

    static {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        MD = md;
    }

    public static String active(HttpServletRequest request, String targetUrl) {
        if (targetUrl == null) {
            return "";
        }
        return Requests.getOriginalPath(request).equals(targetUrl) ? "active" : "";
    }

    public static String toFirstUpper(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    public static String gravatar(String email) {
        if (email == null || MD == null) {
            return null;
        }
        if (email.isEmpty()) {
            return null;
        }
        try {
            return Strings.hex((byte[])MD.digest(email.getBytes("CP1252")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String json(Object object) {
        Gson gson = new GsonBuilder().create();
        return gson.toJson(object);
    }

    public static List<?> sort(Collection<?> items) {
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(items);
        Collections.sort(result, COMPARATOR);
        return result;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Date toDate(Instant instant) {
        return Date.from(instant);
    }

    public static String limit(String value, int length, String ellipsis) {
        if (value == null || value.length() < length) {
            return value;
        }
        if (length <= 0) {
            return "";
        }
        if (ellipsis == null) {
            ellipsis = "\u2026";
        }
        return String.valueOf(value.substring(0, length)) + ellipsis;
    }

    private static class AnyComparator
    implements Comparator<Object> {
        private AnyComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

