/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.controller;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.sec.web.controller.AbstractSecurityControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.web.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredControllerInterceptor
extends AbstractSecurityControllerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SecuredControllerInterceptor.class);

    public RequestHandler before(Object controller, Method m, HttpServletRequest request, HttpServletResponse response, BiFunction<HttpServletRequest, HttpServletResponse, RequestHandler> next) throws Exception {
        Secured s = m.getAnnotation(Secured.class);
        if (s == null) {
            s = controller.getClass().getAnnotation(Secured.class);
        }
        logger.trace("Checking secured: {} for {}", (Object)s, (Object)request);
        if (s == null) {
            return next.apply(request, response);
        }
        Principal p = request.getUserPrincipal();
        logger.trace("Principal: {}", (Object)p);
        if (p == null && s.value()) {
            return this.handleLoginRequired(request, response);
        }
        return next.apply(request, response);
    }
}

