/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rap.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapterImpl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class ThemeAdapterManager {
    private final Map<Class<? extends Widget>, ThemeAdapter> themeAdapters = new HashMap<Class<? extends Widget>, ThemeAdapter>();

    public void reset() {
        this.themeAdapters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeAdapter getThemeAdapter(Widget widget) {
        ThemeAdapter result;
        Class<?> widgetClass = widget.getClass();
        Map<Class<? extends Widget>, ThemeAdapter> map = this.themeAdapters;
        synchronized (map) {
            result = this.themeAdapters.get(widgetClass);
            if (result == null) {
                ThemeAdapter adapter = ThemeAdapterManager.findThemeAdapter(widgetClass);
                this.themeAdapters.put(widgetClass, adapter);
                result = adapter;
            }
        }
        ThemeAdapterManager.ensureThemeAdapterWasFound(widgetClass, result);
        return result;
    }

    private static ThemeAdapter findThemeAdapter(Class<? extends Widget> widgetClass) {
        ThemeAdapter result = null;
        Class<? extends Widget> superClass = widgetClass;
        while (!Object.class.equals(superClass) && result == null) {
            result = ThemeAdapterManager.loadThemeAdapter(superClass);
            if (result != null) continue;
            superClass = superClass.getSuperclass();
        }
        return result;
    }

    private static ThemeAdapter loadThemeAdapter(Class<?> superClass) {
        String[] variants;
        if (superClass == Control.class) {
            return new ControlThemeAdapterImpl();
        }
        String className = superClass.getSimpleName();
        String[] stringArray = variants = LifeCycleAdapterUtil.getKitPackageVariants(superClass.getName());
        int n = variants.length;
        int n2 = 0;
        while (n2 < n) {
            String variant = stringArray[n2];
            String classToLoad = variant + "." + className + "ThemeAdapter";
            ThemeAdapter adapter = ThemeAdapterManager.loadThemeAdapter(classToLoad, superClass.getClassLoader());
            if (adapter != null) {
                return adapter;
            }
            ++n2;
        }
        return null;
    }

    private static ThemeAdapter loadThemeAdapter(String className, ClassLoader classLoader) {
        try {
            return (ThemeAdapter)ClassUtil.newInstance(classLoader, className);
        }
        catch (ClassInstantiationException classInstantiationException) {
            return null;
        }
    }

    private static void ensureThemeAdapterWasFound(Class<? extends Widget> widgetClass, ThemeAdapter result) {
        if (result == null) {
            String msg = "Failed to obtain theme adapter for class: " + widgetClass.getName();
            throw new ThemeManagerException(msg);
        }
    }
}

