/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.contributions.IContributionFactorySpi;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class ReflectionContributionFactory
implements IContributionFactory {
    private IExtensionRegistry registry;
    private Map<String, Object> languages;

    public ReflectionContributionFactory(IExtensionRegistry registry) {
        this.registry = registry;
        this.processLanguages();
    }

    public Object create(String uriString, IEclipseContext context, IEclipseContext staticContext) {
        return this.doCreate(uriString, context, staticContext);
    }

    public Object create(String uriString, IEclipseContext context) {
        return this.doCreate(uriString, context, null);
    }

    private Object doCreate(String uriString, IEclipseContext context, IEclipseContext staticContext) {
        Object contribution;
        URI uri;
        Bundle bundle;
        if (uriString == null) {
            return null;
        }
        if (uriString.startsWith("platform:/plugin/")) {
            Activator.log(1, "platform-style URIs deprecated for referencing types: " + uriString);
            uriString = uriString.replace("platform:/plugin/", "bundleclass://");
            Activator.log(1, "URI rewritten as: " + uriString);
        }
        if ((bundle = this.getBundle(uri = URI.createURI((String)uriString))) != null) {
            contribution = this.createFromBundle(bundle, context, staticContext, uri);
        } else {
            contribution = null;
            Activator.log(1, "Unable to retrieve the bundle from the URI: " + uriString);
        }
        return contribution;
    }

    protected Object createFromBundle(Bundle bundle, IEclipseContext context, IEclipseContext staticContext, URI uri) {
        Object contribution;
        if (uri.segmentCount() > 1) {
            String prefix = uri.segment(0);
            IContributionFactorySpi factory = (IContributionFactorySpi)this.languages.get(prefix);
            if (factory == null) {
                String message = "Unsupported contribution factory type '" + prefix + "'";
                Activator.log(1, message);
                return null;
            }
            StringBuffer resource = new StringBuffer(uri.segment(1));
            int i = 2;
            while (i < uri.segmentCount()) {
                resource.append('/');
                resource.append(uri.segment(i));
                ++i;
            }
            contribution = factory.create(bundle, resource.toString(), context);
        } else {
            String clazz = uri.segment(0);
            try {
                Class targetClass = bundle.loadClass(clazz);
                contribution = staticContext == null ? ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context) : ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context, (IEclipseContext)staticContext);
                if (contribution == null) {
                    String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                    Activator.log(1, message, new Exception());
                }
            }
            catch (ClassNotFoundException e) {
                contribution = null;
                String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                Activator.log(1, message, e);
            }
            catch (InjectionException e) {
                contribution = null;
                String message = "Unable to create class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                Activator.log(1, message, e);
            }
        }
        return contribution;
    }

    protected void processLanguages() {
        this.languages = new HashMap<String, Object>();
        String extId = "org.eclipse.e4.languages";
        IConfigurationElement[] languageElements = this.registry.getConfigurationElementsFor(extId);
        int i = 0;
        while (i < languageElements.length) {
            IConfigurationElement languageElement = languageElements[i];
            try {
                this.languages.put(languageElement.getAttribute("name"), languageElement.createExecutableExtension("contributionFactory"));
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected Bundle getBundle(URI platformURI) {
        if (platformURI.authority() == null) {
            Activator.log(1, "Failed to get bundle for: " + String.valueOf(platformURI));
            return null;
        }
        return Activator.getDefault().getBundleForName(platformURI.authority());
    }

    public Bundle getBundle(String uriString) {
        URI uri = URI.createURI((String)uriString);
        return this.getBundle(uri);
    }
}

