/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.android.AndroidLocaleAttribute;
import org.eclipse.sequoyah.localization.android.AndroidLocalizationPlugin;
import org.eclipse.sequoyah.localization.android.IAndroidLocalizationSchemaConstants;
import org.eclipse.sequoyah.localization.android.datamodel.AndroidStringLocalizationFile;
import org.eclipse.sequoyah.localization.android.i18n.Messages;
import org.eclipse.sequoyah.localization.android.manager.ILocalizationFileManager;
import org.eclipse.sequoyah.localization.android.manager.ImageLocalizationFileManager;
import org.eclipse.sequoyah.localization.android.manager.LocalizationFileManagerFactory;
import org.eclipse.sequoyah.localization.android.manager.SoundLocalizationFileManager;
import org.eclipse.sequoyah.localization.android.manager.StringLocalizationFileManager;
import org.eclipse.sequoyah.localization.android.manager.VideoLocalizationFileManager;
import org.eclipse.sequoyah.localization.editor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.datatype.TranslationInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.ImageLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleAttribute;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;
import org.eclipse.sequoyah.localization.tools.datamodel.SoundLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.StringLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.VideoLocalizationFile;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslateColumnInputDialog;
import org.eclipse.sequoyah.localization.tools.extensions.implementation.generic.TranslateColumnsInputDialog;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.sequoyah.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidLocalizationSchema
extends ILocalizationSchema
implements IAndroidLocalizationSchemaConstants {
    private static final HashMap<Class, Class> typesMap = new HashMap();

    static {
        typesMap.put(StringLocalizationFile.class, StringLocalizationFileManager.class);
        typesMap.put(AndroidStringLocalizationFile.class, StringLocalizationFileManager.class);
        typesMap.put(ImageLocalizationFile.class, ImageLocalizationFileManager.class);
        typesMap.put(SoundLocalizationFile.class, SoundLocalizationFileManager.class);
        typesMap.put(VideoLocalizationFile.class, VideoLocalizationFileManager.class);
    }

    public List<String> getPreferedLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (AndroidLocalizationPlugin.getDefault().getBundle().getEntry("resource/prefered_languages.xml") != null) {
                InputStream inputStream = AndroidLocalizationPlugin.getDefault().getBundle().getEntry("resource/prefered_languages.xml").openStream();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName("language");
                int n = 0;
                while (n < nodeList.getLength()) {
                    Element element2 = (Element)nodeList.item(n);
                    arrayList.add(element2.getAttributeNode("id").getNodeValue());
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            BasePlugin.logError((String)"Could not load prefered languages for Android Localization Schema");
        }
        return arrayList;
    }

    public String getIDforLanguage(String string) {
        String string2 = "values";
        if (string.contains("-")) {
            String[] stringArray = string.split("-");
            string2 = String.valueOf(string2) + "-" + stringArray[0] + "-" + "r" + stringArray[1];
        } else {
            string2 = String.valueOf(string2) + "-" + string;
        }
        return string2;
    }

    public IStatus isValueValid(String string, String string2, String string3) {
        Status status = new Status(0, "org.eclipse.sequoyah.localization.android", "");
        if (string.toLowerCase().equals("values".toLowerCase())) {
            if (string3 == null) {
                status = new Status(4, "org.eclipse.sequoyah.localization.android", Messages.EmptyKey_Discouraged);
            }
            if (string3 == null || string3.length() == 0) {
                status = new Status(2, "org.eclipse.sequoyah.localization.android", Messages.EmptyKey_Discouraged);
            }
        }
        return status;
    }

    public IStatus isKeyValid(String string) {
        Status status = new Status(0, "org.eclipse.sequoyah.localization.android", "");
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            boolean bl;
            boolean bl2 = bl = n > 0 ? Character.isJavaIdentifierPart(cArray[n]) : Character.isJavaIdentifierStart(cArray[n]);
            if (!bl) {
                status = new Status(4, "org.eclipse.sequoyah.localization.android", Messages.bind((String)Messages.Invalid_Andr_Key_Name, (Object)("'" + cArray[n] + "'")));
                break;
            }
            ++n;
        }
        return status;
    }

    public ColumnInfo promptCollumnName(final IProject iProject) {
        ColumnInfo columnInfo = null;
        InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), NEW_COLUMN_TITLE, NEW_COLUMN_DESCRIPTION, "values", new IInputValidator(){

            public String isValid(String string) {
                return AndroidLocalizationSchema.this.isValid2(string, iProject);
            }
        });
        if (inputDialog.open() == 0) {
            columnInfo = new ColumnInfo(inputDialog.getValue(), inputDialog.getValue(), null, true);
        }
        return columnInfo;
    }

    public RowInfo[] promptSingleRowName(IProject iProject, int n) {
        RowInfo[] rowInfoArray = new RowInfo[n];
        String[] stringArray = this.getAutomaticKeys(iProject, false, n);
        int n2 = 0;
        while (n2 < n) {
            RowInfoLeaf rowInfoLeaf = new RowInfoLeaf(stringArray[n2], null, -1, null);
            rowInfoArray[n2] = rowInfoLeaf;
            ++n2;
        }
        return rowInfoArray;
    }

    public RowInfo[] promptArrayRowName(IProject iProject, int n) {
        RowInfo[] rowInfoArray = null;
        String[] stringArray = this.getAutomaticKeys(iProject, true, n);
        rowInfoArray = new RowInfo[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            RowInfo rowInfo = new RowInfo(stringArray[n2]);
            int n3 = 1;
            int n4 = 0;
            while (n4 < n3) {
                rowInfo.addChild(new RowInfoLeaf(stringArray[n2], rowInfo, n4, null), Integer.valueOf(0));
                ++n4;
            }
            rowInfoArray[n2] = rowInfo;
            ++n2;
        }
        return rowInfoArray;
    }

    private String[] getAutomaticKeys(IProject iProject, boolean bl, int n) {
        String[] stringArray = new String[n];
        try {
            String string = bl ? Messages.AndroidLocalizationSchema_NewArrayKeyPrefix : Messages.AndroidLocalizationSchema_NewStringKeyPrefix;
            int n2 = 0;
            ProjectLocalizationManager projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(iProject, false);
            ILocalizationSchema iLocalizationSchema = projectLocalizationManager.getProjectLocalizationSchema();
            LocaleInfo localeInfo = iLocalizationSchema.getLocaleInfoFromID(iLocalizationSchema.getDefaultID());
            if (localeInfo != null) {
                LocalizationFile localizationFile = projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
                int n3 = 0;
                while (n3 < n) {
                    stringArray[n3] = String.valueOf(string) + n2;
                    while (((StringLocalizationFile)localizationFile).containsKey(stringArray[n3])) {
                        stringArray[n3] = String.valueOf(string) + ++n2;
                    }
                    ++n3;
                    ++n2;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SequoyahException sequoyahException) {}
        return stringArray;
    }

    public TranslationInfo promptTranslatedCollumnName(final IProject iProject, String string) {
        TranslationInfo translationInfo = null;
        TranslateColumnInputDialog translateColumnInputDialog = new TranslateColumnInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, string, NEW_TRANSLATE_COLUMN_TITLE, NEW_COLUMN_DESCRIPTION, "values", new IInputValidator(){

            public String isValid(String string) {
                return AndroidLocalizationSchema.this.isValid2(string, iProject);
            }
        });
        if (translateColumnInputDialog.open() == 0) {
            translationInfo = new TranslationInfo(translateColumnInputDialog.getValue(), translateColumnInputDialog.getValue(), null, true, translateColumnInputDialog.getFromLanguage(), translateColumnInputDialog.getToLanguage(), null, translateColumnInputDialog.getTranslator());
        }
        return translationInfo;
    }

    public TranslationInfo[] promptTranslatedCollumnsName(IProject iProject, String string, String[] stringArray, String[] stringArray2, TreeColumn[] treeColumnArray) {
        TranslationInfo[] translationInfoArray = null;
        TranslateColumnsInputDialog translateColumnsInputDialog = new TranslateColumnsInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, string, stringArray2, treeColumnArray, TRANSLATE_CELLS_TITLE);
        if (translateColumnsInputDialog.open() == 0) {
            List list = translateColumnsInputDialog.getDestinationColumns();
            translationInfoArray = new TranslationInfo[stringArray2.length * list.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string2 = stringArray2[n2];
                String string3 = stringArray[n2];
                int n3 = 0;
                while (n3 < list.size()) {
                    TranslateColumnsInputDialog.DestinationColumn destinationColumn = (TranslateColumnsInputDialog.DestinationColumn)list.get(n3);
                    translationInfoArray[n] = new TranslationInfo(destinationColumn.getText(), destinationColumn.getText(), null, true, translateColumnsInputDialog.getFromLanguage(), destinationColumn.getLang(), string2, translateColumnsInputDialog.getTranslator());
                    translationInfoArray[n].setFromKey(string3);
                    translationInfoArray[n].setToColumn(destinationColumn.getText());
                    ++n;
                    ++n3;
                }
                ++n2;
            }
        }
        return translationInfoArray;
    }

    public TranslationInfo[] promptTranslatedCollumnsName(IProject iProject, String string, String[] stringArray, String[] stringArray2, Integer[] integerArray, TreeColumn[] treeColumnArray) {
        TranslationInfo[] translationInfoArray = null;
        TranslateColumnsInputDialog translateColumnsInputDialog = new TranslateColumnsInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iProject, string, stringArray2, treeColumnArray, TRANSLATE_CELLS_TITLE);
        if (translateColumnsInputDialog.open() == 0) {
            List list = translateColumnsInputDialog.getDestinationColumns();
            translationInfoArray = new TranslationInfo[stringArray2.length * list.size()];
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string2 = stringArray2[n2];
                String string3 = stringArray[n2];
                int n3 = 0;
                while (n3 < list.size()) {
                    TranslateColumnsInputDialog.DestinationColumn destinationColumn = (TranslateColumnsInputDialog.DestinationColumn)list.get(n3);
                    translationInfoArray[n] = new TranslationInfo(destinationColumn.getText(), destinationColumn.getText(), null, true, translateColumnsInputDialog.getFromLanguage(), destinationColumn.getLang(), string2, translateColumnsInputDialog.getTranslator());
                    translationInfoArray[n].setFromKey(string3);
                    translationInfoArray[n].setToColumn(destinationColumn.getText());
                    translationInfoArray[n].setIndexKey(integerArray[n2]);
                    ++n;
                    ++n3;
                }
                ++n2;
            }
        }
        return translationInfoArray;
    }

    private String isValid2(String string, IProject iProject) {
        String string2 = null;
        if (string.startsWith("values")) {
            AndroidLocalizationSchema androidLocalizationSchema = new AndroidLocalizationSchema();
            String string3 = string.replace("values", "");
            LocaleInfo localeInfo = androidLocalizationSchema.getLocaleInfoFromID(string3);
            ProjectLocalizationManager projectLocalizationManager = null;
            try {
                projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(iProject, false);
            }
            catch (IOException iOException) {
            }
            catch (SequoyahException sequoyahException) {}
            if (localeInfo.getLocaleAttributes().size() > 0 || string.equalsIgnoreCase("values")) {
                LocalizationFile localizationFile = projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
                if (localizationFile != null && !localizationFile.isToBeDeleted()) {
                    string2 = Messages.AndroidNewColumnProvider_Dialog_FileAlreadyExists;
                }
            } else {
                string2 = NEW_COLUMN_INVALID_ID;
            }
        } else {
            string2 = NEW_COLUMN_INVALID_ID;
        }
        return string2;
    }

    public String getEditorName() {
        return Messages.AndroidStringEditorInput_EditorTooltip;
    }

    public void createLocalizationFile(LocalizationFile localizationFile) throws SequoyahException {
        Class clazz = typesMap.get(localizationFile.getClass());
        ILocalizationFileManager iLocalizationFileManager = LocalizationFileManagerFactory.getInstance().createLocalizationFileManager(clazz.getName());
        iLocalizationFileManager.createFile(localizationFile);
    }

    public String getLocaleToolTip(IPath iPath) {
        LocaleInfo localeInfo = this.getLocaleInfoFromPath(iPath);
        List list = localeInfo.getLocaleAttributes();
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string.length() > 0) {
                string = String.valueOf(string) + "\n ";
            }
            LocaleAttribute localeAttribute = (LocaleAttribute)iterator.next();
            string = String.valueOf(string) + ((AndroidLocaleAttribute)localeAttribute).getDisplayName() + ": " + ((AndroidLocaleAttribute)localeAttribute).getDisplayValue();
        }
        if (string.length() == 0) {
            string = DEFAULT_LOCALE_TOOLTIP;
        }
        return string;
    }

    public List<LocaleAttribute> getLocaleAttributes() {
        ArrayList<LocaleAttribute> arrayList = new ArrayList<LocaleAttribute>();
        arrayList.add(new AndroidLocaleAttribute(new Integer(123), AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(new Integer(0), AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.REGION.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(new Integer(12), AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(null, AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()));
        arrayList.add(new AndroidLocaleAttribute(new Dimension(1, 1), AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()));
        return arrayList;
    }

    public List<String> getLocalizationFileExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("xml");
        return arrayList;
    }

    public Map<LocaleInfo, IFile> getLocalizationFiles(IProject iProject) {
        LinkedHashMap<LocaleInfo, IFile> linkedHashMap;
        block12: {
            linkedHashMap = new LinkedHashMap<LocaleInfo, IFile>();
            boolean bl = false;
            try {
                IFolder iFolder;
                IFolder iFolder2;
                IResource iResource = iProject.findMember("res");
                if (iResource != null && iResource instanceof IFolder && (iFolder2 = ((IFolder)iResource).members()) != null) {
                    IFolder iFolder3 = iFolder2;
                    int n = ((IFolder)iFolder3).length;
                    int n2 = 0;
                    while (n2 < n) {
                        iFolder = iFolder3[n2];
                        if (iFolder.getName().startsWith("values")) {
                            IResource[] iResourceArray;
                            IResource[] iResourceArray2 = iResourceArray = iFolder.members();
                            int n3 = iResourceArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IResource iResource2 = iResourceArray2[n4];
                                if (iResource2 instanceof IFile && this.isLocalizationFile((IFile)iResource2)) {
                                    linkedHashMap.put(this.getLocaleInfoFromPath(iResource2.getProjectRelativePath()), (IFile)iResource2);
                                    if (iFolder.getName().equals("values")) {
                                        bl = true;
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                if (bl || !(iResource instanceof IFolder)) break block12;
                iFolder2 = (IFolder)iResource;
                iFolder = iFolder2.getFolder("values");
                try {
                    if (!iFolder.exists()) {
                        PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    iFolder.create(true, true, iProgressMonitor);
                                }
                                catch (CoreException coreException) {}
                            }
                        });
                    }
                    if (iFolder.exists()) {
                        IFile iFile = iFolder.getFile("strings.xml");
                        linkedHashMap.put(this.getLocaleInfoFromPath(iFile.getProjectRelativePath()), iFile);
                    }
                }
                catch (Exception exception) {}
            }
            catch (CoreException coreException) {}
        }
        return linkedHashMap;
    }

    public boolean isLocalizationFile(IFile iFile) {
        boolean bl = false;
        if (iFile != null && iFile.getProjectRelativePath().toString().matches("res/values.*/strings.xml")) {
            bl = true;
        }
        return bl;
    }

    public Map<LocaleInfo, LocalizationFile> loadAllFiles(IProject iProject) throws SequoyahException {
        LinkedHashMap<LocaleInfo, LocalizationFile> linkedHashMap = new LinkedHashMap<LocaleInfo, LocalizationFile>();
        Map<LocaleInfo, IFile> map = this.getLocalizationFiles(iProject);
        for (Map.Entry<LocaleInfo, IFile> entry : map.entrySet()) {
            String string = entry.getValue().getName();
            if (!string.endsWith("strings.xml")) continue;
            linkedHashMap.put(entry.getKey(), this.loadFile(StringLocalizationFileManager.class.getName(), entry.getValue()));
        }
        return linkedHashMap;
    }

    public LocalizationFile loadFile(String string, IFile iFile) throws SequoyahException {
        ILocalizationFileManager iLocalizationFileManager = LocalizationFileManagerFactory.getInstance().createLocalizationFileManager(string);
        LocalizationFileBean localizationFileBean = new LocalizationFileBean(new LocalizationFile());
        AndroidStringLocalizationFile androidStringLocalizationFile = new AndroidStringLocalizationFile(localizationFileBean);
        androidStringLocalizationFile.setLocaleInfo(this.getLocaleInfoFromPath(iFile.getFullPath()));
        androidStringLocalizationFile.setFile(iFile);
        LocalizationFile localizationFile = iLocalizationFileManager.loadFile((LocalizationFile)androidStringLocalizationFile);
        return localizationFile;
    }

    public void updateFile(LocalizationFile localizationFile) throws SequoyahException {
        Class clazz = typesMap.get(localizationFile.getClass());
        ILocalizationFileManager iLocalizationFileManager = LocalizationFileManagerFactory.getInstance().createLocalizationFileManager(clazz.getName());
        iLocalizationFileManager.updateFile(localizationFile);
    }

    public LocalizationFile createLocalizationFile(LocalizationFileBean localizationFileBean) {
        localizationFileBean.setType(AndroidStringLocalizationFile.class.getName());
        AndroidStringLocalizationFile androidStringLocalizationFile = new AndroidStringLocalizationFile(localizationFileBean);
        return androidStringLocalizationFile;
    }

    public Object getLocalizationFileContent(LocalizationFile localizationFile) {
        Class clazz = typesMap.get(localizationFile.getClass());
        ILocalizationFileManager iLocalizationFileManager = LocalizationFileManagerFactory.getInstance().createLocalizationFileManager(clazz.getName());
        return iLocalizationFileManager.getLocalizationFileContent(localizationFile);
    }

    public void updateLocalizationFileContent(LocalizationFile localizationFile, String string) throws SequoyahException {
        Class clazz = typesMap.get(localizationFile.getClass());
        ILocalizationFileManager iLocalizationFileManager = LocalizationFileManagerFactory.getInstance().createLocalizationFileManager(clazz.getName());
        iLocalizationFileManager.updateLocalizationFileContent(localizationFile, string);
    }

    public boolean keyAcceptsBlankSpaces() {
        return false;
    }

    private boolean isKnownNode(Node node) {
        return node.getNodeName().equals("string") || node.getNodeName().equals("string-array");
    }

    private LocaleInfo getLocaleInfoFromPath(IPath iPath) {
        IPath iPath2 = iPath;
        iPath2 = iPath.removeLastSegments(1);
        String string = iPath2.lastSegment();
        String string2 = string.replace("values", "");
        return this.getLocaleInfoFromID(string2);
    }

    public String getPathFromLocaleInfo(LocaleInfo localeInfo) {
        String string = localeInfo.getLocaleAttributes().size() > 0 ? "res" + File.separator + "values" + "-" + this.getLocaleID(localeInfo) + File.separator + "strings.xml" : "res" + File.separator + "values" + File.separator + "strings.xml";
        return string;
    }

    public String getLocaleID(LocaleInfo localeInfo) {
        String string = "";
        List list = localeInfo.getLocaleAttributes();
        for (LocaleAttribute localeAttribute : list) {
            if (!((AndroidLocaleAttribute)localeAttribute).isSet()) continue;
            if (string.length() != 0) {
                string = String.valueOf(string) + "-";
            }
            string = String.valueOf(string) + localeAttribute.getFolderValue();
        }
        return string;
    }

    public LocaleInfo getLocaleInfoFromID(String string) {
        LocaleInfo localeInfo = new LocaleInfo();
        String[] stringArray = string.split("-");
        int n = -1;
        ArrayList<AndroidLocaleAttribute> arrayList = new ArrayList<AndroidLocaleAttribute>();
        int n2 = 1;
        while (n2 < stringArray.length) {
            if (!stringArray[n2].equals("")) {
                if (this.isCountryCodeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.COUNTRY_CODE.ordinal()));
                } else if (this.isNetworkCodeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NETWORK_CODE.ordinal()));
                } else if (this.isLanguageSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal()));
                } else if (this.isRegionSegment(stringArray[n2]) && n == AndroidLocaleAttribute.AndroidLocaleAttributes.LANGUAGE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.REGION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.REGION.ordinal()));
                } else if (this.isScreenSizeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_SIZE.ordinal()));
                } else if (this.isScreenAspectSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()));
                } else if (this.isOrientationSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()));
                } else if (this.isDockSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.DOCK_MODE.ordinal()));
                } else if (this.isNightSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NIGHT_MODE.ordinal()));
                } else if (this.isPixelDensitySegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()));
                } else if (this.isTouchTypeSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.TOUCH_TYPE.ordinal()));
                } else if (this.isKeyboardStateSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()));
                } else if (this.isTextInputSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()));
                } else if (this.isNavigationKeySegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()));
                } else if (this.isNavigationSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()));
                } else if (this.isDimensionSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()));
                } else if (this.isAPIVersionSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.API_VERSION.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.API_VERSION.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.API_VERSION.ordinal()));
                } else if (this.isSmallestWidthSegment(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.SMALLEST_WIDTH.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.SMALLEST_WIDTH.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.SMALLEST_WIDTH.ordinal()));
                } else if (this.isAvailableWidth(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.AVAILABLE_WIDTH.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.AVAILABLE_WIDTH.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.AVAILABLE_WIDTH.ordinal()));
                } else if (this.isAvailableHeight(stringArray[n2]) && n < AndroidLocaleAttribute.AndroidLocaleAttributes.AVAILABLE_HEIGHT.ordinal()) {
                    n = AndroidLocaleAttribute.AndroidLocaleAttributes.AVAILABLE_HEIGHT.ordinal();
                    arrayList.add(new AndroidLocaleAttribute(stringArray[n2], AndroidLocaleAttribute.AndroidLocaleAttributes.AVAILABLE_HEIGHT.ordinal()));
                } else {
                    arrayList = new ArrayList();
                }
            }
            ++n2;
        }
        localeInfo.setLocaleAttributes(arrayList);
        return localeInfo;
    }

    public String getISO639LangFromID(String string) {
        String string2 = null;
        LocaleInfo localeInfo = this.getLocaleInfoFromID(string);
        for (LocaleAttribute localeAttribute : localeInfo.getLocaleAttributes()) {
            if (!localeAttribute.getDisplayName().equals("Language")) continue;
            string2 = localeAttribute.getFolderValue();
        }
        return string2;
    }

    public String getDefaultID() {
        return "values";
    }

    private boolean isScreenAspectSegment(String string) {
        return string.equalsIgnoreCase("long") || string.equalsIgnoreCase("notlong");
    }

    private boolean isDockSegment(String string) {
        return string.equalsIgnoreCase("car") || string.equalsIgnoreCase("desk");
    }

    private boolean isNightSegment(String string) {
        return string.equalsIgnoreCase("night") || string.equalsIgnoreCase("notnight");
    }

    private boolean isNavigationKeySegment(String string) {
        return string.equalsIgnoreCase("navexposed") || string.equalsIgnoreCase("navhidden");
    }

    private boolean isLanguageSegment(String string) {
        return string.length() == 2;
    }

    private boolean isRegionSegment(String string) {
        return string.startsWith("r") && string.length() == 3;
    }

    private boolean isOrientationSegment(String string) {
        return string.equalsIgnoreCase("port") || string.equalsIgnoreCase("land") || string.equalsIgnoreCase("square");
    }

    private boolean isPixelDensitySegment(String string) {
        return string.endsWith("dpi");
    }

    private boolean isTouchTypeSegment(String string) {
        return string.equalsIgnoreCase("notouch") || string.equalsIgnoreCase("stylus") || string.equalsIgnoreCase("finger");
    }

    private boolean isKeyboardStateSegment(String string) {
        return string.equalsIgnoreCase("keysexposed") || string.equalsIgnoreCase("keyshidden");
    }

    private boolean isTextInputSegment(String string) {
        return string.equalsIgnoreCase("nokeys") || string.equalsIgnoreCase("qwerty") || string.equalsIgnoreCase("12key");
    }

    private boolean isNavigationSegment(String string) {
        return string.equalsIgnoreCase("dpad") || string.equalsIgnoreCase("trackball") || string.equalsIgnoreCase("wheel") || string.equalsIgnoreCase("nonav");
    }

    private boolean isDimensionSegment(String string) {
        String[] stringArray;
        boolean bl = false;
        if (string.contains("x") && (stringArray = string.split("x")).length == 2) {
            bl = true;
        }
        return bl;
    }

    private boolean isCountryCodeSegment(String string) {
        boolean bl = false;
        if (string.startsWith("mcc") && string.length() <= 6) {
            String string2 = string;
            String string3 = string2.substring(3, string2.length());
            try {
                Integer.valueOf(Integer.parseInt(string3));
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    private boolean isNetworkCodeSegment(String string) {
        boolean bl = false;
        if (string.startsWith("mnc") && string.length() <= 6) {
            String string2 = string;
            String string3 = string2.substring(3, string2.length());
            try {
                Integer.valueOf(Integer.parseInt(string3));
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    private boolean isScreenSizeSegment(String string) {
        return string.equalsIgnoreCase("large") || string.equalsIgnoreCase("xlarge") || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("small");
    }

    private boolean isAPIVersionSegment(String string) {
        boolean bl = false;
        if (string.startsWith("v")) {
            String string2 = string;
            String string3 = string2.substring(1, string2.length());
            try {
                Integer.valueOf(Integer.parseInt(string3));
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    private boolean isSmallestWidthSegment(String string) {
        boolean bl = false;
        if (string.startsWith("sw") && string.endsWith("dp")) {
            bl = true;
            String string2 = string.substring(string.lastIndexOf("sw") + 2, string.indexOf("dp"));
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isAvailableWidth(String string) {
        boolean bl = false;
        if (string.startsWith("w") && string.endsWith("dp")) {
            bl = true;
            String string2 = string.substring(string.lastIndexOf("w") + 1, string.indexOf("dp"));
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isAvailableHeight(String string) {
        boolean bl = false;
        if (string.startsWith("h") && string.endsWith("dp")) {
            bl = true;
            String string2 = string.substring(string.lastIndexOf("h") + 1, string.indexOf("dp"));
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }
}

