/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android.manager;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.sequoyah.localization.android.IAndroidLocalizationSchemaConstants;
import org.eclipse.sequoyah.localization.android.manager.NodeManager;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;
import org.eclipse.sequoyah.localization.tools.datamodel.StringLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.node.NodeComment;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayItemNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayStringNodeManager
extends NodeManager
implements IAndroidLocalizationSchemaConstants {
    @Override
    public void loadFile(LocalizationFileBean localizationFileBean, LocalizationFile localizationFile) {
        localizationFileBean.setStringArrays(((StringLocalizationFile)localizationFile).getStringArrays());
    }

    @Override
    public void updateLocalizationFileContent(Document document, ArrayList<StringNode> arrayList) {
        NodeList nodeList = document.getElementsByTagName("string-array");
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            string = element.getAttributeNode("name").getNodeValue();
            StringArrayNode stringArrayNode = new StringArrayNode(string);
            if (element.hasChildNodes()) {
                NodeList nodeList2 = element.getElementsByTagName("item");
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    NodeList nodeList3;
                    Node node = nodeList2.item(n2);
                    Node node2 = node.getFirstChild();
                    StringBuffer stringBuffer = new StringBuffer();
                    this.getStringByNodes(stringBuffer, node2);
                    string2 = stringBuffer.toString();
                    StringArrayItemNode stringArrayItemNode = stringArrayNode.addValue(string2);
                    String string3 = null;
                    if (node.hasChildNodes()) {
                        nodeList3 = node.getChildNodes();
                        int n3 = 0;
                        while (n3 < nodeList3.getLength()) {
                            Node node3 = nodeList3.item(n3);
                            if (node3.getNodeType() == 8) {
                                string3 = node3.getNodeValue();
                            }
                            ++n3;
                        }
                    }
                    if (string3 != null) {
                        nodeList3 = new NodeComment();
                        nodeList3.setComment(string3);
                        stringArrayItemNode.setNodeComment((NodeComment)nodeList3);
                    }
                    ++n2;
                }
            }
            if (stringArrayNode.getValues().size() > 0) {
                arrayList.add((StringNode)stringArrayNode);
            }
            ++n;
        }
    }

    @Override
    public void createFile(Document document, Element element, LocalizationFile localizationFile) {
        for (StringArrayNode stringArrayNode : ((StringLocalizationFile)localizationFile).getStringArrays()) {
            this.addArrayEntry(document, element, stringArrayNode);
        }
    }

    public void addArrayEntry(Document document, Element element, StringArrayNode stringArrayNode) {
        Element element2 = document.createElement("string-array");
        element2.setAttribute("name", stringArrayNode.getKey());
        for (StringNode stringNode : stringArrayNode.getValues()) {
            this.createArrayItem(document, element2, stringNode);
        }
        element.appendChild(element2);
    }

    public void createArrayItem(Document document, Element element, StringNode stringNode) {
        Element element2 = document.createElement("item");
        element2.appendChild(document.createTextNode(stringNode.getValue() != null ? stringNode.getValue() : ""));
        element.appendChild(element2);
        this.createOrUpdateComment(document, stringNode, element2);
    }

    @Override
    public void updateFile(LocalizationFile localizationFile, Map<String, StringNode> map) {
        for (StringArrayNode stringArrayNode : ((StringLocalizationFile)localizationFile).getStringArrays()) {
            map.put(stringArrayNode.getKey(), (StringNode)stringArrayNode);
        }
    }
}

