/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import java.text.ParseException;
import org.eclipse.smarthome.automation.ModuleHandlerCallback;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseTriggerModuleHandler;
import org.eclipse.smarthome.automation.handler.TriggerHandlerCallback;
import org.eclipse.smarthome.core.scheduler.Expression;
import org.eclipse.smarthome.core.scheduler.ExpressionThreadPoolManager;
import org.eclipse.smarthome.core.scheduler.RecurrenceExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOfDayTriggerHandler
extends BaseTriggerModuleHandler
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(TimeOfDayTriggerHandler.class);
    public static final String MODULE_TYPE_ID = "timer.TimeOfDayTrigger";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    private static final String CFG_TIME = "time";
    private final ExpressionThreadPoolManager.ExpressionThreadPoolExecutor scheduler;
    private final Expression expression;

    public TimeOfDayTriggerHandler(Trigger module) {
        super(module);
        String time = module.getConfiguration().get(CFG_TIME).toString();
        try {
            String[] parts = time.split(":");
            this.expression = new RecurrenceExpression("FREQ=DAILY;BYHOUR=" + parts[0] + ";BYMINUTE=" + parts[1]);
        }
        catch (ArrayIndexOutOfBoundsException | ParseException e) {
            throw new IllegalArgumentException("'time' parameter is not in valid format 'hh:mm'.", e);
        }
        this.scheduler = ExpressionThreadPoolManager.getExpressionScheduledPool((String)"ruletimer");
    }

    public synchronized void setCallback(ModuleHandlerCallback callback) {
        super.setCallback(callback);
        this.scheduleJob();
    }

    private void scheduleJob() {
        this.scheduler.schedule((Runnable)this, this.expression);
        this.logger.debug("Scheduled job for trigger '{}' at '{}' each day.", (Object)((Trigger)this.module).getId(), ((Trigger)this.module).getConfiguration().get(CFG_TIME));
    }

    @Override
    public void run() {
        ((TriggerHandlerCallback)this.callback).triggered((Trigger)this.module, null);
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.scheduler.remove((Runnable)this)) {
            this.logger.debug("cancelled job for trigger '{}'.", (Object)((Trigger)this.module).getId());
        } else {
            this.logger.debug("Failed cancelling job for trigger '{}' - maybe it was never scheduled?", (Object)((Trigger)this.module).getId());
        }
    }
}

