/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.persistence.extensions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.smarthome.core.i18n.TimeZoneProvider;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.PersistenceServiceRegistry;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PersistenceExtensions {
    private static PersistenceServiceRegistry registry;
    private static TimeZoneProvider timeZoneProvider;

    @Reference
    protected void setPersistenceServiceRegistry(PersistenceServiceRegistry registry) {
        PersistenceExtensions.registry = registry;
    }

    protected void unsetPersistenceServiceRegistry(PersistenceServiceRegistry registry) {
        PersistenceExtensions.registry = null;
    }

    @Reference
    protected void setTimeZoneProvider(TimeZoneProvider timeZoneProvider) {
        PersistenceExtensions.timeZoneProvider = timeZoneProvider;
    }

    protected void unsetTimeZoneProvider(TimeZoneProvider timeZoneProvider) {
        PersistenceExtensions.timeZoneProvider = null;
    }

    private static PersistenceService getService(String serviceId) {
        PersistenceService service = null;
        if (registry != null) {
            service = serviceId != null ? registry.get(serviceId) : registry.getDefault();
        }
        return service;
    }

    private static String getDefaultServiceId() {
        if (registry != null) {
            String id = registry.getDefaultId();
            if (id != null) {
                return id;
            }
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no default persistence service configured!");
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("PersistenceServiceRegistryImpl is not available!");
        }
        return null;
    }

    public static void persist(Item item, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service != null) {
            service.store(item);
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no persistence service registered with the id '{}'", (Object)serviceId);
        }
    }

    public static void persist(Item item) {
        PersistenceExtensions.persist(item, PersistenceExtensions.getDefaultServiceId());
    }

    public static HistoricItem historicState(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.historicState(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static HistoricItem historicState(Item item, AbstractInstant timestamp, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setEndDate(ZonedDateTime.ofInstant(timestamp.toDate().toInstant(), timeZoneProvider.getTimeZone()));
            filter.setItemName(item.getName());
            filter.setPageSize(1);
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            Iterable result = qService.query(filter);
            if (result.iterator().hasNext()) {
                return (HistoricItem)result.iterator().next();
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        return null;
    }

    public static Boolean changedSince(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.changedSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static Boolean changedSince(Item item, AbstractInstant timestamp, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp);
        if (itemThen == null) {
            return it.hasNext();
        }
        State state = itemThen.getState();
        while (it.hasNext()) {
            HistoricItem hItem = it.next();
            if (state != null && !hItem.getState().equals(state)) {
                return true;
            }
            state = hItem.getState();
        }
        return false;
    }

    public static Boolean updatedSince(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.updatedSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static Boolean updatedSince(Item item, AbstractInstant timestamp, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceId);
        if (result.iterator().hasNext()) {
            return true;
        }
        return false;
    }

    public static HistoricItem maximumSince(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.maximumSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static HistoricItem maximumSince(final Item item, AbstractInstant timestamp, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem maximumHistoricItem = null;
        DecimalType maximum = (DecimalType)item.getStateAs(DecimalType.class);
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            State state = historicItem.getState();
            if (!(state instanceof DecimalType)) continue;
            DecimalType value = (DecimalType)state;
            if (maximum != null && value.compareTo(maximum) <= 0) continue;
            maximum = value;
            maximumHistoricItem = historicItem;
        }
        if (maximumHistoricItem == null && maximum != null) {
            final DecimalType state = maximum;
            return new HistoricItem(){

                public Date getTimestamp() {
                    return Calendar.getInstance().getTime();
                }

                public State getState() {
                    return state;
                }

                public String getName() {
                    return item.getName();
                }
            };
        }
        return maximumHistoricItem;
    }

    public static HistoricItem minimumSince(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.minimumSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static HistoricItem minimumSince(final Item item, AbstractInstant timestamp, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem minimumHistoricItem = null;
        DecimalType minimum = (DecimalType)item.getStateAs(DecimalType.class);
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            State state = historicItem.getState();
            if (!(state instanceof DecimalType)) continue;
            DecimalType value = (DecimalType)state;
            if (minimum != null && value.compareTo(minimum) >= 0) continue;
            minimum = value;
            minimumHistoricItem = historicItem;
        }
        if (minimumHistoricItem == null && minimum != null) {
            final DecimalType state = minimum;
            return new HistoricItem(){

                public Date getTimestamp() {
                    return Calendar.getInstance().getTime();
                }

                public State getState() {
                    return state;
                }

                public String getName() {
                    return item.getName();
                }
            };
        }
        return minimumHistoricItem;
    }

    public static DecimalType averageSince(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.averageSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static DecimalType averageSince(Item item, AbstractInstant timestamp, String serviceId) {
        BigDecimal timeSpan;
        BigDecimal avgValue;
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        BigDecimal total = BigDecimal.ZERO;
        DecimalType lastState = null;
        DecimalType thisState = null;
        BigDecimal lastTimestamp = null;
        BigDecimal thisTimestamp = null;
        BigDecimal firstTimestamp = null;
        while (it.hasNext()) {
            HistoricItem thisItem = it.next();
            State state = thisItem.getState();
            if (!(state instanceof DecimalType)) continue;
            thisState = (DecimalType)state;
            thisTimestamp = BigDecimal.valueOf(thisItem.getTimestamp().getTime());
            if (firstTimestamp == null) {
                firstTimestamp = thisTimestamp;
            } else {
                avgValue = thisState.toBigDecimal().add(lastState.toBigDecimal()).divide(BigDecimal.valueOf(2L), MathContext.DECIMAL64);
                timeSpan = thisTimestamp.subtract(lastTimestamp);
                total = total.add(avgValue.multiply(timeSpan, MathContext.DECIMAL64));
            }
            lastTimestamp = thisTimestamp;
            lastState = thisState;
        }
        if (lastState != null && (thisState = (DecimalType)item.getStateAs(DecimalType.class)) != null) {
            thisTimestamp = BigDecimal.valueOf(new DateTime().getMillis());
            avgValue = thisState.toBigDecimal().add(lastState.toBigDecimal()).divide(BigDecimal.valueOf(2L), MathContext.DECIMAL64);
            timeSpan = thisTimestamp.subtract(lastTimestamp);
            total = total.add(avgValue.multiply(timeSpan, MathContext.DECIMAL64));
        }
        if (thisTimestamp != null) {
            timeSpan = thisTimestamp.subtract(firstTimestamp, MathContext.DECIMAL64);
            BigDecimal average = total.divide(timeSpan, MathContext.DECIMAL64);
            return new DecimalType(average);
        }
        return null;
    }

    public static DecimalType sumSince(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.sumSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static DecimalType sumSince(Item item, AbstractInstant timestamp, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesSince(item, timestamp, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        BigDecimal sum = BigDecimal.ZERO;
        while (it.hasNext()) {
            State state = it.next().getState();
            if (!(state instanceof DecimalType)) continue;
            sum = sum.add(((DecimalType)state).toBigDecimal());
        }
        return new DecimalType(sum);
    }

    private static Iterable<HistoricItem> getAllStatesSince(Item item, AbstractInstant timestamp, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setBeginDate(ZonedDateTime.ofInstant(timestamp.toDate().toInstant(), timeZoneProvider.getTimeZone()));
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
            return qService.query(filter);
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        return Collections.emptySet();
    }

    public static AbstractInstant lastUpdate(Item item) {
        return PersistenceExtensions.lastUpdate(item, PersistenceExtensions.getDefaultServiceId());
    }

    public static AbstractInstant lastUpdate(Item item, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            filter.setPageSize(1);
            Iterable result = qService.query(filter);
            if (result.iterator().hasNext()) {
                return new DateTime((Object)((HistoricItem)result.iterator().next()).getTimestamp());
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        return null;
    }

    public static DecimalType deltaSince(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.deltaSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static DecimalType deltaSince(Item item, AbstractInstant timestamp, String serviceId) {
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp, serviceId);
        if (itemThen != null) {
            DecimalType valueThen = (DecimalType)itemThen.getState();
            DecimalType valueNow = (DecimalType)item.getStateAs(DecimalType.class);
            if (valueThen != null && valueNow != null) {
                return new DecimalType(valueNow.toBigDecimal().subtract(valueThen.toBigDecimal()));
            }
        }
        return null;
    }

    public static DecimalType evolutionRate(Item item, AbstractInstant timestamp) {
        return PersistenceExtensions.evolutionRate(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static DecimalType evolutionRate(Item item, AbstractInstant timestamp, String serviceId) {
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp, serviceId);
        if (itemThen != null) {
            DecimalType valueThen = (DecimalType)itemThen.getState();
            DecimalType valueNow = (DecimalType)item.getStateAs(DecimalType.class);
            if (valueThen != null && valueThen.toBigDecimal().compareTo(BigDecimal.ZERO) != 0 && valueNow != null) {
                return new DecimalType(valueNow.toBigDecimal().subtract(valueThen.toBigDecimal()).divide(valueThen.toBigDecimal(), MathContext.DECIMAL64).movePointRight(2));
            }
        }
        return null;
    }

    public static HistoricItem previousState(Item item) {
        return PersistenceExtensions.previousState(item, false);
    }

    public static HistoricItem previousState(Item item, boolean skipEqual) {
        return PersistenceExtensions.previousState(item, skipEqual, PersistenceExtensions.getDefaultServiceId());
    }

    public static HistoricItem previousState(Item item, boolean skipEqual, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService) {
            QueryablePersistenceService qService = (QueryablePersistenceService)service;
            FilterCriteria filter = new FilterCriteria();
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            filter.setPageSize(skipEqual ? 1000 : 1);
            int startPage = 0;
            filter.setPageNumber(startPage);
            Iterable items = qService.query(filter);
            while (items != null) {
                Iterator itemIterator = items.iterator();
                int itemCount = 0;
                while (itemIterator.hasNext()) {
                    HistoricItem historicItem = (HistoricItem)itemIterator.next();
                    ++itemCount;
                    if (skipEqual && (!skipEqual || historicItem.getState().equals(item.getState()))) continue;
                    return historicItem;
                }
                if (itemCount == filter.getPageSize()) {
                    filter.setPageNumber(++startPage);
                    items = qService.query(filter);
                    continue;
                }
                items = null;
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        return null;
    }
}

