/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.actions;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.model.script.internal.ScriptActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusEvent {
    private static final Logger logger = LoggerFactory.getLogger(BusEvent.class);

    public static Object sendCommand(Item item, String commandString) {
        if (item != null) {
            return BusEvent.sendCommand(item.getName(), commandString);
        }
        return null;
    }

    public static Object sendCommand(Item item, Number number) {
        if (item != null && number != null) {
            return BusEvent.sendCommand(item.getName(), number.toString());
        }
        return null;
    }

    public static Object sendCommand(String itemName, String commandString) {
        ItemRegistry registry = (ItemRegistry)ScriptActivator.itemRegistryTracker.getService();
        EventPublisher publisher = (EventPublisher)ScriptActivator.eventPublisherTracker.getService();
        if (publisher != null && registry != null) {
            try {
                Item item = registry.getItem(itemName);
                Command command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandString);
                publisher.sendCommand(itemName, command);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                logger.warn("Item '" + itemName + "' does not exist.");
            }
        }
        return null;
    }

    public static Object sendCommand(Item item, Command command) {
        EventPublisher publisher = (EventPublisher)ScriptActivator.eventPublisherTracker.getService();
        if (publisher != null && item != null) {
            publisher.sendCommand(item.getName(), command);
        }
        return null;
    }

    public static Object postUpdate(Item item, Number state) {
        if (item != null && state != null) {
            return BusEvent.postUpdate(item.getName(), state.toString());
        }
        return null;
    }

    public static Object postUpdate(Item item, String stateAsString) {
        if (item != null) {
            return BusEvent.postUpdate(item.getName(), stateAsString);
        }
        return null;
    }

    public static Object postUpdate(String itemName, String stateString) {
        ItemRegistry registry = (ItemRegistry)ScriptActivator.itemRegistryTracker.getService();
        EventPublisher publisher = (EventPublisher)ScriptActivator.eventPublisherTracker.getService();
        if (publisher != null && registry != null) {
            try {
                Item item = registry.getItem(itemName);
                State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateString);
                publisher.postUpdate(itemName, state);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                logger.warn("Item '" + itemName + "' does not exist.");
            }
        }
        return null;
    }

    public static Object postUpdate(Item item, State state) {
        EventPublisher publisher = (EventPublisher)ScriptActivator.eventPublisherTracker.getService();
        if (publisher != null && item != null) {
            publisher.postUpdate(item.getName(), state);
        }
        return null;
    }

    public static Map<Item, State> storeStates(Item ... items) {
        HashMap statesMap = Maps.newHashMap();
        if (items != null) {
            Item[] itemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getAllMembers()) {
                        statesMap.put(member, member.getState());
                    }
                } else {
                    statesMap.put(item, item.getState());
                }
                ++n2;
            }
        }
        return statesMap;
    }

    public static Object restoreStates(Map<Item, State> statesMap) {
        if (statesMap != null) {
            for (Map.Entry<Item, State> entry : statesMap.entrySet()) {
                if (entry.getValue() instanceof Command) {
                    BusEvent.sendCommand(entry.getKey(), (Command)entry.getValue());
                    continue;
                }
                BusEvent.postUpdate(entry.getKey(), entry.getValue());
            }
        }
        return null;
    }
}

