/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.automation.module.timer.handler.TimerTriggerHandler;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackJob
implements Job {
    private final Logger logger = LoggerFactory.getLogger(TimerTriggerHandler.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        if (dataMap == null) {
            this.logger.error("Can't execute CallbackJob. JobDataMap is null");
        } else {
            RuleEngineCallback callback = (RuleEngineCallback)dataMap.get((Object)"CALLBACK");
            Trigger module = (Trigger)dataMap.get((Object)"MODULE");
            if (callback == null || module == null) {
                this.logger.error("Can't execute CallbackJob. Callback or module is null");
            } else {
                HashMap values = Maps.newHashMap();
                callback.triggered(module, (Map)values);
            }
        }
    }
}

