/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.eclipse.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.ConsoleInterpreter;
import org.eclipse.smarthome.io.console.eclipse.internal.OSGiConsole;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;

public class ConsoleSupportEclipse
implements CommandProvider {
    private final String BASE = "smarthome";
    private SortedMap<String, ConsoleCommandExtension> consoleCommandExtensions = Collections.synchronizedSortedMap(new TreeMap());

    public void addConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        this.consoleCommandExtensions.put(consoleCommandExtension.getCommand(), consoleCommandExtension);
    }

    public void removeConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        this.consoleCommandExtensions.remove(consoleCommandExtension.getCommand());
    }

    private ConsoleCommandExtension getConsoleCommandExtension(String cmd) {
        return (ConsoleCommandExtension)this.consoleCommandExtensions.get(cmd);
    }

    private Collection<ConsoleCommandExtension> getConsoleCommandExtensions() {
        HashSet<ConsoleCommandExtension> set = new HashSet<ConsoleCommandExtension>();
        set.addAll(this.consoleCommandExtensions.values());
        return set;
    }

    public Object _smarthome(CommandInterpreter interpreter) {
        OSGiConsole console = new OSGiConsole("smarthome", interpreter);
        String cmd = interpreter.nextArgument();
        if (cmd == null) {
            ConsoleInterpreter.printHelp((Console)console, (String)"smarthome", (String)" ", this.getConsoleCommandExtensions());
        } else {
            ConsoleCommandExtension extension = this.getConsoleCommandExtension(cmd);
            if (extension == null) {
                console.println(String.format("No handler for command '%s' was found.", cmd));
            } else {
                String narg;
                ArrayList<String> argsList = new ArrayList<String>();
                while (!StringUtils.isEmpty((String)(narg = interpreter.nextArgument()))) {
                    argsList.add(narg);
                }
                String[] args = new String[argsList.size()];
                argsList.toArray(args);
                ConsoleInterpreter.execute((Console)console, (ConsoleCommandExtension)extension, (String[])args);
            }
        }
        return null;
    }

    public String getHelp() {
        return ConsoleInterpreter.getHelp((String)"smarthome", (String)" ", this.getConsoleCommandExtensions());
    }
}

