/**
 * generated by Xtext
 */
package org.eclipse.smarthome.model.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.smarthome.model.items.ModelBinding;
import org.eclipse.smarthome.model.items.ModelGroupItem;
import org.eclipse.smarthome.model.items.ModelItem;
import org.eclipse.smarthome.model.items.ModelNormalItem;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

/**
 * Provides labels for a EObjects.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#labelProvider
 */
@SuppressWarnings("all")
public class ItemsLabelProvider extends DefaultEObjectLabelProvider {
  @Inject
  public ItemsLabelProvider(final AdapterFactoryLabelProvider delegate) {
    super(delegate);
  }
  
  protected String text(final ModelItem item) {
    if ((item instanceof ModelGroupItem)) {
      String _name = ((ModelGroupItem)item).getName();
      return ("Group " + _name);
    }
    if ((item instanceof ModelNormalItem)) {
      final String name = ((ModelNormalItem)item).getName();
      String _type = ((ModelNormalItem)item).getType();
      String _plus = (_type + " ");
      return (_plus + name);
    }
    return item.getLabel();
  }
  
  protected String text(final ModelBinding binding) {
    return binding.getType();
  }
  
  protected String image(final ModelItem item) {
    if ((item instanceof ModelGroupItem)) {
      return "group.png";
    }
    if ((item instanceof ModelNormalItem)) {
      String _type = ((ModelNormalItem)item).getType();
      String _lowerCase = _type.toLowerCase();
      return (_lowerCase + ".png");
    }
    return null;
  }
  
  protected String image(final ModelBinding binding) {
    return "binding.png";
  }
}
