/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.rule.runtime.internal.engine;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.items.events.AbstractItemEventSubscriber;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.rule.RulesStandaloneSetup;
import org.eclipse.smarthome.model.rule.rules.Rule;
import org.eclipse.smarthome.model.rule.rules.RuleModel;
import org.eclipse.smarthome.model.rule.runtime.RuleEngine;
import org.eclipse.smarthome.model.rule.runtime.RuleRuntime;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.RuleContextHelper;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.RuleEvaluationContext;
import org.eclipse.smarthome.model.rule.runtime.internal.engine.RuleTriggerManager;
import org.eclipse.smarthome.model.script.engine.Script;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.smarthome.model.script.engine.ScriptExecutionException;
import org.eclipse.smarthome.model.script.engine.ScriptExecutionThread;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngineImpl
extends AbstractItemEventSubscriber
implements ItemRegistryChangeListener,
StateChangeListener,
ModelRepositoryChangeListener,
RuleEngine {
    private final Logger logger = LoggerFactory.getLogger(RuleEngineImpl.class);
    protected final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ItemRegistry itemRegistry;
    private ModelRepository modelRepository;
    private ScriptEngine scriptEngine;
    private RuleRuntime ruleRuntime;
    private RuleTriggerManager triggerManager;
    private Injector injector;
    private ScheduledFuture<?> startupJob;
    private Runnable startupRunnable = new Runnable(){

        @Override
        public void run() {
            RuleEngineImpl.this.runStartupRules();
        }
    };

    public void activate() {
        this.injector = RulesStandaloneSetup.getInjector();
        this.triggerManager = (RuleTriggerManager)this.injector.getInstance(RuleTriggerManager.class);
        if (!this.isEnabled()) {
            this.logger.info("Rule engine is disabled.");
            return;
        }
        this.logger.debug("Started rule engine");
        Iterable ruleModelNames = this.modelRepository.getAllModelNamesOfType("rules");
        ArrayList clonedList = Lists.newArrayList((Iterable)ruleModelNames);
        for (String ruleModelName : clonedList) {
            EObject model = this.modelRepository.getModel(ruleModelName);
            if (!(model instanceof RuleModel)) continue;
            RuleModel ruleModel = (RuleModel)model;
            this.triggerManager.addRuleModel(ruleModel);
        }
        for (Item item : this.itemRegistry.getItems()) {
            this.internalItemAdded(item);
        }
        this.scheduleStartupRules();
    }

    public void deactivate() {
        this.executeRules(this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.SHUTDOWN));
        this.triggerManager.clearAll();
        this.triggerManager = null;
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.itemRegistry = null;
    }

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void unsetScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = null;
    }

    protected void setRuleRuntime(RuleRuntime ruleRuntime) {
        this.ruleRuntime = ruleRuntime;
    }

    protected void unsetRuleRuntime(RuleRuntime ruleRuntime) {
        this.ruleRuntime = null;
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        Collection items = this.itemRegistry.getItems();
        for (Item item : items) {
            this.internalItemAdded(item);
        }
        this.scheduleStartupRules();
    }

    public void added(Item item) {
        this.internalItemAdded(item);
        this.scheduleStartupRules();
    }

    public void removed(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.removeStateChangeListener((StateChangeListener)this);
        }
    }

    public void stateChanged(Item item, State oldState, State newState) {
        if (this.triggerManager != null) {
            Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.CHANGE, item, oldState, newState);
            this.executeRules(rules, oldState);
        }
    }

    public void stateUpdated(Item item, State state) {
        if (this.triggerManager != null) {
            Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.UPDATE, item, state);
            this.executeRules(rules);
        }
    }

    protected void receiveCommand(ItemCommandEvent commandEvent) {
        if (this.triggerManager != null && this.itemRegistry != null) {
            String itemName = commandEvent.getItemName();
            Command command = commandEvent.getItemCommand();
            try {
                Item item = this.itemRegistry.getItem(itemName);
                Iterable<Rule> rules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.COMMAND, item, command);
                this.executeRules(rules, command);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
    }

    private void internalItemAdded(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.addStateChangeListener((StateChangeListener)this);
        }
    }

    public void modelChanged(String modelName, EventType type) {
        if (this.triggerManager != null && this.isEnabled() && modelName.endsWith("rules")) {
            RuleModel model = (RuleModel)this.modelRepository.getModel(modelName);
            if (type == EventType.REMOVED || type == EventType.MODIFIED) {
                this.triggerManager.removeRuleModel(model);
            }
            if (model != null && (type == EventType.ADDED || type == EventType.MODIFIED)) {
                this.triggerManager.addRuleModel(model);
                this.scheduleStartupRules();
            }
        }
    }

    private void scheduleStartupRules() {
        if (this.startupJob == null || this.startupJob.isCancelled() || this.startupJob.isDone()) {
            this.startupJob = this.scheduler.schedule(this.startupRunnable, 5L, TimeUnit.SECONDS);
        }
    }

    private void runStartupRules() {
        if (this.triggerManager != null) {
            Iterable<Rule> startupRules = this.triggerManager.getRules(RuleTriggerManager.TriggerTypes.STARTUP);
            ArrayList executedRules = Lists.newArrayList();
            for (Rule rule : startupRules) {
                try {
                    Script script = this.scriptEngine.newScriptFromXExpression((XExpression)rule.getScript());
                    this.logger.debug("Executing startup rule '{}'", (Object)rule.getName());
                    RuleEvaluationContext context = new RuleEvaluationContext();
                    context.setGlobalContext(RuleContextHelper.getContext(rule, this.injector));
                    script.execute((IEvaluationContext)context);
                    executedRules.add(rule);
                }
                catch (ScriptExecutionException e) {
                    if (!e.getMessage().contains("cannot be resolved to an item or type")) {
                        this.logger.error("Error during the execution of startup rule '{}': {}", new Object[]{rule.getName(), e.getCause().getMessage()});
                        executedRules.add(rule);
                        continue;
                    }
                    this.logger.debug("Execution of startup rule '{}' has been postponed as items are still missing.", (Object)rule.getName());
                }
            }
            for (Rule rule : executedRules) {
                this.triggerManager.removeRule(RuleTriggerManager.TriggerTypes.STARTUP, rule);
            }
        }
    }

    protected synchronized void executeRule(Rule rule) {
        this.executeRule(rule, new RuleEvaluationContext());
    }

    protected synchronized void executeRule(Rule rule, RuleEvaluationContext context) {
        Script script = this.scriptEngine.newScriptFromXExpression((XExpression)rule.getScript());
        this.logger.debug("Executing rule '{}'", (Object)rule.getName());
        context.setGlobalContext(RuleContextHelper.getContext(rule, this.injector));
        ScriptExecutionThread thread = new ScriptExecutionThread(rule.getName(), script, (IEvaluationContext)context);
        thread.start();
    }

    protected synchronized void executeRules(Iterable<Rule> rules) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            this.executeRule(rule, context);
        }
    }

    protected synchronized void executeRules(Iterable<Rule> rules, Command command) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            context.newValue(QualifiedName.create((String)"receivedCommand"), command);
            this.executeRule(rule, context);
        }
    }

    protected synchronized void executeRules(Iterable<Rule> rules, State oldState) {
        for (Rule rule : rules) {
            RuleEvaluationContext context = new RuleEvaluationContext();
            context.newValue(QualifiedName.create((String)"previousState"), oldState);
            this.executeRule(rule, context);
        }
    }

    private boolean isEnabled() {
        return !"true".equalsIgnoreCase(System.getProperty("noRules"));
    }

    public void updated(Item oldItem, Item item) {
        this.removed(oldItem);
        this.added(item);
    }
}

