/**
 * Copyright (c) 2014,2017 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.rule.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smarthome.model.rule.RulesRuntimeModule;
import org.eclipse.smarthome.model.rule.RulesStandaloneSetup;
import org.eclipse.smarthome.model.rule.ide.RulesIdeModule;
import org.eclipse.smarthome.model.script.ScriptServiceUtil;
import org.eclipse.smarthome.model.script.ServiceModule;
import org.eclipse.smarthome.model.script.engine.ScriptEngine;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class RulesIdeSetup extends RulesStandaloneSetup {
  @Override
  public Injector createInjector() {
    ScriptServiceUtil _scriptServiceUtil = this.getScriptServiceUtil();
    ScriptEngine _scriptEngine = this.getScriptEngine();
    ServiceModule _serviceModule = new ServiceModule(_scriptServiceUtil, _scriptEngine);
    RulesRuntimeModule _rulesRuntimeModule = new RulesRuntimeModule();
    RulesIdeModule _rulesIdeModule = new RulesIdeModule();
    return Guice.createInjector(_serviceModule, Modules2.mixin(_rulesRuntimeModule, _rulesIdeModule));
  }
}
