/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.javascript.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.transform.javascript.internal.TransformationScriptWatcher;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={JavaScriptEngineManager.class})
public class JavaScriptEngineManager {
    private final Logger logger = LoggerFactory.getLogger(JavaScriptEngineManager.class);
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final Map<String, CompiledScript> compiledScriptMap = new ConcurrentHashMap<String, CompiledScript>(4, 0.5f, 2);

    /*
     * Unable to fully structure code
     */
    protected CompiledScript getScript(String filename) throws TransformationException {
        var2_2 = this.compiledScriptMap;
        synchronized (var2_2) {
            if (this.compiledScriptMap.containsKey(filename)) {
                this.logger.debug("Loading JavaScript {} from cache.", (Object)filename);
                return this.compiledScriptMap.get(filename);
            }
            path = String.valueOf(TransformationScriptWatcher.TRANSFORM_FOLDER) + File.separator + filename;
            this.logger.debug("Loading script {} from storage ", (Object)path);
            try {
                var4_4 = null;
                var5_7 = null;
                try {
                    reader = new InputStreamReader(new FileInputStream(path));
                    try {
                        engine = this.manager.getEngineByName("javascript");
                        cScript = ((Compilable)engine).compile(reader);
                        this.logger.debug("Putting compiled JavaScript {} to cache.", (Object)cScript);
                        this.compiledScriptMap.put(filename, cScript);
                        v0 = cScript;
                        ** try [egrp 4[TRYBLOCK] [1 : 173->176)] { 
                    }
lbl23:
                    // 1 sources

                    catch (Throwable var4_5) {
                        throw var4_5;
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
lbl22:
                    // 1 sources

                    return v0;
                }
                catch (Throwable var5_8) {
                    if (var4_4 == null) {
                        var4_4 = var5_8;
                    } else if (var4_4 != var5_8) {
                        var4_4.addSuppressed(var5_8);
                    }
                    throw var4_4;
                }
            }
            catch (IOException | ScriptException e) {
                throw new TransformationException("An error occurred while loading JavaScript. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void removeFromCache(String fileName) {
        this.logger.debug("Removing JavaScript {} from cache.", (Object)fileName);
        this.compiledScriptMap.remove(fileName);
    }
}

