/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Video;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.eclipse.smarthome.ui.basic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={WidgetRenderer.class})
public class VideoRenderer
extends AbstractWidgetRenderer {
    private static final String URL_NONE_ICON = "images/none.png";

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Video;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Video videoWidget = (Video)w;
        String snippet = null;
        String widgetId = this.itemUIRegistry.getWidgetId(w);
        String sitemap = w.eResource().getURI().path();
        String snippetName = videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("mjpeg") ? "image" : "video";
        snippet = this.getSnippet(snippetName);
        snippet = this.preprocessSnippet(snippet, w);
        State state = this.itemUIRegistry.getState(w);
        if (snippetName.equals("image")) {
            boolean validUrl = this.isValidURL(videoWidget.getUrl());
            String proxiedUrl = "../proxy?sitemap=" + sitemap + "&amp;widgetId=" + widgetId;
            String url = !this.itemUIRegistry.getVisiblity(w) ? URL_NONE_ICON : (sitemap != null && (state instanceof StringType || validUrl) ? String.valueOf(proxiedUrl) + "&amp;t=" + new Date().getTime() : URL_NONE_ICON);
            snippet = StringUtils.replace((String)snippet, (String)"%valid_url%", (String)(validUrl ? "true" : "false"));
            snippet = StringUtils.replace((String)snippet, (String)"%proxied_url%", (String)proxiedUrl);
            snippet = StringUtils.replace((String)snippet, (String)"%update_interval%", (String)"0");
            snippet = StringUtils.replace((String)snippet, (String)"%ignore_refresh%", (String)"true");
            snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
        } else {
            String mediaType;
            String url;
            if (videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("hls")) {
                url = state instanceof StringType ? state.toString() : videoWidget.getUrl();
                mediaType = "type=\"application/vnd.apple.mpegurl\"";
            } else {
                url = "../proxy?sitemap=" + sitemap + "&widgetId=" + widgetId;
                mediaType = "";
            }
            snippet = StringUtils.replace((String)snippet, (String)"%url%", (String)url);
            snippet = StringUtils.replace((String)snippet, (String)"%media_type%", (String)mediaType);
        }
        sb.append(snippet);
        return null;
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

