/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.serialization.generators.xsd;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDConverter;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Ecore2XSDGenerator {
    protected EPackage ecoreModel;
    protected Ecore2XSDFactory xsdFactory;
    protected XSDSchema xsdSchema;
    protected URI xsdFileURI;

    public Ecore2XSDGenerator(URI xsdFileURI, EPackage ecoreModel) {
        this.xsdFileURI = xsdFileURI;
        this.ecoreModel = ecoreModel;
    }

    public void run(IProgressMonitor monitor) {
        XSDSchema _doConvertRMFPackageSchema2;
        XSDSchema _initSchema;
        Ecore2XSDFactory _createEcore2XSDFactory;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.xsdFactory = _createEcore2XSDFactory = this.createEcore2XSDFactory();
        this.xsdSchema = _initSchema = this.xsdFactory.initSchema(this.ecoreModel, (ResourceSet)resourceSet, monitor);
        Ecore2XSDConverter converter = this.createEcore2XSDConverter(this.xsdFactory, this.xsdSchema);
        SubMonitor _newChild = progress.newChild(90);
        this.xsdSchema = _doConvertRMFPackageSchema2 = converter.doConvertRMFPackageSchema2(this.ecoreModel, (IProgressMonitor)_newChild);
        SubMonitor _newChild_1 = progress.newChild(5);
        this.refineXSDSchemaNamespace((IProgressMonitor)_newChild_1);
        this.saveSchema(this.xsdFileURI, this.xsdSchema, (ResourceSet)resourceSet);
    }

    public void saveSchema(URI xsdFileURI, XSDSchema xsdSchema, ResourceSet resourceSet) {
        try {
            Resource resource = resourceSet.createResource(xsdFileURI);
            EList _contents = resource.getContents();
            _contents.add((Object)xsdSchema);
            resource.save(null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Ecore2XSDConverter createEcore2XSDConverter(Ecore2XSDFactory xsdFactory, XSDSchema xsdSchema) {
        return new Ecore2XSDConverter(xsdFactory, xsdSchema);
    }

    protected Ecore2XSDFactory createEcore2XSDFactory() {
        return new Ecore2XSDFactory(this.ecoreModel);
    }

    protected void refineXSDSchemaNamespace(IProgressMonitor monitor) {
    }
}

