/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.validation.constraints;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sphinx.examples.hummingbird20.common.Identifiable;

public class IdentifiableNamesMustNotContainIllegalCharactersConstraint
extends AbstractModelConstraint {
    private static final Pattern ILLEGAL_CHARACTERS_PATTERN = Pattern.compile("[\\W]");

    public IStatus validate(IValidationContext ctx) {
        Identifiable targetEntity;
        EObject targetObject = ctx.getTarget();
        if (this.isApplicable(targetObject) && !this.isValid(targetEntity = (Identifiable)targetObject)) {
            return ctx.createFailureStatus(new Object[]{targetEntity.getName()});
        }
        return ctx.createSuccessStatus();
    }

    private boolean isApplicable(EObject eObject) {
        if (!(eObject instanceof Identifiable)) {
            return false;
        }
        String name = ((Identifiable)eObject).getName();
        return name != null && name.length() != 0;
    }

    private boolean isValid(Identifiable identifiable) {
        Assert.isNotNull((Object)identifiable);
        String name = identifiable.getName();
        if (name != null) {
            return !ILLEGAL_CHARACTERS_PATTERN.matcher(name).find();
        }
        return true;
    }
}

