/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.bridge.extensions;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sphinx.emf.validation.bridge.extensions.RulesExtInternal;
import org.eclipse.sphinx.emf.validation.bridge.util.RulesExtReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesExtCache
implements IRegistryChangeListener {
    private final HashSet<IExtension> extensions = new HashSet();
    private final HashMap<String, RulesExtInternal> rulesExtInternal = new HashMap();
    private static RulesExtCache rulesExtCache = null;

    private RulesExtCache() {
    }

    public HashMap<String, RulesExtInternal> getRulesExtInternals() {
        return this.rulesExtInternal;
    }

    public static RulesExtCache getSingleton() {
        if (rulesExtCache == null) {
            rulesExtCache = new RulesExtCache();
        }
        return rulesExtCache;
    }

    public void startup() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint pt = reg.getExtensionPoint("org.eclipse.sphinx.emf.validation.registration");
        IExtension[] exts = pt.getExtensions();
        this.addExtension(exts);
        reg.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.sphinx.emf");
    }

    public void shutdown() {
        this.extensions.clear();
        this.rulesExtInternal.clear();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas;
        IExtensionDelta[] iExtensionDeltaArray = deltas = event.getExtensionDeltas();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta element = iExtensionDeltaArray[n2];
            if (element.getExtensionPoint().getUniqueIdentifier().equals("org.eclipse.sphinx.emf.validation.registration") && element.getKind() == 1) {
                this.addExtension(element.getExtension());
            } else {
                this.extensions.remove(element.getExtension());
            }
            ++n2;
        }
    }

    private void addExtension(IExtension[] exts) {
        if (exts == null || exts.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            this.addExtension(element);
            ++n2;
        }
    }

    private void addExtension(IExtension ext) {
        this.extensions.add(ext);
        RulesExtInternal r = null;
        r = RulesExtReader.getSingleton().readExtension(ext);
        if (r != null) {
            this.rulesExtInternal.put(r.getMarker(), r);
        }
    }
}

