/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.CommonFactory;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.DoubleValueMatrix;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.foodproduction.ConsumptionType;
import org.eclipse.stem.foodproduction.DiseaseCarryingTransformer;
import org.eclipse.stem.foodproduction.FoodConsumer;
import org.eclipse.stem.foodproduction.FoodProducer;
import org.eclipse.stem.foodproduction.FoodTransformer;
import org.eclipse.stem.foodproduction.FoodproductionPackage;
import org.eclipse.stem.foodproduction.presentation.FoodProductionMessages;
import org.eclipse.stem.foodproduction.presentation.FoodProductionPropertyEditor;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.widgets.MatrixEditorDialog;
import org.eclipse.stem.ui.widgets.MatrixEditorWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StandardFoodProductionPropertyEditor
extends FoodProductionPropertyEditor {
    protected final Map<EStructuralFeature, String[]> matrixMap = new HashMap<EStructuralFeature, String[]>();
    protected List<EAttribute> sourceCompartments;
    protected List<EAttribute> foodCompartments;
    protected Button relButton;
    protected Button absButton;
    protected Button perButton;
    static final String TARGET = "target";
    static final String SOURCE = "source";
    static Set<String> excludeSet = new HashSet<String>();

    static {
        excludeSet.add(StandardPackage.Literals.STANDARD_DISEASE_MODEL_LABEL_VALUE__INCIDENCE.getName());
        excludeSet.add(StandardPackage.Literals.STANDARD_DISEASE_MODEL_LABEL_VALUE__DISEASE_DEATHS.getName());
        excludeSet.add(StandardPackage.Literals.DISEASE_MODEL_LABEL_VALUE__POPULATION_COUNT.getName());
    }

    public boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.getEPackage() == FoodproductionPackage.eINSTANCE) {
            retValue = feature != FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__STATE_TRANSITIONS_MAP && feature != FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__SOURCE_ATTRIBUTES && feature != FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__TARGET_ATTRIBUTES;
        }
        return retValue;
    }

    public StandardFoodProductionPropertyEditor(Composite parent, int style, IProject project) {
        super(parent, style, project);
    }

    public StandardFoodProductionPropertyEditor(Composite parent, int style, FoodTransformer foodTransformer, ModifyListener projectValidator, IProject project) {
        super(parent, style, foodTransformer, projectValidator, project);
        this.sourceCompartments = new ArrayList<EAttribute>();
        this.foodCompartments = new ArrayList<EAttribute>();
        this.populationChange();
        FoodproductionPackage pack = FoodproductionPackage.eINSTANCE;
        ModifyListener popChangeListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StandardFoodProductionPropertyEditor.this.populationChange();
            }
        };
        ((Text)this.map.get(pack.getFoodTransformer_SourcePopulationName())).addModifyListener(popChangeListener);
        ((Text)this.map.get(pack.getFoodTransformer_TargetPopulationName())).addModifyListener(popChangeListener);
        final PropertyStringProviderAdapter pspa = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)foodTransformer, PropertyStringProvider.class);
        ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)foodTransformer, IItemPropertySource.class);
        List properties = propertySource.getPropertyDescriptors((Object)foodTransformer);
        for (final IItemPropertyDescriptor descriptor : properties) {
            Label label;
            final EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
            final EClassifier type = feature.getEType();
            if (type == CommonPackage.Literals.DOUBLE_VALUE_MATRIX) {
                label = new Label((Composite)this, 0);
                label.setText(pspa.getPropertyName(descriptor));
                label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                Button button = new Button((Composite)this, 0);
                button.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stem.ui", (String)"/icons/full/customobj16/Matrix.gif").createImage());
                button.setLayoutData((Object)new GridData(3));
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        Shell shell;
                        MatrixEditorDialog dialog;
                        String[] res;
                        String title = pspa.getPropertyName(descriptor);
                        String[] existingVals = StandardFoodProductionPropertyEditor.this.matrixMap.get(feature);
                        short cols = (short)StandardFoodProductionPropertyEditor.this.foodCompartments.size();
                        short rows = (short)StandardFoodProductionPropertyEditor.this.sourceCompartments.size();
                        String[] rownames = new String[rows];
                        String[] colnames = new String[cols];
                        int n = 0;
                        for (EAttribute a : StandardFoodProductionPropertyEditor.this.sourceCompartments) {
                            rownames[n++] = a.getName();
                        }
                        n = 0;
                        for (EAttribute a : StandardFoodProductionPropertyEditor.this.foodCompartments) {
                            colnames[n++] = a.getName();
                        }
                        boolean fixedSize = true;
                        MatrixEditorWidget.MatrixEditorValidator validator = StandardFoodProductionPropertyEditor.this.getValidator(feature);
                        if (existingVals == null && (type.getClassifierID() == 4 || type.getClassifierID() == 5)) {
                            existingVals = new String[cols * rows];
                            int i = 0;
                            while (i < cols * rows) {
                                existingVals[i] = "0.0";
                                ++i;
                            }
                        }
                        if ((res = (dialog = new MatrixEditorDialog(shell = StandardFoodProductionPropertyEditor.this.getShell(), 0, title, rows, cols, rownames, colnames, existingVals, fixedSize, validator)).open()) != null) {
                            StandardFoodProductionPropertyEditor.this.matrixMap.put(feature, res);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
                Label unitLabel = new Label((Composite)this, 0);
                unitLabel.setText(pspa.getPropertyUnits(descriptor));
                unitLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                continue;
            }
            if (type != FoodproductionPackage.eINSTANCE.getConsumptionType()) continue;
            label = new Label((Composite)this, 0);
            label.setText(FoodProductionMessages.getString("consumptionType"));
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Composite radioComposite = new Composite((Composite)this, 2048);
            radioComposite.setLayout((Layout)new FillLayout(256));
            radioComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.relButton = new Button(radioComposite, 16);
            this.relButton.setText(FoodProductionMessages.getString("relativeConsumption"));
            this.relButton.setSelection(false);
            this.absButton = new Button(radioComposite, 16);
            this.absButton.setText(FoodProductionMessages.getString("absoluteConsumption"));
            this.absButton.setSelection(false);
            this.perButton = new Button(radioComposite, 16);
            this.perButton.setText(FoodProductionMessages.getString("consumptionPerPerson"));
            this.perButton.setSelection(false);
            String defaultValue = FoodproductionPackage.Literals.FOOD_CONSUMER__CONSUMPTION_TYPE.getDefaultValueLiteral();
            if (defaultValue.equals("1")) {
                this.relButton.setSelection(true);
            } else if (defaultValue.equals("2")) {
                this.absButton.setSelection(true);
            } else if (defaultValue.equals("3")) {
                this.perButton.setSelection(true);
            }
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText("");
            unitLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
    }

    public void populationChange() {
        final Combo sourceCombo = (Combo)this.comboMap.get(FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__SOURCE_DECORATOR);
        final Combo foodCombo = (Combo)this.comboMap.get(FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__TARGET_DECORATOR);
        if (sourceCombo != null && foodCombo != null) {
            String pop;
            List decoratorsList = this.getDecoratorsForProject(this.project);
            sourceCombo.removeAll();
            foodCombo.removeAll();
            int sourceCount = 0;
            int foodCount = 0;
            for (IntegrationDecorator idec : decoratorsList) {
                if (!(idec instanceof DiseaseModel)) continue;
                DiseaseModel dm = (DiseaseModel)idec;
                EList idenList = dm.getAllLabelIdentifiers();
                FoodproductionPackage pack = FoodproductionPackage.eINSTANCE;
                String sourcePop = ((Text)this.map.get(pack.getFoodTransformer_SourcePopulationName())).getText();
                String targetPop = ((Text)this.map.get(pack.getFoodTransformer_TargetPopulationName())).getText();
                if (idenList.contains((Object)sourcePop)) {
                    sourceCombo.add(dm.getDiseaseName());
                    sourceCombo.setData("" + sourceCount, (Object)dm);
                    ++sourceCount;
                }
                if (!idenList.contains((Object)targetPop)) continue;
                foodCombo.add(dm.getDiseaseName());
                foodCombo.setData("" + foodCount, (Object)dm);
                ++foodCount;
            }
            sourceCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String pop = ((Text)StandardFoodProductionPropertyEditor.this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__SOURCE_POPULATION_NAME)).getText();
                    StandardFoodProductionPropertyEditor.this.comboSelection(sourceCombo, StandardFoodProductionPropertyEditor.this.sourceCompartments, pop);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            foodCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String pop = ((Text)StandardFoodProductionPropertyEditor.this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__TARGET_POPULATION_NAME)).getText();
                    StandardFoodProductionPropertyEditor.this.comboSelection(foodCombo, StandardFoodProductionPropertyEditor.this.foodCompartments, pop);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (sourceCombo.getItems() != null && sourceCombo.getItems().length > 0) {
                sourceCombo.select(0);
                pop = ((Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__SOURCE_POPULATION_NAME)).getText();
                this.comboSelection(sourceCombo, this.sourceCompartments, pop);
            }
            if (foodCombo.getItems() != null && foodCombo.getItems().length > 0) {
                foodCombo.select(0);
                pop = ((Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__TARGET_POPULATION_NAME)).getText();
                this.comboSelection(foodCombo, this.foodCompartments, pop);
            }
        }
    }

    public void comboSelection(Combo combo, List<EAttribute> compartmentList, String population) {
        int index = combo.getSelectionIndex();
        String key = String.valueOf(index);
        IntegrationDecorator id = (IntegrationDecorator)combo.getData(key);
        this.extractCompartments(id, compartmentList, population);
        this.initMatrix();
    }

    protected void extractCompartments(IntegrationDecorator id, List<EAttribute> target, String population) {
        DiseaseModel dm = (DiseaseModel)id;
        List compartments = id.getCompartments(population);
        target.clear();
        for (IItemPropertyDescriptor compartment : compartments) {
            EAttribute compartmentAttr = (EAttribute)compartment.getFeature((Object)compartment);
            String attrStr = compartmentAttr.getName();
            if (excludeSet.contains(attrStr)) continue;
            target.add((EAttribute)compartment.getFeature((Object)compartment));
        }
    }

    public MatrixEditorWidget.MatrixEditorValidator getValidator(EStructuralFeature feature) {
        EClassifier type = feature.getEType();
        MatrixEditorWidget.MatrixEditorValidator validator = null;
        if (type == CommonPackage.Literals.DOUBLE_VALUE_MATRIX) {
            validator = new MatrixEditorWidget.MatrixEditorValidator(){

                public boolean validateValue(String val) {
                    if (val == null || val.trim().equals("")) {
                        return false;
                    }
                    try {
                        Double.parseDouble(val.trim());
                    }
                    catch (NumberFormatException nfe) {
                        return false;
                    }
                    return true;
                }

                public boolean validateAllValues(List<Text> vals) {
                    int nCols = StandardFoodProductionPropertyEditor.this.foodCompartments.size();
                    int nRows = StandardFoodProductionPropertyEditor.this.sourceCompartments.size();
                    if (vals.size() < nCols * nRows) {
                        return true;
                    }
                    boolean runningIndex = false;
                    int r = 0;
                    while (r < nRows) {
                        double sum = 0.0;
                        int c = 0;
                        while (c < nCols) {
                            double value = Double.parseDouble(vals.get(c + nCols * r).getText());
                            sum += value;
                            ++c;
                        }
                        if (sum != 1.0) {
                            return false;
                        }
                        ++r;
                    }
                    return true;
                }
            };
        }
        return validator;
    }

    private void initMatrix() {
        int row = 0;
        int col = 0;
        int nRows = this.sourceCompartments.size();
        int nCols = this.foodCompartments.size();
        String[] allCompartments = new String[nRows * nCols];
        if (nRows * nCols > 0) {
            for (EAttribute rowAttr : this.sourceCompartments) {
                String rowKey = rowAttr.getName();
                for (EAttribute colAttr : this.foodCompartments) {
                    String colKey = colAttr.getName();
                    int idx = col + row * nCols;
                    allCompartments[idx] = colKey.equalsIgnoreCase(rowKey) ? "1" : "0";
                    ++col;
                }
                ++row;
                col = 0;
            }
        }
        this.matrixMap.put((EStructuralFeature)FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__STATE_TRANSITIONS_MAP, allCompartments);
    }

    public void populate(FoodTransformer foodTransformer) {
        foodTransformer.setSourcePopulationName(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__SOURCE_POPULATION_NAME)).getText());
        foodTransformer.setTargetPopulationName(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__TARGET_POPULATION_NAME)).getText());
        foodTransformer.setTimePeriod(Long.parseLong(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__TIME_PERIOD)).getText()));
        String uri = ((Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__TARGET_URI)).getText().trim();
        if (uri.equals("")) {
            foodTransformer.setTargetURI(null);
        } else {
            foodTransformer.setTargetURI(STEMURI.createURI((String)uri));
        }
        if (foodTransformer instanceof FoodProducer) {
            FoodProducer producer = (FoodProducer)foodTransformer;
            producer.setSourceProcessingRate(Double.parseDouble(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_PRODUCER__SOURCE_PROCESSING_RATE)).getText()));
            producer.setFoodYieldPopulationMultiplier(Double.parseDouble(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_PRODUCER__FOOD_YIELD_POPULATION_MULTIPLIER)).getText()));
        }
        if (foodTransformer instanceof FoodConsumer) {
            FoodConsumer consumer = (FoodConsumer)foodTransformer;
            consumer.setConsumptionRate(Double.parseDouble(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_CONSUMER__CONSUMPTION_RATE)).getText()));
            consumer.setWasteRate(Double.parseDouble(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_CONSUMER__WASTE_RATE)).getText()));
            consumer.setMaxVolumeOfStocks(Double.parseDouble(((Text)this.map.get(FoodproductionPackage.Literals.FOOD_CONSUMER__MAX_VOLUME_OF_STOCKS)).getText()));
            if (this.relButton.getSelection()) {
                consumer.setConsumptionType(ConsumptionType.RELATIVE_CONSUMPTION);
            } else if (this.absButton.getSelection()) {
                consumer.setConsumptionType(ConsumptionType.ABSOLUTE_CONSUMPTION);
            } else if (this.perButton.getSelection()) {
                consumer.setConsumptionType(ConsumptionType.CONSUMPTION_PER_PERSON);
            }
        }
        if (foodTransformer instanceof DiseaseCarryingTransformer) {
            DiseaseCarryingTransformer transformer = (DiseaseCarryingTransformer)foodTransformer;
            Combo sourceCombo = (Combo)this.comboMap.get(FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__SOURCE_DECORATOR);
            Combo foodCombo = (Combo)this.comboMap.get(FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__TARGET_DECORATOR);
            String sourceSelection = "" + sourceCombo.getSelectionIndex();
            String foodSelection = "" + foodCombo.getSelectionIndex();
            transformer.setSourceDecorator((IntegrationDecorator)sourceCombo.getData(sourceSelection));
            transformer.setTargetDecorator((IntegrationDecorator)foodCombo.getData(foodSelection));
            DoubleValueMatrix dvm = CommonFactory.eINSTANCE.createDoubleValueMatrix();
            transformer.getTargetAttributes().clear();
            transformer.getSourceAttributes().clear();
            int row = 0;
            int col = 0;
            int nRows = this.sourceCompartments.size();
            int nCols = this.foodCompartments.size();
            String[] allCompartments = this.matrixMap.get(FoodproductionPackage.Literals.DISEASE_CARRYING_TRANSFORMER__STATE_TRANSITIONS_MAP);
            if (nRows * nCols > 0) {
                for (EAttribute rowAttr : this.sourceCompartments) {
                    transformer.getSourceAttributes().add((Object)rowAttr);
                    String rowKey = rowAttr.getName();
                    DoubleValueList dvl = CommonFactory.eINSTANCE.createDoubleValueList();
                    dvl.setIdentifier("source " + rowKey);
                    dvm.getValueLists().add((Object)dvl);
                    for (EAttribute colAttr : this.foodCompartments) {
                        String colKey = colAttr.getName();
                        int idx = col + row * nCols;
                        transformer.getTargetAttributes().add((Object)colAttr);
                        String val = allCompartments[idx].trim();
                        double dbl = new Double(val);
                        DoubleValue dval = CommonFactory.eINSTANCE.createDoubleValue();
                        dval.setValue(dbl);
                        dvl.getValues().add((Object)dval);
                        dval.setIdentifier("target " + colKey);
                        ++col;
                    }
                    ++row;
                    col = 0;
                }
            }
            transformer.setStateTransitionsMap(dvm);
        }
    }

    public boolean validate() {
        Text text;
        boolean retValue = true;
        if (retValue) {
            text = (Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__SOURCE_POPULATION_NAME);
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = FoodProductionMessages.getString("FoodProd.NFoodWizErr0");
            }
        }
        if (retValue) {
            text = (Text)this.map.get(FoodproductionPackage.Literals.FOOD_TRANSFORMER__TARGET_POPULATION_NAME);
            boolean bl = retValue = !text.getText().equals("");
            if (!retValue) {
                this.errorMessage = FoodProductionMessages.getString("FoodProd.NFoodWizErr4");
            }
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

