/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.util.SourcePosition;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.SourcePositionImpl;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public abstract class ASTBasedDeclarationImpl
extends EclipseDeclarationImpl {
    static final String EMPTY_STRING = "";
    protected final ASTNode _astNode;
    protected final IFile _file;

    public ASTBasedDeclarationImpl(ASTNode astNode, IFile file, BaseProcessorEnv env) {
        super(env);
        assert (astNode != null) : "ast node cannot be missing";
        assert (file != null) : "file cannot be missing";
        assert (astNode instanceof BodyDeclaration || astNode instanceof VariableDeclaration) : "ast node must be either a body declaration or a variable declaration";
        this._astNode = astNode;
        this._file = file;
    }

    @Override
    public Collection<com.sun.mirror.declaration.Modifier> getModifiers() {
        int modBits = 0;
        if (this._astNode instanceof BodyDeclaration) {
            modBits = ((BodyDeclaration)this._astNode).getModifiers();
        } else if (this._astNode instanceof SingleVariableDeclaration) {
            modBits = ((SingleVariableDeclaration)this._astNode).getModifiers();
        } else {
            ASTNode parent = ((VariableDeclarationFragment)this._astNode).getParent();
            if (this._astNode instanceof BodyDeclaration) {
                modBits = ((BodyDeclaration)parent).getModifiers();
            }
        }
        return this.getModifiers(modBits);
    }

    private Collection<com.sun.mirror.declaration.Modifier> getModifiers(int modBits) {
        ArrayList<com.sun.mirror.declaration.Modifier> mods = new ArrayList<com.sun.mirror.declaration.Modifier>(4);
        if (Modifier.isAbstract((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.ABSTRACT);
        }
        if (Modifier.isFinal((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.FINAL);
        }
        if (Modifier.isNative((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.NATIVE);
        }
        if (Modifier.isPrivate((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.PRIVATE);
        }
        if (Modifier.isProtected((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.PROTECTED);
        }
        if (Modifier.isPublic((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.PUBLIC);
        }
        if (Modifier.isStatic((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.STATIC);
        }
        if (Modifier.isStrictfp((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.STRICTFP);
        }
        if (Modifier.isSynchronized((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.SYNCHRONIZED);
        }
        if (Modifier.isTransient((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.TRANSIENT);
        }
        if (Modifier.isVolatile((int)modBits)) {
            mods.add(com.sun.mirror.declaration.Modifier.VOLATILE);
        }
        return mods;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        IAnnotationBinding[] instances = this.getAnnotationInstancesFromAST();
        return this._getAnnotation(annotationClass, instances);
    }

    @Override
    public Collection<AnnotationMirror> getAnnotationMirrors() {
        IAnnotationBinding[] instances = this.getAnnotationInstancesFromAST();
        return this._getAnnotationMirrors(instances);
    }

    private IAnnotationBinding[] getAnnotationInstancesFromAST() {
        IAnnotationBinding[] instances = null;
        List extendsMods = null;
        switch (this._astNode.getNodeType()) {
            case 23: 
            case 31: 
            case 55: 
            case 71: 
            case 72: 
            case 81: 
            case 82: {
                extendsMods = ((BodyDeclaration)this._astNode).modifiers();
                break;
            }
            case 44: {
                extendsMods = ((SingleVariableDeclaration)this._astNode).modifiers();
                break;
            }
            case 59: {
                ASTNode parent = ((VariableDeclarationFragment)this._astNode).getParent();
                if (!(parent instanceof BodyDeclaration)) break;
                extendsMods = ((BodyDeclaration)parent).modifiers();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (extendsMods != null) {
            int count = 0;
            for (Object obj : extendsMods) {
                IExtendedModifier extMod = (IExtendedModifier)obj;
                if (!extMod.isAnnotation()) continue;
                ++count;
            }
            instances = new IAnnotationBinding[count];
            int index = 0;
            for (Object obj : extendsMods) {
                IExtendedModifier extMod = (IExtendedModifier)obj;
                if (!extMod.isAnnotation()) continue;
                instances[index++] = ((org.eclipse.jdt.core.dom.Annotation)extMod).resolveAnnotationBinding();
            }
        }
        return instances;
    }

    @Override
    public boolean isFromSource() {
        return true;
    }

    @Override
    ASTNode getAstNode() {
        return this._astNode;
    }

    @Override
    CompilationUnit getCompilationUnit() {
        return (CompilationUnit)this._astNode.getRoot();
    }

    @Override
    public IFile getResource() {
        return this._file;
    }

    @Override
    public SourcePosition getPosition() {
        ASTNode node = this.getRangeNode();
        if (node == null) {
            return null;
        }
        CompilationUnit unit = this.getCompilationUnit();
        int start = node.getStartPosition();
        return new SourcePositionImpl(start, node.getLength(), unit.getLineNumber(start), unit.getColumnNumber(start), this);
    }

    @Override
    public boolean isBindingBased() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ASTBasedDeclarationImpl) {
            return this._astNode == ((ASTBasedDeclarationImpl)obj)._astNode;
        }
        return false;
    }

    public int hashCode() {
        return this._astNode.hashCode();
    }
}

