/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIReturnValueVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThisVariable;
import org.eclipse.jdt.internal.debug.ui.contentassist.TypeContext;

public class CurrentFrameContext
extends TypeContext {
    public CurrentFrameContext() {
        super(null, -1);
    }

    @Override
    public IType getType() throws CoreException {
        IType type;
        IJavaStackFrame frame = this.getStackFrame();
        if (frame != null && (type = JavaDebugUtils.resolveDeclaringType((IJavaStackFrame)frame)) != null) {
            return type;
        }
        return super.getType();
    }

    @Override
    public String[][] getLocalVariables() throws CoreException {
        IJavaStackFrame frame = this.getStackFrame();
        if (frame != null) {
            IVariable[] variables = frame.getVariables();
            int index = 0;
            while (index < variables.length && (variables[index] instanceof JDIThisVariable || variables[index] instanceof JDIReturnValueVariable)) {
                ++index;
            }
            String[][] locals = new String[2][variables.length - index];
            int i = 0;
            while (i < locals[0].length) {
                IJavaVariable var = (IJavaVariable)variables[index];
                locals[0][i] = var.getName();
                try {
                    locals[1][i] = var.getJavaType().getName();
                }
                catch (DebugException debugException) {
                    locals[1][i] = var.getReferenceTypeName();
                }
                ++index;
                ++i;
            }
            return locals;
        }
        return super.getLocalVariables();
    }

    @Override
    public boolean isStatic() throws CoreException {
        IJavaStackFrame frame = this.getStackFrame();
        if (frame != null) {
            return frame.isStatic();
        }
        return false;
    }

    protected IJavaStackFrame getStackFrame() {
        IAdaptable debugContext = DebugUITools.getDebugContext();
        IJavaStackFrame frame = null;
        if (debugContext != null) {
            frame = (IJavaStackFrame)debugContext.getAdapter(IJavaStackFrame.class);
        }
        return frame;
    }
}

