/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.console;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.console.Messages;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvCommandProvider
implements CommandProvider {
    private static final String WILDCARD_ANY = "*";
    public static final String NEW_LINE = "\r\n";
    public static final String TAB = "\t";
    private Map<String, String> commandsHelp = null;
    private Map<String, String[]> commandGroups = null;
    private final IProvisioningAgent agent;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ProvCommandProvider(String profileId, IProvisioningAgent agent) {
        this.agent = agent;
    }

    public void _provaddrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.println((Object)"Repository location must be provided");
            return;
        }
        URI repoURI = this.toURI(interpreter, urlString);
        if (repoURI == null) {
            return;
        }
        if (ProvisioningHelper.addMetadataRepository(this.agent, repoURI) == null) {
            interpreter.println((Object)new StringBuffer("Unable to add metadata repository: ").append(repoURI).toString());
        } else if (ProvisioningHelper.addArtifactRepository(this.agent, repoURI) == null) {
            interpreter.println((Object)new StringBuffer("Unable to add artifact repository: ").append(repoURI).toString());
        }
    }

    public void _provdelrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.println((Object)"Repository location must be provided");
            return;
        }
        URI repoURI = this.toURI(interpreter, urlString);
        if (repoURI == null) {
            return;
        }
        ProvisioningHelper.removeMetadataRepository(this.agent, repoURI);
        ProvisioningHelper.removeArtifactRepository(this.agent, repoURI);
    }

    public void _provaddmetadatarepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.println((Object)"Repository location must be provided");
            return;
        }
        URI repoURI = this.toURI(interpreter, urlString);
        if (repoURI == null) {
            return;
        }
        if (ProvisioningHelper.addMetadataRepository(this.agent, repoURI) == null) {
            interpreter.println((Object)new StringBuffer("Unable to add repository: ").append(repoURI).toString());
        }
    }

    public void _provdelmetadatarepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.println((Object)"Repository location must be provided");
            return;
        }
        URI repoURI = this.toURI(interpreter, urlString);
        if (repoURI == null) {
            return;
        }
        ProvisioningHelper.removeMetadataRepository(this.agent, repoURI);
    }

    public void _provaddartifactrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.println((Object)"Repository location must be provided");
            return;
        }
        URI repoURI = this.toURI(interpreter, urlString);
        if (repoURI == null) {
            return;
        }
        if (ProvisioningHelper.addArtifactRepository(this.agent, repoURI) == null) {
            interpreter.println((Object)new StringBuffer("Unable to add repository ").append(repoURI).toString());
        }
    }

    public void _provdelartifactrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.println((Object)"Repository location must be provided");
            return;
        }
        URI repoURI = this.toURI(interpreter, urlString);
        if (repoURI == null) {
            return;
        }
        ProvisioningHelper.removeArtifactRepository(this.agent, repoURI);
    }

    public void _provinstall(CommandInterpreter interpreter) {
        String iu = interpreter.nextArgument();
        String version = interpreter.nextArgument();
        String profileId = interpreter.nextArgument();
        if (profileId == null || profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if (iu == null || version == null || profileId == null) {
            interpreter.println((Object)"Installable unit id, version, and profileid must be provided");
            return;
        }
        IProfile profile = ProvisioningHelper.getProfile(this.agent, profileId);
        if (profile == null) {
            if (profileId.equals("_SELF_")) {
                interpreter.println((Object)"No profile found");
            } else {
                interpreter.println((Object)new StringBuffer("Profile ").append(profileId).append(" not found").toString());
            }
            return;
        }
        IStatus s = null;
        try {
            s = ProvisioningHelper.install(this.agent, iu, version, profile, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            interpreter.println((Object)new StringBuffer("Installation failed with ProvisionException for ").append(iu).append(" ").append(version).toString());
            interpreter.printStackTrace((Throwable)e);
            return;
        }
        if (s.isOK()) {
            interpreter.println((Object)new StringBuffer("Installation complete for ").append(iu).append(" ").append(version).toString());
        } else {
            interpreter.println((Object)new StringBuffer("Installation failed for ").append(iu).append(" ").append(version).toString());
            interpreter.println((Object)this.flattenStatus(s.getChildren(), "  "));
        }
    }

    private String flattenStatus(IStatus[] childs, String indent) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (childs != null && i < childs.length) {
            sb.append(indent).append(childs[i].getMessage()).append(NEW_LINE);
            sb.append(this.flattenStatus(childs[i].getChildren(), new StringBuffer(String.valueOf(indent)).append("  ").toString()));
            ++i;
        }
        return sb.toString();
    }

    public void _provaddprofile(CommandInterpreter interpreter) {
        String profileId = interpreter.nextArgument();
        String location = interpreter.nextArgument();
        if (profileId == null || location == null) {
            interpreter.println((Object)"Id and location must be provided");
            return;
        }
        String environments = interpreter.nextArgument();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("org.eclipse.equinox.p2.installFolder", location);
        if (environments != null) {
            props.put("org.eclipse.equinox.p2.environments", environments);
        }
        try {
            ProvisioningHelper.addProfile(this.agent, profileId, props);
        }
        catch (ProvisionException e) {
            interpreter.println((Object)new StringBuffer("Add profile failed.  ").append(e.getMessage()).toString());
            interpreter.printStackTrace((Throwable)e);
        }
    }

    public void _provdelprofile(CommandInterpreter interpreter) {
        String profileId = interpreter.nextArgument();
        if (profileId == null) {
            interpreter.println((Object)"profileid must be provided");
            return;
        }
        ProvisioningHelper.removeProfile(this.agent, profileId);
    }

    public void _provliu(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        String id = this.processArgument(interpreter.nextArgument());
        String version = this.processArgument(interpreter.nextArgument());
        URI repoURL = null;
        if (urlString != null && !urlString.equals(WILDCARD_ANY)) {
            repoURL = this.toURI(interpreter, urlString);
        }
        IInstallableUnit[] units = this.sort(ProvisioningHelper.getInstallableUnits(this.agent, repoURL, (IQuery<IInstallableUnit>)QueryUtil.createIUQuery((String)id, (VersionRange)new VersionRange(version)), null));
        int i = 0;
        while (i < units.length) {
            this.println(interpreter, units[i]);
            ++i;
        }
    }

    public void _provlquery(CommandInterpreter interpreter) {
        IQuery query;
        IInstallableUnit[] units;
        String urlString = this.processArgument(interpreter.nextArgument());
        String expression = this.processArgument(interpreter.nextArgument());
        if (expression == null) {
            interpreter.println((Object)"Please enter a query");
            return;
        }
        boolean useFull = Boolean.valueOf(this.processArgument(interpreter.nextArgument()));
        URI repoURL = null;
        if (urlString != null && !urlString.equals(WILDCARD_ANY)) {
            repoURL = this.toURI(interpreter, urlString);
        }
        if ((units = this.sort(ProvisioningHelper.getInstallableUnits(this.agent, repoURL, (IQuery<IInstallableUnit>)(query = useFull ? QueryUtil.createQuery((String)expression, (Object[])new Object[0]) : QueryUtil.createMatchQuery((String)expression, (Object[])new Object[0])), null))).length == 0) {
            interpreter.println((Object)"No units found");
        } else {
            int i = 0;
            while (i < units.length) {
                this.println(interpreter, units[i]);
                ++i;
            }
        }
    }

    public void _provlr(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        String id = this.processArgument(interpreter.nextArgument());
        String version = this.processArgument(interpreter.nextArgument());
        if (urlString == null) {
            URI[] repositories = ProvisioningHelper.getMetadataRepositories(this.agent);
            if (repositories != null) {
                int i = 0;
                while (i < repositories.length) {
                    interpreter.println((Object)repositories[i]);
                    ++i;
                }
            }
            return;
        }
        URI repoLocation = this.toURI(interpreter, urlString);
        if (repoLocation == null) {
            return;
        }
        IInstallableUnit[] units = this.sort(ProvisioningHelper.getInstallableUnits(this.agent, repoLocation, (IQuery<IInstallableUnit>)QueryUtil.createIUQuery((String)id, (VersionRange)new VersionRange(version)), null));
        int i = 0;
        while (i < units.length) {
            this.println(interpreter, units[i]);
            ++i;
        }
    }

    public void _provlg(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        IMetadataRepositoryManager queryable = null;
        if (urlString == null) {
            queryable = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            if (queryable == null) {
                return;
            }
        } else {
            URI repoURL = this.toURI(interpreter, urlString);
            if (repoURL == null) {
                return;
            }
            queryable = ProvisioningHelper.getMetadataRepository(this.agent, repoURL);
            if (queryable == null) {
                return;
            }
        }
        IInstallableUnit[] units = this.sort((IQueryResult<IInstallableUnit>)queryable.query(QueryUtil.createIUGroupQuery(), null));
        int i = 0;
        while (i < units.length) {
            this.println(interpreter, units[i]);
            ++i;
        }
    }

    public void _provlar(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        if (urlString == null) {
            URI[] repositories = ProvisioningHelper.getArtifactRepositories(this.agent);
            if (repositories == null) {
                return;
            }
            int i = 0;
            while (i < repositories.length) {
                interpreter.println((Object)repositories[i]);
                ++i;
            }
            return;
        }
        URI repoURL = this.toURI(interpreter, urlString);
        if (repoURL == null) {
            return;
        }
        IArtifactRepository repo = ProvisioningHelper.getArtifactRepository(this.agent, repoURL);
        IQueryResult keys = null;
        try {
            keys = repo != null ? repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null) : null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            interpreter.println((Object)"Repository does not support queries.");
            return;
        }
        if (keys == null || keys.isEmpty()) {
            interpreter.println((Object)"Repository has no artifacts");
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFileArtifactRepository fileRepo = (IFileArtifactRepository)repo.getAdapter((Class)clazz);
        for (IArtifactKey key : keys) {
            IArtifactDescriptor[] descriptors = repo.getArtifactDescriptors(key);
            int j = 0;
            while (j < descriptors.length) {
                IArtifactDescriptor descriptor = descriptors[j];
                File location = null;
                if (fileRepo != null) {
                    location = fileRepo.getArtifactFile(descriptor);
                }
                this.println(interpreter, key, location);
                ++j;
            }
        }
    }

    private URI toURI(CommandInterpreter interpreter, String urlString) {
        try {
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            interpreter.print((Object)e.getMessage());
            interpreter.println();
            return null;
        }
    }

    private String processArgument(String arg) {
        if (arg == null || arg.equals(WILDCARD_ANY)) {
            return null;
        }
        return arg;
    }

    public void _provlp(CommandInterpreter interpreter) {
        String profileId = this.processArgument(interpreter.nextArgument());
        String id = this.processArgument(interpreter.nextArgument());
        String range = this.processArgument(interpreter.nextArgument());
        if (profileId == null) {
            IProfile[] profiles = ProvisioningHelper.getProfiles(this.agent);
            if (profiles == null) {
                interpreter.println((Object)"No profile found");
                return;
            }
            int i = 0;
            while (i < profiles.length) {
                interpreter.println((Object)profiles[i].getProfileId());
                ++i;
            }
            return;
        }
        IProfile target = null;
        if (profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if ((target = ProvisioningHelper.getProfile(this.agent, profileId)) == null) {
            if (profileId.equals("_SELF_")) {
                interpreter.println((Object)"No profile found");
            } else {
                interpreter.println((Object)new StringBuffer("Profile ").append(profileId).append(" not found").toString());
            }
            return;
        }
        IInstallableUnit[] result = this.sort((IQueryResult<IInstallableUnit>)target.query(QueryUtil.createIUQuery((String)id, (VersionRange)new VersionRange(range)), null));
        int i = 0;
        while (i < result.length) {
            interpreter.println((Object)result[i]);
            ++i;
        }
    }

    public void _provlpts(CommandInterpreter interpreter) {
        long[] profileTimestamps;
        String profileId = this.processArgument(interpreter.nextArgument());
        if (profileId == null || profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if ((profileTimestamps = ProvisioningHelper.getProfileTimestamps(this.agent, profileId)) == null || profileTimestamps.length == 0) {
            if (profileId.equals("_SELF_")) {
                interpreter.println((Object)"No profile found");
            } else {
                interpreter.print((Object)"No timestamps found for profile ");
                interpreter.println((Object)profileId);
            }
            return;
        }
        interpreter.print((Object)"Timestamps for profile ");
        interpreter.println((Object)profileId);
        int i = 0;
        while (i < profileTimestamps.length) {
            interpreter.print((Object)TAB);
            interpreter.println((Object)new Long(profileTimestamps[i]));
            ++i;
        }
    }

    public void _provrevert(CommandInterpreter interpreter) {
        IProfile profile;
        String timestamp = interpreter.nextArgument();
        if (timestamp == null) {
            interpreter.println((Object)"Valid timestamp must be provided.  Timestamps can be retrieved via 'provlpts' command.");
            return;
        }
        Long ts = null;
        try {
            ts = new Long(timestamp);
        }
        catch (NumberFormatException numberFormatException) {
            interpreter.println((Object)new StringBuffer("Timestamp ").append(timestamp).append(" not valid.  Timestamps can be retrieved via 'provlpts' command.").toString());
            return;
        }
        String profileId = interpreter.nextArgument();
        if (profileId == null || profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if ((profile = ProvisioningHelper.getProfile(this.agent, profileId)) == null) {
            if (profileId.equals("_SELF_")) {
                interpreter.println((Object)"No profile found");
            } else {
                interpreter.println((Object)new StringBuffer("Profile ").append(profileId).append(" not found").toString());
            }
            return;
        }
        IStatus s = null;
        try {
            s = ProvisioningHelper.revertToPreviousState(this.agent, profile, ts);
        }
        catch (ProvisionException e) {
            interpreter.println((Object)"revert failed ");
            interpreter.printStackTrace((Throwable)e);
            return;
        }
        if (s.isOK()) {
            interpreter.println((Object)"revert completed");
        } else {
            interpreter.println((Object)"revert failed ");
            this.printErrorStatus(interpreter, s);
        }
    }

    private IInstallableUnit[] sort(IQueryResult<IInstallableUnit> queryResult) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit[] units = (IInstallableUnit[])queryResult.toArray((Class)clazz);
        Arrays.sort(units, new Comparator<IInstallableUnit>(){

            @Override
            public int compare(IInstallableUnit arg0, IInstallableUnit arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        return units;
    }

    public void _provlgp(CommandInterpreter interpreter) {
        IProfile profile;
        String profileId = this.processArgument(interpreter.nextArgument());
        if (profileId == null || profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if ((profile = ProvisioningHelper.getProfile(this.agent, profileId)) == null) {
            if (profileId.equals("_SELF_")) {
                interpreter.println((Object)"No profile found");
            } else {
                interpreter.println((Object)new StringBuffer("Profile ").append(profileId).append(" not found").toString());
            }
            return;
        }
        IInstallableUnit[] units = this.sort((IQueryResult<IInstallableUnit>)profile.query(QueryUtil.createIUGroupQuery(), (IProgressMonitor)new NullProgressMonitor()));
        int i = 0;
        while (i < units.length) {
            this.println(interpreter, units[i]);
            ++i;
        }
    }

    public void _provlpquery(CommandInterpreter interpreter) {
        String expression;
        String profileId = this.processArgument(interpreter.nextArgument());
        if (profileId == null || profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if ((expression = this.processArgument(interpreter.nextArgument())) == null) {
            interpreter.println((Object)"Please enter a query");
            return;
        }
        boolean useFull = Boolean.valueOf(this.processArgument(interpreter.nextArgument()));
        IQuery query = useFull ? QueryUtil.createQuery((String)expression, (Object[])new Object[0]) : QueryUtil.createMatchQuery((String)expression, (Object[])new Object[0]);
        IProfile profile = ProvisioningHelper.getProfile(this.agent, profileId);
        if (profile == null) {
            if (profileId.equals("_SELF_")) {
                interpreter.println((Object)"No profile found");
            } else {
                interpreter.println((Object)new StringBuffer("Profile ").append(profileId).append(" not found").toString());
            }
            return;
        }
        IInstallableUnit[] units = this.sort((IQueryResult<IInstallableUnit>)profile.query(query, (IProgressMonitor)new NullProgressMonitor()));
        if (units.length == 0) {
            interpreter.println((Object)"No units found");
        } else {
            int i = 0;
            while (i < units.length) {
                this.println(interpreter, units[i]);
                ++i;
            }
        }
    }

    public void _provremove(CommandInterpreter interpreter) {
        String iu = interpreter.nextArgument();
        String version = interpreter.nextArgument();
        String profileId = interpreter.nextArgument();
        if (profileId == null || profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if (version == null) {
            version = Version.emptyVersion.toString();
        }
        if (iu == null) {
            interpreter.println((Object)"Installable unit id must be provided");
            return;
        }
        IProfile profile = ProvisioningHelper.getProfile(this.agent, profileId);
        if (profile == null) {
            if (profileId.equals("_SELF_")) {
                interpreter.println((Object)"No profile found");
            } else {
                interpreter.println((Object)new StringBuffer("Profile ").append(profileId).append(" not found").toString());
            }
            return;
        }
        IStatus s = null;
        try {
            s = ProvisioningHelper.uninstall(this.agent, iu, version, profile, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            interpreter.println((Object)new StringBuffer("Remove failed with ProvisionException for ").append(iu).append(" ").append(version).toString());
            interpreter.printStackTrace((Throwable)e);
            return;
        }
        if (s.isOK()) {
            interpreter.println((Object)new StringBuffer("Remove complete for ").append(iu).append(" ").append(version).toString());
        } else {
            interpreter.println((Object)new StringBuffer("Remove failed for ").append(iu).append(" ").append(version).toString());
            this.printErrorStatus(interpreter, s);
        }
    }

    public Object _help(CommandInterpreter intp) {
        String commandName = intp.nextArgument();
        if (commandName == null) {
            return new Boolean(false);
        }
        String help = this.getHelp(commandName);
        return help.length() > 0 ? help : new Boolean(false);
    }

    private void printErrorStatus(CommandInterpreter interpreter, IStatus status) {
        IStatus[] children;
        interpreter.print((Object)"--Error status ");
        interpreter.print((Object)new StringBuffer("message=").append(status.getMessage()).toString());
        interpreter.print((Object)new StringBuffer(",code=").append(status.getCode()).toString());
        String severityString = null;
        switch (status.getSeverity()) {
            case 1: {
                severityString = "INFO";
                break;
            }
            case 8: {
                severityString = "CANCEL";
                break;
            }
            case 2: {
                severityString = "WARNING";
                break;
            }
            case 4: {
                severityString = "ERROR";
            }
        }
        interpreter.print((Object)new StringBuffer(",severity=").append(severityString).toString());
        interpreter.print((Object)new StringBuffer(",bundle=").append(status.getPlugin()).toString());
        interpreter.println((Object)"--");
        Throwable t = status.getException();
        if (t != null) {
            interpreter.printStackTrace(t);
        }
        if ((children = status.getChildren()) != null && children.length > 0) {
            interpreter.println((Object)"Error status children:");
            int i = 0;
            while (i < children.length) {
                this.printErrorStatus(interpreter, children[i]);
                ++i;
            }
        }
        interpreter.println((Object)"--End Error Status--");
    }

    public String getHelp() {
        return this.getHelp(null);
    }

    private String getHelp(String commandName) {
        StringBuffer help = new StringBuffer();
        if (this.commandsHelp == null) {
            this.initializeCommandsHelp();
        }
        if (this.commandGroups == null) {
            this.initializeCommandGroups();
        }
        if (commandName != null) {
            if (this.commandsHelp.containsKey(commandName)) {
                this.addCommand(commandName, this.commandsHelp.get(commandName), help);
            }
            return help.toString();
        }
        this.addHeader(Messages.Console_help_header, help);
        for (Map.Entry<String, String[]> groupEntry : this.commandGroups.entrySet()) {
            this.addHeader(groupEntry.getKey(), help);
            String[] stringArray = groupEntry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                this.addCommand(command, this.commandsHelp.get(command), help);
                ++n2;
            }
        }
        return help.toString();
    }

    private void addHeader(String header, StringBuffer help) {
        help.append("---");
        help.append(header);
        help.append("---");
        help.append(NEW_LINE);
    }

    private void addCommand(String command, String description, StringBuffer help) {
        help.append(TAB);
        help.append(command);
        help.append(" ");
        help.append(description);
        help.append(NEW_LINE);
    }

    private void initializeCommandsHelp() {
        this.commandsHelp = new HashMap<String, String>();
        this.commandsHelp.put("provaddrepo", Messages.Console_help_provaddrepo_description);
        this.commandsHelp.put("provdelrepo", Messages.Console_help_provdelrepo_description);
        this.commandsHelp.put("provaddmetadatarepo", Messages.Console_help_provaddmetadatarepo_description);
        this.commandsHelp.put("provdelmetadatarepo", Messages.Console_help_provdelmetadatarepo_description);
        this.commandsHelp.put("provaddartifactrepo", Messages.Console_help_provaddartifactrepo_description);
        this.commandsHelp.put("provdelartifactrepo", Messages.Console_help_provdelartifactrepo_description);
        this.commandsHelp.put("provlg", Messages.Console_help_provlg_description);
        this.commandsHelp.put("provlr", Messages.Console_help_provlr_description);
        this.commandsHelp.put("provlar", Messages.Console_help_provlar_description);
        this.commandsHelp.put("provliu", Messages.Console_help_provliu_description);
        this.commandsHelp.put("provlquery", Messages.Console_help_provlquery_description);
        this.commandsHelp.put("provaddprofile", Messages.Console_help_provaddprofile_description);
        this.commandsHelp.put("provdelprofile", Messages.Console_help_provdelprofile_description);
        this.commandsHelp.put("provlp", Messages.Console_help_provlp_description);
        this.commandsHelp.put("provlgp", Messages.Console_help_provlgp_description);
        this.commandsHelp.put("provlpts", Messages.Console_help_provlpts_description);
        this.commandsHelp.put("provlpquery", Messages.Console_help_provlpquery_description);
        this.commandsHelp.put("provinstall", Messages.Console_help_provinstall_description);
        this.commandsHelp.put("provremove", Messages.Console_help_provremove_description);
        this.commandsHelp.put("provrevert", Messages.Console_help_provrevert_description);
    }

    private void initializeCommandGroups() {
        this.commandGroups = new LinkedHashMap<String, String[]>();
        this.commandGroups.put(Messages.Console_help_repository_header, new String[]{"provaddrepo", "provdelrepo", "provaddmetadatarepo", "provdelmetadatarepo", "provaddartifactrepo", "provdelartifactrepo", "provlg", "provlr", "provlar", "provliu", "provlquery"});
        this.commandGroups.put(Messages.Console_help_profile_registry_header, new String[]{"provaddprofile", "provdelprofile", "provlp", "provlgp", "provlpts", "provlpquery"});
        this.commandGroups.put(Messages.Console_help_install_header, new String[]{"provinstall", "provremove", "provrevert"});
    }

    public void print(CommandInterpreter interpreter, IInstallableUnit unit) {
        interpreter.print((Object)new StringBuffer(String.valueOf(unit.getId())).append(' ').append(unit.getVersion()).toString());
    }

    public void println(CommandInterpreter interpreter, IInstallableUnit unit) {
        this.print(interpreter, unit);
        interpreter.println();
    }

    private void println(CommandInterpreter interpreter, IArtifactKey artifactKey, File location) {
        interpreter.print((Object)new StringBuffer(String.valueOf(artifactKey.toString())).append(' ').append(location).toString());
        interpreter.println();
    }
}

