/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.forcing.impl;

import java.io.FileWriter;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.forcing.ForcingPackage;
import org.eclipse.stem.diseasemodels.forcing.Gaussian3ForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.forcing.impl.Gaussian2ForcingDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class Gaussian3ForcingDiseaseModelImpl
extends Gaussian2ForcingDiseaseModelImpl
implements Gaussian3ForcingDiseaseModel {
    protected static final double SIGMA2_3_EDEFAULT = 100.0;
    protected double sigma2_3 = 100.0;
    protected static final double TRANSMISSION_RATE2_EDEFAULT = 0.0;
    protected double transmissionRate2 = 0.0;
    protected static final double TRANSMISSION_RATE3_EDEFAULT = 0.0;
    protected double transmissionRate3 = 0.0;
    protected static final double MODULATION_FLOOR_2_EDEFAULT = 0.6;
    protected double modulationFloor_2 = 0.6;
    private ArrayList<Long> writtedTimes = new ArrayList();
    private FileWriter fw;
    private static final int WINDOWSIZE = 60;
    HYP currentHypothesis = HYP.H1;
    private int[] whichGaussian;

    public Gaussian3ForcingDiseaseModelImpl() {
        int[] nArray = new int[11];
        nArray[5] = 1;
        nArray[8] = 1;
        this.whichGaussian = nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedTransmissionRate = this.getAdjustedTransmissionRate(this.getTransmissionRate(), timeDelta);
        double adjustedTransmissionRate2 = this.getAdjustedTransmissionRate(this.getTransmissionRate2(), timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SIRLabelValue currentSIR = (SIRLabelValue)currentState;
            double modulationPeriod = this.getModulationPeriod();
            double sigma2 = this.getSigma2();
            double sigma2_2 = this.getSigma2_2();
            int year = (int)(t / modulationPeriod);
            int nextDayYear = (int)((t + 1.0) / modulationPeriod);
            double fday = (t % modulationPeriod - modulationPeriod / 2.0) / modulationPeriod;
            int gaussian = this.whichGaussian[year];
            double f1 = 0.0;
            switch (this.currentHypothesis) {
                case H0: {
                    f1 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday, 2.0) / (2.0 * sigma2)));
                    break;
                }
                case H1: {
                    if (gaussian == 0) {
                        f1 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday, 2.0) / (2.0 * sigma2)));
                        break;
                    }
                    if (gaussian != 1) break;
                    f1 = adjustedTransmissionRate2 * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday, 2.0) / (2.0 * sigma2)));
                    break;
                }
                case H2: {
                    if (gaussian == 0) {
                        f1 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday, 2.0) / (2.0 * sigma2)));
                        break;
                    }
                    if (gaussian != 1) break;
                    f1 = adjustedTransmissionRate2 * (this.getModulationFloor_2() + (1.0 - this.getModulationFloor_2()) * Math.exp(-Math.pow(fday, 2.0) / (2.0 * sigma2_2)));
                    break;
                }
            }
            double modulatedTransmissionRate = 0.0;
            if (t % modulationPeriod < 60.0 || t % modulationPeriod > modulationPeriod - 60.0) {
                double f2 = 0.0;
                double f3 = 0.0;
                int nextGaussian = 0;
                nextGaussian = year == this.whichGaussian.length - 1 ? gaussian : this.whichGaussian[year + 1];
                int prevGaussian = 0;
                prevGaussian = year == 0 ? gaussian : this.whichGaussian[year - 1];
                switch (this.currentHypothesis) {
                    case H0: {
                        f2 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday - 1.0, 2.0) / (2.0 * sigma2)));
                        f3 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday + 1.0, 2.0) / (2.0 * sigma2)));
                        break;
                    }
                    case H1: {
                        if (nextGaussian == 0) {
                            f2 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday - 1.0, 2.0) / (2.0 * sigma2)));
                        } else if (nextGaussian == 1) {
                            f2 = adjustedTransmissionRate2 * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday - 1.0, 2.0) / (2.0 * sigma2)));
                        }
                        if (prevGaussian == 0) {
                            f3 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday + 1.0, 2.0) / (2.0 * sigma2)));
                            break;
                        }
                        if (prevGaussian != 1) break;
                        f3 = adjustedTransmissionRate2 * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday + 1.0, 2.0) / (2.0 * sigma2)));
                        break;
                    }
                    case H2: {
                        if (nextGaussian == 0) {
                            f2 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday - 1.0, 2.0) / (2.0 * sigma2)));
                        } else if (nextGaussian == 1) {
                            f2 = adjustedTransmissionRate2 * (this.getModulationFloor_2() + (1.0 - this.getModulationFloor_2()) * Math.exp(-Math.pow(fday - 1.0, 2.0) / (2.0 * sigma2_2)));
                        }
                        if (prevGaussian == 0) {
                            f3 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday + 1.0, 2.0) / (2.0 * sigma2)));
                            break;
                        }
                        if (prevGaussian != 1) break;
                        f3 = adjustedTransmissionRate2 * (this.getModulationFloor_2() + (1.0 - this.getModulationFloor_2()) * Math.exp(-Math.pow(fday + 1.0, 2.0) / (2.0 * sigma2_2)));
                        break;
                    }
                }
                double pos = t % modulationPeriod > modulationPeriod - 60.0 ? 60.0 - (modulationPeriod - t % modulationPeriod) : 60.0 + t % modulationPeriod;
                pos = Math.floor(pos);
                double smooth = 0.0;
                smooth = pos == 60.0 && nextDayYear == year ? 0.5 * f1 + 0.5 * f3 : (pos == 60.0 && nextDayYear == year + 1 ? 0.5 * f1 + 0.5 * f2 : (pos < 60.0 ? (120.0 - pos) / 120.0 * f1 + pos / 120.0 * f2 : pos / 120.0 * f1 + (120.0 - pos) / 120.0 * f3));
                modulatedTransmissionRate = smooth;
            } else {
                modulatedTransmissionRate = f1;
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            ArrayList<Long> f2 = this.writtedTimes;
            synchronized (f2) {
                if (!this.writtedTimes.contains(time.getTime().getTime()) && diseaseLabel.getNode().getURI().lastSegment().contains("IL-03-111")) {
                    try {
                        if (this.fw == null) {
                            this.fw = new FileWriter("beta.csv");
                        }
                        this.fw.write(String.valueOf(time.getTime().getTime()) + "," + modulatedTransmissionRate + "\n");
                        this.fw.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.writtedTimes.add(time.getTime().getTime());
                }
            }
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSIR.getR();
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? modulatedTransmissionRate * currentSIR.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : modulatedTransmissionRate * currentSIR.getS() * effectiveInfectious;
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToInfected;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    public double getAdjustedTransmissionRate(double tr, long timeDelta) {
        return tr * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    protected EClass eStaticClass() {
        return ForcingPackage.Literals.GAUSSIAN3_FORCING_DISEASE_MODEL;
    }

    @Override
    public double getSigma2_3() {
        return this.sigma2_3;
    }

    @Override
    public void setSigma2_3(double newSigma2_3) {
        this.sigma2_3 = newSigma2_3;
    }

    @Override
    public double getTransmissionRate2() {
        return this.transmissionRate2;
    }

    @Override
    public void setTransmissionRate2(double newTransmissionRate2) {
        this.transmissionRate2 = newTransmissionRate2;
    }

    @Override
    public double getTransmissionRate3() {
        return this.transmissionRate3;
    }

    @Override
    public void setTransmissionRate3(double newTransmissionRate3) {
        this.transmissionRate3 = newTransmissionRate3;
    }

    @Override
    public double getModulationFloor_2() {
        return this.modulationFloor_2;
    }

    @Override
    public void setModulationFloor_2(double newModulationFloor_2) {
        this.modulationFloor_2 = newModulationFloor_2;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 33: {
                return this.getSigma2_3();
            }
            case 34: {
                return this.getTransmissionRate2();
            }
            case 35: {
                return this.getTransmissionRate3();
            }
            case 36: {
                return this.getModulationFloor_2();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 33: {
                this.setSigma2_3((Double)newValue);
                return;
            }
            case 34: {
                this.setTransmissionRate2((Double)newValue);
                return;
            }
            case 35: {
                this.setTransmissionRate3((Double)newValue);
                return;
            }
            case 36: {
                this.setModulationFloor_2((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 33: {
                this.setSigma2_3(100.0);
                return;
            }
            case 34: {
                this.setTransmissionRate2(0.0);
                return;
            }
            case 35: {
                this.setTransmissionRate3(0.0);
                return;
            }
            case 36: {
                this.setModulationFloor_2(0.6);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 33: {
                return this.sigma2_3 != 100.0;
            }
            case 34: {
                return this.transmissionRate2 != 0.0;
            }
            case 35: {
                return this.transmissionRate3 != 0.0;
            }
            case 36: {
                return this.modulationFloor_2 != 0.6;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sigma2_3: ");
        result.append(this.sigma2_3);
        result.append(", transmissionRate2: ");
        result.append(this.transmissionRate2);
        result.append(", transmissionRate3: ");
        result.append(this.transmissionRate3);
        result.append(", modulationFloor_2: ");
        result.append(this.modulationFloor_2);
        result.append(')');
        return result.toString();
    }

    static enum HYP {
        H0,
        H1,
        H2;

    }
}

