/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AxisType implements Enumerator
{
    LINEAR_LITERAL(0, "Linear", "Linear"),
    LOGARITHMIC_LITERAL(1, "Logarithmic", "Logarithmic"),
    TEXT_LITERAL(2, "Text", "Text"),
    DATE_TIME_LITERAL(3, "DateTime", "DateTime");

    public static final int LINEAR = 0;
    public static final int LOGARITHMIC = 1;
    public static final int TEXT = 2;
    public static final int DATE_TIME = 3;
    private static final AxisType[] VALUES_ARRAY;
    public static final List<AxisType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AxisType[]{LINEAR_LITERAL, LOGARITHMIC_LITERAL, TEXT_LITERAL, DATE_TIME_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AxisType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType get(int value) {
        switch (value) {
            case 0: {
                return LINEAR_LITERAL;
            }
            case 1: {
                return LOGARITHMIC_LITERAL;
            }
            case 2: {
                return TEXT_LITERAL;
            }
            case 3: {
                return DATE_TIME_LITERAL;
            }
        }
        return null;
    }

    private AxisType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

