/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.populationmodels.standard.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.populationmodels.standard.PopulationInitializer;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.populationmodels.standard.wizards.NewPopulationInitializerWizard;
import org.eclipse.stem.ui.populationmodels.standard.wizards.PopulationInitializerPropertyComposite;
import org.eclipse.stem.ui.populationmodels.standard.wizards.PopulationModelWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PopulationInitializerDefinitionControl
extends Composite {
    private static PopulationInitializer[] populationInitializers = null;
    private final Combo combo;
    private final PopulationInitializerPropertyComposite populationInitializerPropertyComposite;
    private String isoKey = "";
    private URI targetURI = null;
    private NewPopulationInitializerWizard newPopulationInitializerWizard;

    public PopulationInitializerDefinitionControl(Composite parent, int style, ModifyListener projectValidator, IProject project, NewPopulationInitializerWizard npiwz) {
        super(parent, style);
        this.newPopulationInitializerWizard = npiwz;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label populationInitializerLabel = new Label((Composite)this, 0);
        GridData gd_populationInitializerLabel = new GridData(4, 0x1000000, true, false);
        gd_populationInitializerLabel.widthHint = 100;
        populationInitializerLabel.setLayoutData((Object)gd_populationInitializerLabel);
        populationInitializerLabel.setText(PopulationModelWizardMessages.getString("DDC.5"));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setTextLimit(30);
        GridData gd_combo = new GridData(4, 0x1000000, true, false);
        gd_combo.widthHint = 303;
        this.combo.setLayoutData((Object)gd_combo);
        this.combo.setToolTipText(PopulationModelWizardMessages.getString("DDC.1"));
        this.combo.setItems(this.getPopulationInitializerNames(this.getPopulationInitializers()));
        this.combo.select(0);
        this.combo.addModifyListener(projectValidator);
        this.populationInitializerPropertyComposite = new PopulationInitializerPropertyComposite(this, 0, this.getPopulationInitializers(), projectValidator, project);
        GridData gd_populationInitializerPropertyControl = new GridData(4, 0x1000000, true, false, 2, 1);
        this.populationInitializerPropertyComposite.setLayoutData(gd_populationInitializerPropertyControl);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopulationInitializerDefinitionControl.this.populationInitializerPropertyComposite.displayPopulationInitializer(PopulationInitializerDefinitionControl.this.getPopulationInitializers()[PopulationInitializerDefinitionControl.this.combo.getSelectionIndex()]);
                ((PopulationInitializerDefinitionControl)PopulationInitializerDefinitionControl.this).newPopulationInitializerWizard.newDublinCorePage.updateDublinCorePage(PopulationInitializerDefinitionControl.this.getSelectedPopulationInitializer().getDublinCore());
            }
        });
    }

    private PopulationInitializer[] getPopulationInitializers() {
        if (populationInitializers == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] populationInitializerConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.populationmodels.populationinitializer");
            ArrayList<PopulationInitializer> temp = new ArrayList<PopulationInitializer>();
            ArrayList<DublinCore> dctemp = new ArrayList<DublinCore>();
            populationInitializers = new PopulationInitializer[populationInitializerConfigElements.length];
            int i = 0;
            while (i < populationInitializerConfigElements.length) {
                IConfigurationElement element = populationInitializerConfigElements[i];
                if (element.getName().equals("classdef")) {
                    try {
                        temp.add((PopulationInitializer)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        Activator.logError((String)PopulationModelWizardMessages.getString("DDC.4"), (Throwable)e);
                    }
                } else if (element.getName().equals("dublin_core")) {
                    dctemp.add(Utility.getPluginDublinCore((IConfigurationElement)element));
                }
                ++i;
            }
            populationInitializers = temp.toArray(new PopulationInitializer[0]);
            int n = 0;
            while (n < populationInitializers.length) {
                populationInitializers[n].setDublinCore((DublinCore)dctemp.get(n));
                ++n;
            }
        }
        return populationInitializers;
    }

    private String[] getPopulationInitializerNames(PopulationInitializer[] populationModels) {
        String[] retValue = new String[populationInitializers.length];
        int i = 0;
        while (i < populationInitializers.length) {
            String name = populationInitializers[i].getDublinCore().getTitle();
            if (name == null || name.equals("")) {
                name = populationInitializers[i].getClass().getSimpleName();
            }
            retValue[i] = name;
            ++i;
        }
        return retValue;
    }

    PopulationInitializer getSelectedPopulationInitializer() {
        PopulationInitializer retValue = (PopulationInitializer)EcoreUtil.copy((EObject)this.getPopulationInitializers()[this.combo.getSelectionIndex()]);
        this.populationInitializerPropertyComposite.populatePopulationInitializer(retValue);
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return this.populationInitializerPropertyComposite.validate();
    }

    public String getErrorMessage() {
        return this.populationInitializerPropertyComposite.getErrorMessage();
    }

    public String getIsoKey() {
        return this.isoKey;
    }

    public URI getTargetURI() {
        return this.targetURI;
    }
}

