/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.target.Messages;
import org.osgi.framework.BundleException;

public class ManifestUtils {
    static /* synthetic */ Class class$0;

    private ManifestUtils() {
    }

    public static IPackageFragmentRoot[] findPackageFragmentRoots(IManifestHeader header, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String[] libs = header == null || header.getValue() == null ? new String[]{"."} : header.getValue().split(",");
        IBuild build = ManifestUtils.getBuild(project);
        if (build == null) {
            try {
                return javaProject.getPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {
                return new IPackageFragmentRoot[0];
            }
        }
        LinkedList<IPackageFragmentRoot> pkgFragRoots = new LinkedList<IPackageFragmentRoot>();
        int j = 0;
        while (j < libs.length) {
            String lib = libs[j];
            IPackageFragmentRoot root = null;
            if (!lib.equals(".")) {
                try {
                    root = javaProject.getPackageFragmentRoot((IResource)project.getFile(lib));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return new IPackageFragmentRoot[0];
                }
            }
            if (root != null && root.exists()) {
                pkgFragRoots.add(root);
            } else {
                IBuildEntry entry = build.getEntry("source." + lib);
                if (entry != null) {
                    String[] tokens = entry.getTokens();
                    int i = 0;
                    while (i < tokens.length) {
                        IResource resource = project.findMember(tokens[i]);
                        if (resource != null && (root = javaProject.getPackageFragmentRoot(resource)) != null && root.exists()) {
                            pkgFragRoots.add(root);
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
        return pkgFragRoots.toArray(new IPackageFragmentRoot[pkgFragRoots.size()]);
    }

    public static final IBuild getBuild(IProject project) {
        IFile buildProps = PDEProject.getBuildProperties(project);
        if (buildProps.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildProps);
            return model.getBuild();
        }
        return null;
    }

    public static boolean isImmediateRoot(IPackageFragmentRoot root) throws JavaModelException {
        int kind = root.getKind();
        return kind == 1 || kind == 2 && !root.isExternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map loadManifest(File bundleLocation) throws CoreException {
        try {
            Map map;
            if (bundleLocation.isFile()) {
                InputStream stream;
                ZipFile jarFile;
                block15: {
                    Map map2;
                    block16: {
                        Map map3;
                        jarFile = null;
                        stream = null;
                        try {
                            Map map4;
                            jarFile = new ZipFile(bundleLocation, 1);
                            ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                            if (manifestEntry == null) break block15;
                            stream = jarFile.getInputStream(manifestEntry);
                            if (stream == null || (map4 = ManifestElement.parseBundleManifest((InputStream)stream, new Hashtable(10))) == null || !map4.containsKey("Bundle-SymbolicName")) break block16;
                            map3 = map4;
                        }
                        catch (Throwable throwable) {
                            ManifestUtils.closeZipFileAndStream(stream, jarFile);
                            throw throwable;
                        }
                        ManifestUtils.closeZipFileAndStream(stream, jarFile);
                        return map3;
                    }
                    ZipEntry pluginEntry = jarFile.getEntry("plugin.xml");
                    if (pluginEntry == null) {
                        pluginEntry = jarFile.getEntry("fragment.xml");
                    }
                    if (pluginEntry == null || (map2 = ManifestUtils.loadPluginXML(bundleLocation)) == null || !map2.containsKey("Bundle-SymbolicName")) break block15;
                    Map map5 = map2;
                    ManifestUtils.closeZipFileAndStream(stream, jarFile);
                    return map5;
                }
                ManifestUtils.closeZipFileAndStream(stream, jarFile);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)Messages.DirectoryBundleContainer_3, (Object)bundleLocation.getAbsolutePath()), null));
            }
            File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
            if (file.exists()) {
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(file);
                    Map map6 = ManifestElement.parseBundleManifest((InputStream)stream, new Hashtable(10));
                    if (map6 != null && map6.containsKey("Bundle-SymbolicName")) {
                        Map map7 = map6;
                        return map7;
                    }
                }
                finally {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
            }
            File pxml = new File(bundleLocation, "plugin.xml");
            File fxml = new File(bundleLocation, "fragment.xml");
            if (!pxml.exists()) {
                if (!fxml.exists()) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)Messages.DirectoryBundleContainer_3, (Object)bundleLocation.getAbsolutePath()), null));
            }
            if ((map = ManifestUtils.loadPluginXML(bundleLocation)) == null) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)Messages.DirectoryBundleContainer_3, (Object)bundleLocation.getAbsolutePath()), null));
            if (!map.containsKey("Bundle-SymbolicName")) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)Messages.DirectoryBundleContainer_3, (Object)bundleLocation.getAbsolutePath()), null));
            return map;
        }
        catch (BundleException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)Messages.DirectoryBundleContainer_3, (Object)bundleLocation.getAbsolutePath()), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 0, NLS.bind((String)Messages.DirectoryBundleContainer_3, (Object)bundleLocation.getAbsolutePath()), (Throwable)e));
        }
    }

    private static Map loadPluginXML(File pluginLocation) throws CoreException {
        PluginConverter converter;
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((converter = (PluginConverter)pDECore.acquireService(clazz.getName())) != null) {
            try {
                Dictionary convert = converter.convertManifest(pluginLocation, false, null, false, null);
                if (convert != null) {
                    HashMap map = new HashMap(convert.size(), 1.0f);
                    Enumeration keys = convert.keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        map.put(key, convert.get(key));
                    }
                    return map;
                }
            }
            catch (PluginConversionException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.DirectoryBundleContainer_2, (Object)pluginLocation.getAbsolutePath()), (Throwable)e));
            }
        }
        return null;
    }

    private static void closeZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
    }
}

