/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TransitionEditorDialog
extends Dialog {
    protected ComboViewer sourceCompartmentComboViewer;
    protected ComboViewer targetCompartmentComboViewer;
    protected ComboViewer incidenceCompartmentComboViewer;
    protected Transition transition;
    protected Transition originalTransition;
    protected Model parentModel;
    protected String errorMessage = null;

    public TransitionEditorDialog(Shell parentShell, int style, Model model, Transition transition, Transition originalTransition) {
        super(parentShell);
        this.transition = transition;
        this.originalTransition = originalTransition;
        this.parentModel = model;
    }

    public void create() {
        super.create();
        if (this.transition.getSource() != null) {
            this.sourceCompartmentComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.transition.getSource()));
        }
        if (this.transition.getTarget() != null) {
            this.targetCompartmentComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.transition.getTarget()));
        }
        if (this.transition.getForIncidence() != null) {
            this.incidenceCompartmentComboViewer.setSelection((ISelection)new StructuredSelection((List)this.transition.getForIncidence()));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(2, false));
        this.createCompartmentViewers(container);
        return parent;
    }

    private void createCompartmentViewers(Composite container) {
        Label sourceCompartmentLabel = new Label(container, 0);
        sourceCompartmentLabel.setText("Source Compartment");
        this.sourceCompartmentComboViewer = new ComboViewer(container, 8);
        this.sourceCompartmentComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.sourceCompartmentComboViewer.setLabelProvider((IBaseLabelProvider)new CompartmentNameLabelProvider());
        this.sourceCompartmentComboViewer.setInput(WizardHelper.getAllCompartmentsForModel(this.parentModel));
        Label targetCompartmentLabel = new Label(container, 0);
        targetCompartmentLabel.setText("Target Compartment");
        this.targetCompartmentComboViewer = new ComboViewer(container, 8);
        this.targetCompartmentComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.targetCompartmentComboViewer.setLabelProvider((IBaseLabelProvider)new CompartmentNameLabelProvider());
        this.targetCompartmentComboViewer.setInput(WizardHelper.getAllCompartmentsForModel(this.parentModel));
        Label incidenceForLabel = new Label(container, 0);
        incidenceForLabel.setText("For Incidence");
        List<Compartment> incidenceCompartments = WizardHelper.getAllIncidenceCompartmentsForModel(this.parentModel);
        this.incidenceCompartmentComboViewer = new ComboViewer(container, 8);
        this.incidenceCompartmentComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.incidenceCompartmentComboViewer.setLabelProvider((IBaseLabelProvider)new CompartmentNameLabelProvider(false));
        this.incidenceCompartmentComboViewer.setInput(incidenceCompartments);
        this.incidenceCompartmentComboViewer.getCombo().setLayoutData((Object)new GridData(768));
    }

    protected boolean validate() {
        if (this.getSelectedSourceCompartment() == null || this.getSelectedTargetCompartment() == null) {
            this.errorMessage = "Please select a source and target compartment for this transition";
            return false;
        }
        if (this.hasSourceTargetConflict()) {
            this.errorMessage = "A transition already exists for the selected source-target pair.";
            return false;
        }
        return true;
    }

    protected Compartment getSelectedSourceCompartment() {
        return (Compartment)((StructuredSelection)this.sourceCompartmentComboViewer.getSelection()).getFirstElement();
    }

    protected Compartment getSelectedTargetCompartment() {
        return (Compartment)((StructuredSelection)this.targetCompartmentComboViewer.getSelection()).getFirstElement();
    }

    protected Compartment getSelectedIncidenceCompartment() {
        Object obj = ((StructuredSelection)this.incidenceCompartmentComboViewer.getSelection()).getFirstElement();
        if (obj == null) {
            return null;
        }
        return (Compartment)obj;
    }

    private boolean hasSourceTargetConflict() {
        if (this.originalTransition != null && this.originalTransition.getSource() == this.getSelectedSourceCompartment() && this.originalTransition.getTarget() == this.getSelectedTargetCompartment()) {
            return false;
        }
        for (Transition existingTransition : this.parentModel.getTransitions()) {
            if (existingTransition.getSource() != this.getSelectedSourceCompartment() || existingTransition.getTarget() != this.getSelectedTargetCompartment()) continue;
            return true;
        }
        return false;
    }

    protected void okPressed() {
        if (this.validate()) {
            Compartment source = this.getSelectedSourceCompartment();
            Compartment target = this.getSelectedTargetCompartment();
            this.transition.setName(String.valueOf(source.getName()) + " -> " + target.getName());
            this.transition.setSource(source);
            this.transition.setTarget(target);
            this.transition.getForIncidence().clear();
            this.transition.getForIncidence().add((Object)this.getSelectedIncidenceCompartment());
            super.okPressed();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)this.errorMessage);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private static class CompartmentNameLabelProvider
    extends LabelProvider {
        boolean showType = true;

        CompartmentNameLabelProvider() {
        }

        CompartmentNameLabelProvider(boolean showType) {
            this.showType = showType;
        }

        public String getText(Object element) {
            if (element instanceof Compartment) {
                Compartment c = (Compartment)element;
                String s = c.getName();
                if (this.showType) {
                    s = String.valueOf(s) + " (" + c.getType() + ")";
                }
                return s;
            }
            return "";
        }
    }
}

