/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.util.CSVScenarioStreamer;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.populationmodels.Activator;
import org.eclipse.stem.populationmodels.standard.ExternalDataSourcePopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardFactory;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.PopulationModelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelValueImpl;
import org.eclipse.stem.populationmodels.standard.provider.StandardItemProviderAdapterFactory;

public class ExternalDataSourcePopulationModelImpl
extends PopulationModelImpl
implements ExternalDataSourcePopulationModel {
    protected Set<String> BIRTH_KEY_SET = new HashSet<String>();
    protected Set<String> DEATHS_KEY_SET = new HashSet<String>();
    protected Set<String> COUNT_KEY_SET = new HashSet<String>();
    public static String labelBirths = null;
    public static String labelDeaths = null;
    public static String labelCount = null;
    private String[] cumulativeStates = new String[]{"Births", "Deaths"};
    protected Map<String, List<IItemPropertyDescriptor>> propertyDescriptors;
    private STEMTime previousTime = null;
    CSVScenarioStreamer streamer;
    private double fileLineCounter = 0.0;
    private String populationType;
    private Decorator populationModel;
    public static final String LOCATIONID_PREFIX = "/node/geo/region/";
    protected static final String DATA_PATH_EDEFAULT = null;
    protected String dataPath = DATA_PATH_EDEFAULT;
    protected static final int BUFFER_SIZE_EDEFAULT = 250;
    protected int bufferSize = 250;
    protected static final boolean RESTART_EDEFAULT = true;
    protected boolean restart = true;

    @Override
    protected Collection<PopulationLabel> getPopulationLabels(String populationIdentifier, Graph graph) {
        ArrayList<PopulationLabel> retValue = new ArrayList<PopulationLabel>();
        this.setupStreaming();
        EList labels = graph.getNodeLabelsByTypeURI(PopulationLabel.URI_TYPE_POPULATION_LABEL);
        for (NodeLabel pl : labels) {
            if (this.getTargetISOKey() != null && !this.getTargetISOKey().trim().equals("") && pl.getNode() != null && !this.isContained(pl.getNode(), this.getTargetISOKey()) && !pl.getNode().getURI().lastSegment().equals("ZZZ")) continue;
            PopulationLabel populationLabel = (PopulationLabel)pl;
            List pops = this.streamer.getPopulationIdentifiers();
            if (pops == null) {
                if (!populationLabel.getPopulationIdentifier().equals(populationIdentifier) || populationLabel.getNode() == null) continue;
                retValue.add(populationLabel);
                continue;
            }
            for (String p : pops) {
                if (!populationLabel.getPopulationIdentifier().equals(p) || populationLabel.getNode() == null) continue;
                retValue.add(populationLabel);
            }
        }
        return retValue;
    }

    @Override
    public void resetLabels() throws ScenarioInitializationException {
        super.resetLabels();
        this.fileLineCounter = 0.0;
        try {
            if (this.streamer != null) {
                this.streamer.close();
            }
        }
        catch (IOException ioe) {
            throw new ScenarioInitializationException("IOException closing streamer", (Identifiable)this, (Exception)ioe);
        }
        this.streamer = null;
        this.setupStreaming();
        for (StandardPopulationModelLabel popLabel : this.getLabelsToUpdate()) {
            StandardPopulationModelLabelValue deltaState = (StandardPopulationModelLabelValue)popLabel.getDeltaValue();
            this.importPopulationData(deltaState, popLabel, null, 0L);
            while (deltaState.getArrivals().size() > 0) {
                ExchangePool.POOL.release(deltaState.getArrivals().remove(0));
            }
            while (deltaState.getDepartures().size() > 0) {
                ExchangePool.POOL.release(deltaState.getDepartures().remove(0));
            }
            ((StandardPopulationModelLabelValue)popLabel.getCurrentValue()).add(deltaState);
        }
    }

    private void setPropertyLabels() {
        StandardItemProviderAdapterFactory itemProviderFactory = new StandardItemProviderAdapterFactory();
        if (this.populationModel == null) {
            StandardPopulationModelLabelValue popLabelValue = (StandardPopulationModelLabelValue)StandardFactory.eINSTANCE.createStandardPopulationModelLabel().getCurrentValue();
            IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)popLabelValue, (Object)PropertySource.class);
            List properties = propertySource.getPropertyDescriptors(null);
            IItemPropertyDescriptor propertyBirths = (IItemPropertyDescriptor)properties.get(3);
            IItemPropertyDescriptor propertyDeaths = (IItemPropertyDescriptor)properties.get(4);
            IItemPropertyDescriptor propertyCount = (IItemPropertyDescriptor)properties.get(2);
            labelBirths = propertyBirths.getDisplayName((Object)propertyBirths);
            labelDeaths = propertyDeaths.getDisplayName((Object)propertyDeaths);
            labelCount = propertyCount.getDisplayName((Object)propertyCount);
        } else {
            PopulationModel pm = (PopulationModel)this.populationModel;
            for (String popId : this.streamer.getPopulationIdentifiers()) {
                PopulationModelLabel spml = pm.createPopulationModelLabel(popId);
                RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)spml, RelativeValueProvider.class);
                rvp.setTarget((Notifier)spml);
                List properties = rvp.getProperties();
                if (this.propertyDescriptors == null) {
                    this.propertyDescriptors = new HashMap<String, List<IItemPropertyDescriptor>>();
                }
                this.propertyDescriptors.put(popId, properties);
            }
        }
    }

    public synchronized void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double rowsPerSequencerStep = (double)timeDelta / (double)this.streamer.getTimeStepMS();
        this.fileLineCounter = t * rowsPerSequencerStep;
        for (DynamicLabel dynLabel : labels) {
            StandardPopulationModelLabel popLabel = (StandardPopulationModelLabel)dynLabel;
            assert (popLabel.getIdentifier().equals(this.getPopulationIdentifier()));
            StandardPopulationModelLabelValue deltaState = (StandardPopulationModelLabelValue)popLabel.getDeltaValue();
            this.importPopulationData(deltaState, popLabel, time, timeDelta);
            double births = deltaState.getBirths();
            double deaths = deltaState.getDeaths();
            double deltaCount = deltaState.getCount();
            if (births - deaths != deltaCount) {
                double diff = deltaCount - (births - deaths);
                if (diff > 0.0) {
                    births += diff;
                } else {
                    deaths += diff;
                }
            }
            this.computeAdditionalDeltasAndExchanges((IntegrationLabel)dynLabel, time, t, timeDelta);
        }
    }

    public StandardPopulationModelLabelValue importPopulationData(StandardPopulationModelLabelValue deltaState, StandardPopulationModelLabel popLabel, STEMTime time, long timeDelta) {
        try {
            this.setupStreaming();
            if (labelCount == null && this.propertyDescriptors == null) {
                this.setPropertyLabels();
            }
            Identifiable ident = popLabel.getIdentifiable();
            String fileName = ident.getURI().toString();
            int last = fileName.lastIndexOf(LOCATIONID_PREFIX);
            String location = fileName.substring(last += LOCATIONID_PREFIX.length(), fileName.length());
            int adminLevel = Utility.keyLevel((String)location);
            String population = popLabel.getPopulationIdentifier();
            StandardPopulationModelLabelValue currentValue = (StandardPopulationModelLabelValue)popLabel.getCurrentValue();
            if (adminLevel > -1) {
                double fraction = this.fileLineCounter - Math.floor(this.fileLineCounter);
                int row = (int)Math.floor(this.fileLineCounter);
                if (this.streamer.getDecorator() == null) {
                    double deltaCount = 0.0;
                    double deltaBirths = 0.0;
                    double deltaDeaths = 0.0;
                    population = "";
                    if (this.populationType.equals("STANDARD_POPULATION")) {
                        double d;
                        List data1 = null;
                        List data2 = null;
                        while ((double)this.streamer.getCurrentRow(population, adminLevel, labelCount) <= this.fileLineCounter) {
                            this.streamer.streamRow(population, adminLevel, labelCount);
                        }
                        data1 = this.streamer.getNthFetchedRow(population, adminLevel, labelCount, row);
                        data2 = this.streamer.getNthFetchedRow(population, adminLevel, labelCount, row + 1);
                        int pos = this.streamer.getDataPosition(population, adminLevel, location);
                        if (pos >= 0) {
                            d = this.interpolate(data1.size() > pos ? (Double)data1.get(pos) : null, (Double)data2.get(pos), fraction);
                            deltaCount = d - currentValue.getCount();
                        }
                        while ((double)this.streamer.getCurrentRow(population, adminLevel, labelBirths) <= this.fileLineCounter) {
                            this.streamer.streamRow(population, adminLevel, labelBirths);
                        }
                        data1 = this.streamer.getNthFetchedRow(population, adminLevel, labelBirths, row);
                        data2 = this.streamer.getNthFetchedRow(population, adminLevel, labelBirths, row + 1);
                        if (pos >= 0 && (deltaBirths = (d = this.interpolate(data1.size() > pos ? (Double)data1.get(pos) : null, (Double)data2.get(pos), fraction)) - currentValue.getBirths()) < 0.0) {
                            System.out.println(deltaBirths);
                        }
                        while ((double)this.streamer.getCurrentRow(population, adminLevel, labelDeaths) <= this.fileLineCounter) {
                            this.streamer.streamRow(population, adminLevel, labelDeaths);
                        }
                        data1 = this.streamer.getNthFetchedRow(population, adminLevel, labelDeaths, row);
                        data2 = this.streamer.getNthFetchedRow(population, adminLevel, labelDeaths, row + 1);
                        if (pos >= 0) {
                            d = this.interpolate(data1.size() > pos ? (Double)data1.get(pos) : null, (Double)data2.get(pos), fraction);
                            deltaDeaths = d - currentValue.getDeaths();
                        }
                    }
                    if (this.populationType.equals("STANDARD_POPULATION")) {
                        deltaState.setCount(deltaCount);
                        deltaState.setBirths(deltaBirths);
                        deltaState.setDeaths(deltaDeaths);
                        return new StandardPopulationModelLabelValueImpl();
                    }
                    throw new UnsupportedOperationException("ExternalDataSource Invalid Type " + this.populationType + " must be Standard Population Model");
                }
                List data1 = null;
                List data2 = null;
                for (IItemPropertyDescriptor propDesc : this.propertyDescriptors.get(population)) {
                    String dispName = propDesc.getDisplayName((Object)propDesc);
                    if (!this.streamer.containsState(population, adminLevel, dispName)) continue;
                    int pos = this.streamer.getDataPosition(population, adminLevel, location);
                    while ((double)this.streamer.getCurrentRow(population, adminLevel, dispName) <= this.fileLineCounter) {
                        this.streamer.streamRow(population, adminLevel, dispName);
                    }
                    data1 = this.streamer.getNthFetchedRow(population, adminLevel, dispName, row);
                    data2 = this.streamer.getNthFetchedRow(population, adminLevel, dispName, row + 1);
                    if (pos < 0) continue;
                    double d = this.interpolate(data1.size() > pos ? (Double)data1.get(pos) : null, (Double)data2.get(pos), fraction);
                    EStructuralFeature feature = (EStructuralFeature)propDesc.getFeature(null);
                    double currentVal = (Double)currentValue.eGet(feature);
                    if (feature.isDerived() || !feature.isChangeable()) continue;
                    deltaState.eSet(feature, d - currentVal);
                }
            }
        }
        catch (IOException ioe) {
            Activator.logError("Exception streaming data", ioe);
        }
        return null;
    }

    private double interpolate(Double double1, Double double2, double fraction) {
        if (double1 == null) {
            return double2;
        }
        return double1 + fraction * (double2 - double1);
    }

    private synchronized void setupStreaming() {
        if (this.streamer == null) {
            try {
                this.streamer = new CSVScenarioStreamer(this.dataPath, this.getBufferSize(), this.isRestart(), this.cumulativeStates);
                this.populationModel = this.streamer.getDecorator();
                if (this.populationModel == null) {
                    this.streamer.prepareForStreaming("", -1);
                    this.populationType = this.streamer.getType("").name();
                } else {
                    for (String pop : this.streamer.getPopulationIdentifiers()) {
                        this.streamer.prepareForStreaming(pop, -1);
                    }
                }
            }
            catch (LogInitializationException sie) {
                Activator.logError("Error reading scenario files", sie);
            }
            catch (IOException ioe) {
                Activator.logError("IOExceptopn reading scenario files", ioe);
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.EXTERNAL_DATA_SOURCE_POPULATION_MODEL;
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    @Override
    public void setDataPath(String newDataPath) {
        this.dataPath = newDataPath;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int newBufferSize) {
        this.bufferSize = newBufferSize;
    }

    @Override
    public boolean isRestart() {
        return this.restart;
    }

    @Override
    public void setRestart(boolean newRestart) {
        this.restart = newRestart;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getDataPath();
            }
            case 17: {
                return this.getBufferSize();
            }
            case 18: {
                return this.isRestart();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setDataPath((String)newValue);
                return;
            }
            case 17: {
                this.setBufferSize((Integer)newValue);
                return;
            }
            case 18: {
                this.setRestart((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setDataPath(DATA_PATH_EDEFAULT);
                return;
            }
            case 17: {
                this.setBufferSize(250);
                return;
            }
            case 18: {
                this.setRestart(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return DATA_PATH_EDEFAULT == null ? this.dataPath != null : !DATA_PATH_EDEFAULT.equals(this.dataPath);
            }
            case 17: {
                return this.bufferSize != 250;
            }
            case 18: {
                return !this.restart;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataPath: ");
        result.append(this.dataPath);
        result.append(", bufferSize: ");
        result.append(this.bufferSize);
        result.append(", restart: ");
        result.append(this.restart);
        result.append(')');
        return result.toString();
    }

    @Override
    public PopulationModelLabel createPopulationModelLabel(String populationIdentifier) {
        PopulationModelLabel retValue = null;
        this.setupStreaming();
        retValue = this.streamer.getDecorator() == null ? (this.populationType == "STANDARD_POPULATION" ? StandardFactory.eINSTANCE.createStandardPopulationModelLabel() : StandardFactory.eINSTANCE.createStandardPopulationModelLabel()) : ((PopulationModel)this.streamer.getDecorator()).createPopulationModelLabel(populationIdentifier);
        retValue.setTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        return retValue;
    }

    @Override
    public PopulationModelLabelValue createPopulationModelLabelValue(String populationIdentifier) {
        PopulationModelLabelValue retValue = null;
        retValue = this.streamer.getDecorator() == null ? (this.populationType == "STANDARD_POPULATION" ? StandardFactory.eINSTANCE.createStandardPopulationModelLabelValue() : StandardFactory.eINSTANCE.createStandardPopulationModelLabelValue()) : ((PopulationModel)this.streamer.getDecorator()).createPopulationModelLabelValue(populationIdentifier);
        return retValue;
    }
}

