/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

public class NGramTokenizer
extends Tokenizer {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private int minGram;
    private int maxGram;
    private int gramSize;
    private int pos = 0;
    private int inLen;
    private String inStr;
    private boolean started = false;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;

    public NGramTokenizer(Reader input, int minGram, int maxGram) {
        super(input);
        this.init(minGram, maxGram);
    }

    public NGramTokenizer(AttributeSource source, Reader input, int minGram, int maxGram) {
        super(source, input);
        this.init(minGram, maxGram);
    }

    public NGramTokenizer(AttributeSource.AttributeFactory factory, Reader input, int minGram, int maxGram) {
        super(factory, input);
        this.init(minGram, maxGram);
    }

    public NGramTokenizer(Reader input) {
        this(input, 1, 2);
    }

    private void init(int minGram, int maxGram) {
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.started) {
            this.started = true;
            this.gramSize = this.minGram;
            char[] chars = new char[1024];
            this.input.read(chars);
            this.inStr = new String(chars).trim();
            this.inLen = this.inStr.length();
        }
        if (this.pos + this.gramSize > this.inLen) {
            this.pos = 0;
            ++this.gramSize;
            if (this.gramSize > this.maxGram) {
                return false;
            }
            if (this.pos + this.gramSize > this.inLen) {
                return false;
            }
        }
        int oldPos = this.pos++;
        this.termAtt.setTermBuffer(this.inStr, oldPos, this.gramSize);
        this.offsetAtt.setOffset(this.correctOffset(oldPos), this.correctOffset(oldPos + this.gramSize));
        return true;
    }

    public final void end() {
        int finalOffset = this.inLen;
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.reset();
    }

    public void reset() throws IOException {
        super.reset();
        this.started = false;
        this.pos = 0;
    }
}

