/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.stem.ui.views.SimulationControl;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class SimulationControlView
extends ViewPart
implements ISimulationManagerListener {
    private SimulationManager simulationManager = null;
    private List<SimulationControl> controlList = new ArrayList<SimulationControl>();
    public static final String ID_SIMULATION_CONTROL_VIEW = "org.eclipse.stem.ui.views.simulationcontrolview";
    private ScrolledComposite scrollComposite = null;
    private Composite controlComposite = null;
    Action runAction;
    Action resetAction;
    Action pauseAction;
    Action stepAction;
    Action stopAction;
    IActionBars actionBars = null;
    IMenuManager dropDownMenu = null;
    IToolBarManager toolBar = null;
    private static final int SCROLL_MIN_LENGTH = 100;
    private static final int SCROLL_MIN_HEIGTH = 1600;

    public SimulationControlView() {
        this.simulationManager = SimulationManager.getManager();
        this.simulationManager.addSimulationManagerListener((ISimulationManagerListener)this);
    }

    public void createPartControl(Composite parent) {
        this.scrollComposite = new ScrolledComposite(parent, 2560);
        this.scrollComposite.setExpandHorizontal(true);
        this.scrollComposite.setExpandVertical(true);
        this.scrollComposite.setMinSize(100, 1600);
        this.scrollComposite.setLayout((Layout)new GridLayout());
        this.controlComposite = new Composite((Composite)this.scrollComposite, 0);
        this.scrollComposite.setContent((Control)this.controlComposite);
        GridData data = new GridData(1808);
        this.controlComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.controlComposite.setLayout((Layout)layout);
        this.runAction = new Action(Messages.getString("SCView.Run"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("run.image"))){

            public void run() {
                SimulationControlView.this.masterRunAction();
            }
        };
        this.pauseAction = new Action(Messages.getString("SCView.Pause"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("pause.image"))){

            public void run() {
                SimulationControlView.this.masterPauseAction();
            }
        };
        this.resetAction = new Action(Messages.getString("SCView.Reset"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("reset.image"))){

            public void run() {
                SimulationControlView.this.masterResetAction();
            }
        };
        this.stepAction = new Action(Messages.getString("SCView.Step"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("step.image"))){

            public void run() {
                SimulationControlView.this.masterStepAction();
            }
        };
        this.stopAction = new Action(Messages.getString("SCView.Stop"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("stop.image"))){

            public void run() {
                SimulationControlView.this.masterStopAction();
            }
        };
        this.runAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_run.image")));
        this.pauseAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_pause.image")));
        this.resetAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_reset.image")));
        this.stepAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_step.image")));
        this.stopAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_stop.image")));
        this.runAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.resetAction.setEnabled(false);
        this.stepAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.actionBars = this.getViewSite().getActionBars();
        this.dropDownMenu = this.actionBars.getMenuManager();
        this.toolBar = this.actionBars.getToolBarManager();
        this.dropDownMenu.add((IAction)this.runAction);
        this.dropDownMenu.add((IAction)this.pauseAction);
        this.dropDownMenu.add((IAction)this.resetAction);
        this.dropDownMenu.add((IAction)this.stepAction);
        this.dropDownMenu.add((IAction)this.stopAction);
        this.toolBar.add((IAction)this.runAction);
        this.toolBar.add((IAction)this.pauseAction);
        this.toolBar.add((IAction)this.resetAction);
        this.toolBar.add((IAction)this.stepAction);
        this.toolBar.add((IAction)this.stopAction);
        List list = this.simulationManager.getActiveSimulations();
        for (ISimulation sim : list) {
            this.addSimulation(sim);
        }
    }

    protected void enableMasterControl(boolean enabled) {
        this.runAction.setEnabled(enabled);
        this.pauseAction.setEnabled(enabled);
        this.resetAction.setEnabled(enabled);
        this.stepAction.setEnabled(enabled);
        this.stopAction.setEnabled(enabled);
    }

    protected void masterRunAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.run();
        }
    }

    protected void masterPauseAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.pause();
        }
    }

    protected void masterResetAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.reset();
        }
    }

    protected void masterStepAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.step();
        }
    }

    protected void masterStopAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.stop();
        }
    }

    public List<SimulationControl> getSimulationControlList() {
        return this.controlList;
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.simulationManager != null) {
            this.simulationManager.removeListener((ISimulationManagerListener)this);
        }
        if (!this.controlList.isEmpty()) {
            Iterator<SimulationControl> iter = this.controlList.iterator();
            while (iter.hasNext()) {
                SimulationControl sctrl = iter.next();
                sctrl.dispose();
                iter.remove();
            }
        }
    }

    public void simulationsChanged(SimulationManagerEvent event) {
        ISimulation[] simulations = null;
        simulations = event.getSimulationsAdded();
        int i = 0;
        while (i < simulations.length) {
            this.addSimulation(simulations[i]);
            ++i;
        }
        simulations = event.getSimulationsRemoved();
        i = 0;
        while (i < simulations.length) {
            this.removeSimulation(simulations[i]);
            ++i;
        }
        this.scrollComposite.setContent((Control)this.controlComposite);
        this.controlComposite.layout(true);
        this.scrollComposite.layout(true);
        this.scrollComposite.redraw();
    }

    private void addSimulation(ISimulation sim) {
        this.controlComposite.setRedraw(true);
        this.scrollComposite.setRedraw(true);
        SimulationControl simulationControl = new SimulationControl(this.controlComposite, sim);
        this.controlComposite.addControlListener((ControlListener)simulationControl);
        this.controlList.add(simulationControl);
        if (this.controlList.size() > 0) {
            this.enableMasterControl(true);
        }
        this.controlComposite.layout(true);
        this.scrollComposite.layout(true);
        this.scrollComposite.redraw();
    }

    private void removeSimulation(ISimulation simulation) {
        this.controlComposite.setRedraw(true);
        this.scrollComposite.setRedraw(true);
        Control[] ctrls = this.controlComposite.getChildren();
        int j = 0;
        while (j < ctrls.length) {
            SimulationControl simulationControl = (SimulationControl)ctrls[j];
            if (simulation.equals(simulationControl.getSimulation())) {
                this.controlComposite.removeControlListener((ControlListener)simulationControl);
                this.controlList.remove((Object)simulationControl);
                Composite tempComposite = new Composite((Composite)this.scrollComposite, 0);
                simulationControl.setParent(tempComposite);
                tempComposite.dispose();
                simulationControl.dispose();
                break;
            }
            ++j;
        }
        if (this.controlList.size() == 0) {
            this.enableMasterControl(false);
        }
        this.controlComposite.layout(true);
        this.scrollComposite.layout(true);
        this.scrollComposite.redraw();
    }
}

