/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.ExternalDataSourceDiseaseInitializer;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewExternalDataSourceDiseaseInitializerPage
extends NewIdentifiablePage {
    private DiseaseModel target;
    private Composite outerComposite;
    private Combo populationBox;
    private Text pathText;
    private Text rowText;
    private Button rescaleYesButton;
    private Button rescaleNoButton;

    protected NewExternalDataSourceDiseaseInitializerPage(DiseaseModel target) {
        super(DiseaseWizardMessages.getString("NStandardDiseaseInitializerWiz.page_title"));
        this.setTitle(DiseaseWizardMessages.getString("NStandardDiseaseInitializerWiz.page_title"));
        this.setDescription(DiseaseWizardMessages.getString("NStandardDiseaseInitializerWiz.page_description"));
        this.target = target;
    }

    protected Composite createSpecificComposite(Composite parent) {
        this.outerComposite = new Composite(parent, 0);
        this.outerComposite.setLayout((Layout)new GridLayout(3, true));
        Label populationLabel = new Label(this.outerComposite, 0);
        populationLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        populationLabel.setText(DiseaseWizardMessages.getString("NInitializerWiz.population"));
        this.populationBox = new Combo(this.outerComposite, 8);
        this.populationBox.setLayoutData((Object)new GridData(4, 4, true, false));
        EList populations = this.target.getAllLabelIdentifiers();
        for (String p : populations) {
            this.populationBox.add(p);
        }
        this.populationBox.addModifyListener(this.projectValidator);
        Label noPopulationLabel = new Label(this.outerComposite, 0);
        noPopulationLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        Label pathLabel = new Label(this.outerComposite, 0);
        pathLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        pathLabel.setText(DiseaseWizardMessages.getString("NInitializerWiz.path"));
        this.pathText = new Text(this.outerComposite, 133120);
        this.pathText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.pathText.addModifyListener(this.projectValidator);
        Button dirChooserButton = new Button(this.outerComposite, 0);
        final Shell shell = this.getShell();
        dirChooserButton.setText(Messages.getString((String)"dirChooserButtonText"));
        dirChooserButton.setToolTipText(Messages.getString((String)"dirChooserButtonTooltipText"));
        dirChooserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                Path rootPath = new Path(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                dd.setText(Messages.getString((String)"dirChooserDialogTitle"));
                dd.setFilterPath(rootPath.toString());
                String pathName = dd.open();
                if (pathName != null) {
                    Path path = new Path(pathName);
                    if (rootPath.isPrefixOf((IPath)path)) {
                        String relPath = path.makeRelativeTo((IPath)rootPath).toString();
                        if (relPath.isEmpty()) {
                            relPath = "/";
                        }
                        NewExternalDataSourceDiseaseInitializerPage.this.pathText.setText(URI.createPlatformResourceURI((String)relPath, (boolean)false).toString());
                    } else {
                        NewExternalDataSourceDiseaseInitializerPage.this.pathText.setText(pathName);
                    }
                }
            }
        });
        Label rowLabel = new Label(this.outerComposite, 0);
        rowLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        rowLabel.setText(DiseaseWizardMessages.getString("NInitializerWiz.row"));
        this.rowText = new Text(this.outerComposite, 133120);
        this.rowText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.rowText.addModifyListener(this.projectValidator);
        Label noRowLabel = new Label(this.outerComposite, 0);
        noRowLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        Label rescaleLabel = new Label(this.outerComposite, 0);
        rescaleLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        rescaleLabel.setText(DiseaseWizardMessages.getString("NInitializerWiz.rescale"));
        rescaleLabel.setToolTipText(DiseaseWizardMessages.getString("NInitializerWiz.rescale.tooltip"));
        Composite rescaleComposite = new Composite(this.outerComposite, 0);
        rescaleComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        rescaleComposite.setLayout((Layout)new FillLayout(256));
        this.rescaleNoButton = new Button(rescaleComposite, 16);
        this.rescaleNoButton.setText(Messages.getString((String)"NO"));
        this.rescaleYesButton = new Button(rescaleComposite, 16);
        this.rescaleYesButton.setText(Messages.getString((String)"YES"));
        if (((Boolean)StandardPackage.eINSTANCE.getExternalDataSourceDiseaseInitializer_DoRescaling().getDefaultValue()).booleanValue()) {
            this.rescaleYesButton.setSelection(true);
        } else {
            this.rescaleNoButton.setSelection(true);
        }
        Label noRescaleLabel = new Label(this.outerComposite, 0);
        noRescaleLabel.setLayoutData((Object)new GridData(1, 4, true, false));
        return this.outerComposite;
    }

    protected ExternalDataSourceDiseaseInitializer getExternalDataSourceDiseaseInitializer() {
        ExternalDataSourceDiseaseInitializer init = StandardFactory.eINSTANCE.createExternalDataSourceDiseaseInitializer();
        init.setDiseaseName(this.target.getDiseaseName());
        init.setPopulationIdentifier(this.populationBox.getText());
        init.setDataPath(this.pathText.getText());
        init.setRow(Integer.parseInt(this.rowText.getText()));
        init.setDoRescaling(this.rescaleYesButton.getSelection());
        return init;
    }

    public boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        if (this.populationBox.getText().isEmpty()) {
            this.setErrorMessage(DiseaseWizardMessages.getString("NInitializerWiz.population.missing"));
            return false;
        }
        if (this.pathText.getText().isEmpty()) {
            this.setErrorMessage(DiseaseWizardMessages.getString("NInitializerWiz.path.missing"));
            return false;
        }
        if (this.rowText.getText().isEmpty()) {
            this.setErrorMessage(DiseaseWizardMessages.getString("NInitializerWiz.row.missing"));
            return false;
        }
        return true;
    }
}

