/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;

@NonNullByDefault
public class TypeReferenceSerializer {
    @Inject
    private Primitives primitives;
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    @Inject
    private ILogicalContainerProvider contextProvider;
    @Inject
    private ILocationInFileProvider locationProvider;

    public boolean isLocalTypeParameter(EObject context, JvmTypeParameter parameter) {
        if (context == parameter.getDeclarator()) {
            return true;
        }
        if (context instanceof JvmOperation && ((JvmOperation)context).isStatic()) {
            return false;
        }
        if (context instanceof JvmDeclaredType && ((JvmDeclaredType)context).isStatic()) {
            return false;
        }
        JvmIdentifiableElement jvmElement = this.contextProvider.getLogicalContainer(context);
        if (jvmElement != null) {
            return this.isLocalTypeParameter((EObject)jvmElement, parameter);
        }
        EObject container = context.eContainer();
        if (container == null) {
            return false;
        }
        return this.isLocalTypeParameter(container, parameter);
    }

    public void serialize(JvmTypeReference type, EObject context, IAppendable appendable) {
        this.serialize(type, context, appendable, false, true);
    }

    public void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard) {
        this.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, false, true);
    }

    public void serialize(JvmTypeReference type, EObject context, IAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject, boolean allowPrimitives) {
        IAppendable tracedAppendable = appendable;
        boolean tracing = false;
        if (appendable instanceof ITreeAppendable && type.eResource() == context.eResource()) {
            tracedAppendable = ((ITreeAppendable)appendable).trace((EObject)type);
            tracing = true;
        }
        if (type instanceof JvmWildcardTypeReference) {
            JvmWildcardTypeReference wildcard = (JvmWildcardTypeReference)type;
            if (!withoutConstraints) {
                tracedAppendable.append("?");
            }
            if (!wildcard.getConstraints().isEmpty()) {
                for (JvmTypeConstraint constraint : wildcard.getConstraints()) {
                    if (!(constraint instanceof JvmLowerBound)) continue;
                    if (!withoutConstraints) {
                        tracedAppendable.append(" super ");
                    }
                    this.serialize(constraint.getTypeReference(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                    return;
                }
                boolean first = true;
                for (JvmTypeConstraint constraint : wildcard.getConstraints()) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    if (first) {
                        if (!withoutConstraints) {
                            tracedAppendable.append(" extends ");
                        }
                        first = false;
                    } else {
                        if (withoutConstraints) {
                            throw new IllegalStateException("cannot have two upperbounds if type should be printed without constraints");
                        }
                        tracedAppendable.append(" & ");
                    }
                    this.serialize(constraint.getTypeReference(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                }
            } else if (withoutConstraints) {
                tracedAppendable.append("Object");
            }
        } else if (type instanceof JvmGenericArrayTypeReference) {
            this.serialize(((JvmGenericArrayTypeReference)type).getComponentType(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, true);
            tracedAppendable.append("[]");
        } else if (type instanceof JvmParameterizedTypeReference) {
            JvmType jvmType;
            JvmTypeParameter parameter;
            JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)type;
            if ((paramsToWildcard || paramsToObject) && parameterized.getType() instanceof JvmTypeParameter && !this.isLocalTypeParameter(context, parameter = (JvmTypeParameter)parameterized.getType())) {
                if (paramsToWildcard) {
                    tracedAppendable.append("?");
                } else {
                    tracedAppendable.append("Object");
                }
                return;
            }
            JvmType jvmType2 = jvmType = allowPrimitives ? type.getType() : this.primitives.asWrapperTypeIfPrimitive(type).getType();
            if (tracing) {
                ITextRegion region = this.locationProvider.getFullTextRegion((EObject)type, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, 0);
                if (region instanceof ITextRegionWithLineInformation) {
                    ((ITreeAppendable)tracedAppendable).trace((ILocationData)new LocationData((ITextRegionWithLineInformation)region, null, null)).append(jvmType);
                } else {
                    tracedAppendable.append(jvmType);
                }
            } else {
                tracedAppendable.append(jvmType);
            }
            if (!parameterized.getArguments().isEmpty()) {
                tracedAppendable.append("<");
                int i = 0;
                while (i < parameterized.getArguments().size()) {
                    if (i != 0) {
                        tracedAppendable.append(",");
                    }
                    this.serialize((JvmTypeReference)parameterized.getArguments().get(i), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, false);
                    ++i;
                }
                tracedAppendable.append(">");
            }
        } else if (type instanceof JvmAnyTypeReference) {
            tracedAppendable.append("Object");
        } else if (type instanceof JvmMultiTypeReference) {
            this.serialize(this.resolveMultiType(type), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
        } else if (type instanceof JvmDelegateTypeReference) {
            JvmTypeReference delegate = ((JvmDelegateTypeReference)type).getDelegate();
            if (delegate != null) {
                this.serialize(delegate, context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
            } else {
                tracedAppendable.append("Object");
            }
        } else if (type instanceof JvmSpecializedTypeReference) {
            this.serialize(((JvmSpecializedTypeReference)type).getEquivalent(), context, tracedAppendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
        } else {
            throw new IllegalArgumentException(String.valueOf(type));
        }
    }

    public JvmTypeReference resolveMultiType(JvmTypeReference reference) {
        if (reference instanceof JvmMultiTypeReference) {
            JvmTypeReference result = this.typeConformanceComputer.getCommonSuperType((List)((JvmMultiTypeReference)reference).getReferences());
            if (result instanceof JvmMultiTypeReference) {
                return this.resolveMultiType(result);
            }
            return result;
        }
        return reference;
    }
}

