/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.pde.internal.ui.refactoring.PDERefactoringAction;
import org.eclipse.pde.internal.ui.refactoring.RefactoringInfo;
import org.eclipse.pde.internal.ui.refactoring.RefactoringPluginInfo;
import org.eclipse.pde.internal.ui.refactoring.RenameExtensionPointProcessor;
import org.eclipse.pde.internal.ui.refactoring.RenameExtensionPointWizard;
import org.eclipse.pde.internal.ui.refactoring.RenamePluginProcessor;
import org.eclipse.pde.internal.ui.refactoring.RenamePluginWizard;

public class RefactoringActionFactory {
    public static PDERefactoringAction createRefactorPluginIdAction() {
        return RefactoringActionFactory.createRefactorPluginIdAction(PDEUIMessages.RenamePluginAction_label);
    }

    public static PDERefactoringAction createRefactorPluginIdAction(String label) {
        return new PDERefactoringAction(label, new RefactoringPluginInfo()){

            public RefactoringProcessor getRefactoringProcessor(RefactoringInfo info) {
                return new RenamePluginProcessor(info);
            }

            public RefactoringWizard getRefactoringWizard(PDERefactor refactor, RefactoringInfo info) {
                return new RenamePluginWizard((Refactoring)refactor, info);
            }
        };
    }

    public static PDERefactoringAction createRefactorExtPointAction(String label) {
        return new PDERefactoringAction(label, RefactoringActionFactory.getExtensionPointInfo()){

            public RefactoringProcessor getRefactoringProcessor(RefactoringInfo info) {
                return new RenameExtensionPointProcessor(info);
            }

            public RefactoringWizard getRefactoringWizard(PDERefactor refactor, RefactoringInfo info) {
                return new RenameExtensionPointWizard((Refactoring)refactor, info);
            }
        };
    }

    private static RefactoringInfo getExtensionPointInfo() {
        return new RefactoringInfo(){

            public IPluginModelBase getBase() {
                if (this.fSelection instanceof IPluginExtensionPoint) {
                    return ((IPluginExtensionPoint)this.fSelection).getPluginModel();
                }
                return null;
            }

            public String getCurrentValue() {
                if (this.fSelection instanceof IPluginExtensionPoint) {
                    return ((IPluginExtensionPoint)this.fSelection).getId();
                }
                return null;
            }
        };
    }
}

