/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.experimental.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.experimental.CellularDiseaseModel;
import org.eclipse.stem.diseasemodels.experimental.ExperimentalPackage;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;

public class CellularDiseaseModelImpl
extends SIImpl
implements CellularDiseaseModel {
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedTransmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SILabelValue currentSI = (SILabelValue)currentState;
            double transmissionRate = adjustedTransmissionRate * this.getTransmissionRateScaleFactor(diseaseLabel);
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSI.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfSusceptibleToInfected = transmissionRate * currentSI.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient());
            double numberOfInfectedToSusceptible = this.getAdjustedRecoveryRate(timeDelta) * currentSI.getI();
            double deltaS = -numberOfSusceptibleToInfected + numberOfInfectedToSusceptible;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToSusceptible;
            SILabelValueImpl ret = (SILabelValueImpl)deltaValue;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)siExchange);
            Exchange isExchange = (Exchange)ExchangePool.POOL.get();
            isExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            isExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            isExchange.setCount(numberOfInfectedToSusceptible);
            isExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)isExchange);
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    protected EClass eStaticClass() {
        return ExperimentalPackage.Literals.PERCOLATION_DISEASE_MODEL;
    }
}

