/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.HashMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.populationmodels.standard.AgeGroup;
import org.eclipse.stem.populationmodels.standard.AgingPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationGroup;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.DemographicPopulationModelImpl;

public class AgingPopulationModelImpl
extends DemographicPopulationModelImpl
implements AgingPopulationModel {
    protected static final boolean HAS_MAX_AGE_EDEFAULT = false;
    protected boolean hasMaxAge = false;

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.AGING_POPULATION_MODEL;
    }

    @Override
    public boolean isHasMaxAge() {
        return this.hasMaxAge;
    }

    @Override
    public void setHasMaxAge(boolean newHasMaxAge) {
        this.hasMaxAge = newHasMaxAge;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.isHasMaxAge();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.setHasMaxAge((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.setHasMaxAge(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return this.hasMaxAge;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (hasMaxAge: ");
        result.append(this.hasMaxAge);
        result.append(')');
        return result.toString();
    }

    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedBirthRate = this.adjustRate(this.getBirthRate(), this.getTimePeriod(), timeDelta);
        double adjustedDeathRate = this.adjustRate(this.getDeathRate(), this.getTimePeriod(), timeDelta);
        double years = (double)timeDelta / 3.1556952216E10;
        HashMap<String, AgeGroup> groups = new HashMap<String, AgeGroup>();
        for (PopulationGroup group : this.getPopulationGroups()) {
            groups.put(group.getIdentifier(), (AgeGroup)group);
        }
        for (DynamicLabel lab1 : labels) {
            StandardPopulationModelLabel currentLabel = (StandardPopulationModelLabel)lab1;
            StandardPopulationModelLabel previousLabel = null;
            StandardPopulationModelLabel nextLabel = null;
            AgeGroup currentGroup = (AgeGroup)groups.get(currentLabel.getPopulationIdentifier());
            Node node = (Node)currentLabel.getIdentifiable();
            EList nodeLabels = node.getLabels();
            double currentCount = ((StandardPopulationModelLabelValue)currentLabel.getProbeValue()).getCount();
            double births = 0.0;
            double deaths = adjustedDeathRate * currentGroup.getDeathFactor() * currentCount;
            double agedIn = 0.0;
            double agedOut = 0.0;
            double population = 0.0;
            for (NodeLabel lab2 : nodeLabels) {
                StandardPopulationModelLabel label;
                AgeGroup group;
                if (!(lab2 instanceof StandardPopulationModelLabel) || (group = (AgeGroup)groups.get((label = (StandardPopulationModelLabel)lab2).getPopulationIdentifier())) == null) continue;
                double count = ((StandardPopulationModelLabelValue)label.getTempValue()).getCount();
                population += count;
                if (currentGroup.getFromAge() == group.getToAge() + 1) {
                    agedIn = years / (double)(group.getToAge() - group.getFromAge() + 1) * count;
                    previousLabel = label;
                    continue;
                }
                if (group.getFromAge() != currentGroup.getToAge() + 1) continue;
                nextLabel = label;
            }
            if (currentGroup.getFromAge() == 0) {
                births = adjustedBirthRate * population;
            }
            if (currentGroup.isLimited()) {
                if (nextLabel != null) {
                    agedOut = years / (double)(currentGroup.getToAge() - currentGroup.getFromAge() + 1) * currentCount;
                } else {
                    deaths += years / (double)(currentGroup.getToAge() - currentGroup.getFromAge() + 1) * currentCount;
                }
            }
            StandardPopulationModelLabelValue delta = (StandardPopulationModelLabelValue)currentLabel.getDeltaValue();
            delta.setCount(births + agedIn - deaths - agedOut);
            delta.setBirths(births);
            delta.setDeaths(deaths);
            this.computeAdditionalDeltasAndExchanges(currentLabel, time, t, timeDelta);
            Exchange agedInExchange = (Exchange)ExchangePool.POOL.get();
            Exchange agedOutExchange = (Exchange)ExchangePool.POOL.get();
            if (previousLabel != null) {
                agedInExchange.setType(ExchangeType.AGING);
                agedInExchange.getOtherLabels().add(previousLabel);
                agedInExchange.setCount(agedIn);
                delta.getArrivals().add((Object)agedInExchange);
            }
            if (nextLabel != null) {
                agedOutExchange.setType(ExchangeType.AGING);
                agedOutExchange.getOtherLabels().add((Object)nextLabel);
                agedOutExchange.setCount(agedOut);
                delta.getDepartures().add((Object)agedOutExchange);
            }
            ECollections.sort((EList)delta.getArrivals());
            ECollections.sort((EList)delta.getDepartures());
        }
    }
}

