/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.logger.draw;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.loggers.imagewriter.ProjectedMapImageLogger;
import org.eclipse.stem.loggers.imagewriter.logger.PolygonHandler;
import org.eclipse.stem.loggers.imagewriter.logger.projections.IMapProjection;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.STEMColor;

public class MapDrawer {
    private static final float MAX_ALPHA_VALUE = 0.75f;
    private final ProjectedMapImageLogger logger;
    private BufferedImage img;
    private Graphics2D gc;
    private AffineTransform tx;
    private ColorProviderAdapter colorProvider;
    private Decorator decorator;
    private List<PolygonHandler.ProjectedPolygons> cachedProjectedPolygons = new LinkedList<PolygonHandler.ProjectedPolygons>();
    private IMapProjection projection;
    private Rectangle2D mapBounds;
    private int imageWidth;
    private int imageHeight;
    private Color defaultBorderColor = Color.yellow;
    private Color defaultBackgroundColor = Color.black;
    private float borderTransparency = 0.25f;
    private float gainFactor = 1.0f;
    private AlphaComposite borderCompositeAlpha;
    private boolean running = true;

    public MapDrawer(Decorator decorator, ProjectedMapImageLogger logger, IMapProjection projection) {
        this.projection = projection;
        this.logger = logger;
        this.decorator = decorator;
        this.init();
    }

    private void prepareShapes() {
        for (DynamicLabel label : this.decorator.getLabelsToUpdate()) {
            PolygonHandler.ProjectedPolygons pp;
            if (!(label instanceof DynamicNodeLabel) || (pp = PolygonHandler.getPolygonsForProjection(this.projection, (NodeLabel)((DynamicNodeLabel)label))) == null) continue;
            this.cachedProjectedPolygons.add(pp);
        }
    }

    private Rectangle2D getBoundsForProjection() {
        return this.projection.getBounds();
    }

    private Rectangle2D getBoundsForPolygons() {
        Rectangle2D bounds = null;
        for (PolygonHandler.ProjectedPolygons pp : this.cachedProjectedPolygons) {
            Rectangle2D shapeBounds = pp.getBoundingBox();
            if (shapeBounds == null) continue;
            bounds = bounds == null ? shapeBounds : bounds.createUnion(shapeBounds);
        }
        if (bounds == null) {
            return this.getBoundsForProjection();
        }
        return bounds;
    }

    private void init() {
        int borderTransparency;
        this.prepareShapes();
        this.mapBounds = this.logger.isFitToShapeBounds() ? this.getBoundsForPolygons() : this.getBoundsForProjection();
        this.imageWidth = this.logger.getWidth();
        this.imageHeight = this.logger.getHeight();
        if (this.logger.isForceAspectRatio()) {
            double aspect = Math.min((double)this.imageWidth / this.mapBounds.getWidth(), (double)this.imageHeight / this.mapBounds.getHeight());
            this.imageWidth = (int)(this.mapBounds.getWidth() * aspect);
            this.imageHeight = (int)(this.mapBounds.getHeight() * aspect);
        }
        this.tx = new AffineTransform();
        this.tx.scale((double)this.imageWidth / this.mapBounds.getWidth(), (double)this.imageHeight / this.mapBounds.getHeight());
        this.tx.translate(-this.mapBounds.getX(), -this.mapBounds.getY());
        this.img = new BufferedImage(this.imageWidth, this.imageHeight, 2);
        this.gc = this.img.createGraphics();
        this.gainFactor = this.logger.getGain();
        if (this.gainFactor <= 0.0f) {
            this.gainFactor = 1.0f;
        }
        if ((borderTransparency = this.logger.getBorderTransparency()) < 1) {
            borderTransparency = 1;
        }
        if (borderTransparency > 99) {
            borderTransparency = 99;
        }
        this.borderTransparency = (float)borderTransparency / 100.0f;
        this.borderCompositeAlpha = AlphaComposite.getInstance(3, 1.0f - this.borderTransparency);
        this.reset();
    }

    public void setColorProvider(ColorProviderAdapter cp) {
        this.colorProvider = cp;
    }

    public void reset() {
        if (this.gc != null && this.img != null) {
            this.gc.setBackground(Color.white);
            this.gc.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
        }
    }

    public void save(File imagePath, String imageFormat) {
        if (this.img != null) {
            try {
                ImageIO.write((RenderedImage)this.img, imageFormat, imagePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        this.running = false;
    }

    private void drawBackground() {
        if (this.logger.isTransparentBackground()) {
            return;
        }
        STEMColor backgroundColorStem = this.colorProvider.getBackgroundFillColor();
        Color backgroundColor = backgroundColorStem != null ? backgroundColorStem.toAWTColor() : this.defaultBackgroundColor;
        this.gc.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.gc.setBackground(backgroundColor);
        this.gc.setPaint(backgroundColor);
        this.gc.fillRect(0, 0, this.imageWidth, this.imageHeight);
    }

    private Color getBorderColor() {
        STEMColor borderColorStem = this.colorProvider.getBorderColor();
        Color borderColor = borderColorStem != null ? borderColorStem.toAWTColor() : this.defaultBorderColor;
        return borderColor;
    }

    public void draw() {
        if (this.running) {
            this.reset();
            Composite heldComposite = this.gc.getComposite();
            this.drawBackground();
            Color borderColor = this.getBorderColor();
            block0: for (PolygonHandler.ProjectedPolygons node : this.cachedProjectedPolygons) {
                if (!this.running) break;
                for (Shape polygon : node.polygons) {
                    if (!this.running) continue block0;
                    Shape projectedShape = this.tx.createTransformedShape(polygon);
                    this.colorProvider.setTarget((Notifier)node.identifiable);
                    STEMColor color = this.colorProvider.getColor(this.gainFactor, this.logger.isLogScaling());
                    this.gc.setComposite(AlphaComposite.getInstance(3, color.getAlpha() * 0.75f));
                    this.gc.setColor(color.toAWTColor());
                    this.gc.fill(projectedShape);
                    this.gc.setComposite(this.borderCompositeAlpha);
                    this.gc.setColor(borderColor);
                    this.gc.draw(projectedShape);
                }
            }
            this.gc.setComposite(heldComposite);
        }
        if (!this.running) {
            if (this.img != null) {
                this.img.flush();
                this.img = null;
            }
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
        }
    }
}

