/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.multipopulation.impl;

import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.DoubleValueMatrix;
import org.eclipse.stem.core.common.StringValue;
import org.eclipse.stem.core.common.StringValueList;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.edges.MixingEdge;
import org.eclipse.stem.definitions.edges.MixingEdgeLabelValue;
import org.eclipse.stem.definitions.edges.impl.MixingEdgeLabelImpl;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelImpl;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.multipopulation.MultiPopulationSIDiseaseModel;
import org.eclipse.stem.diseasemodels.multipopulation.MultipopulationPackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.SILabel;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelImpl;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModel;
import org.eclipse.stem.populationmodels.standard.impl.StandardFactoryImpl;

public class MultiPopulationSIDiseaseModelImpl
extends StandardDiseaseModelImpl
implements MultiPopulationSIDiseaseModel {
    protected StringValueList populationGroups;
    protected DoubleValueMatrix transmissionRate;
    protected DoubleValueList recoveryRate;
    protected DoubleValueList infectiousMortalityRate;

    public double getNormalizedEffectiveInfectious(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, EAttribute mixingAttribute, EAttribute roadAttribute) {
        this.determineMixingStrategy();
        if (this.doCommonBorderMixing && (Double)this.eGet((EStructuralFeature)mixingAttribute) == 0.0 && (Double)this.eGet((EStructuralFeature)roadAttribute) == 0.0) {
            double totalPopulation = 0.0;
            EList nodeLabels = node.getLabels();
            int j = 0;
            while (j < nodeLabels.size()) {
                NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                if (nlabel instanceof DiseaseModelLabel && this == ((DiseaseModelLabel)nlabel).getDecorator()) {
                    DiseaseModelLabel dml = (DiseaseModelLabel)nlabel;
                    DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)dml.getTempValue();
                    totalPopulation += dmlv.getPopulationCount();
                }
                ++j;
            }
            double retVal = 0.0;
            if (totalPopulation > 0.0) {
                retVal = onsiteInfectious / totalPopulation;
            }
            return retVal;
        }
        List cEdges = (List)this.edgeListObjectPool.get();
        cEdges.clear();
        if (!this.doCommonBorderMixing) {
            return this.doMixingViaMixingEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, mixingAttribute, roadAttribute);
        }
        return this.doMixingViaCommonBorderEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, mixingAttribute, roadAttribute);
    }

    private double doMixingViaMixingEdges(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, EAttribute mixingAttribute, EAttribute roadAttribute) {
        double infectiousChangeFromMixing = 0.0;
        double populationChangeFromMixing = 0.0;
        List mEdges = (List)this.edgeListObjectPool.get();
        mEdges.clear();
        MixingEdgeLabelImpl.getMixingEdgesFromNode((Node)node, (String)this.getPopulationIdentifier(), (List)mEdges);
        int i = 0;
        while (i < mEdges.size()) {
            MixingEdge mixingEdge = (MixingEdge)mEdges.get(i);
            MixingEdgeLabelValue mixingLabelValue = mixingEdge.getLabel().getCurrentValue();
            double mixingRateOrAbs = mixingLabelValue.getMixingRate();
            boolean useAbsoluteValue = mixingEdge.isUseAbsoluteValues();
            Node otherNode = mixingEdge.getOtherNode(node);
            if (otherNode instanceof Region) {
                double otherInfective = 0.0;
                double totalPopulation = 0.0;
                EList nodeLabels = otherNode.getLabels();
                int j = 0;
                while (j < nodeLabels.size()) {
                    NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                    if (nlabel instanceof DiseaseModelLabel && this == ((DiseaseModelLabel)nlabel).getDecorator()) {
                        DiseaseModelLabel dml = (DiseaseModelLabel)nlabel;
                        DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)dml.getTempValue();
                        totalPopulation += dmlv.getPopulationCount();
                    }
                    ++j;
                }
                EList labs = otherNode.getLabels();
                int j2 = 0;
                while (j2 < labs.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    NodeLabel otherLabel = (NodeLabel)labs.get(j2);
                    if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == this && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                        otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                        break;
                    }
                    ++j2;
                }
                if (useAbsoluteValue && totalPopulation > 0.0) {
                    if (mixingRateOrAbs > totalPopulation) {
                        mixingRateOrAbs = totalPopulation;
                    }
                    double fraction = mixingRateOrAbs / totalPopulation;
                    infectiousChangeFromMixing += fraction * otherInfective;
                    populationChangeFromMixing += fraction * totalPopulation;
                } else {
                    infectiousChangeFromMixing += mixingRateOrAbs * otherInfective;
                    populationChangeFromMixing += mixingRateOrAbs * totalPopulation;
                }
            }
            ++i;
        }
        this.edgeListObjectPool.release((Object)mEdges);
        return this.addMixingRoadTransportationEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, infectiousChangeFromMixing, populationChangeFromMixing, roadAttribute);
    }

    private double addMixingRoadTransportationEdges(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, double currentInfectiousChangeFromMixing, double currentPopulationChangeFromMixing, EAttribute roadAttribute) {
        double infectiousChangeFromMixing = currentInfectiousChangeFromMixing;
        double populationChangeFromMixing = currentPopulationChangeFromMixing;
        List rEdges = (List)this.edgeListObjectPool.get();
        rEdges.clear();
        RoadTransportRelationshipLabelImpl.getRoadEdgesFromNode((Node)node, (List)rEdges);
        int i = 0;
        while (i < rEdges.size()) {
            Edge roadEdge = (Edge)rEdges.get(i);
            EdgeLabel edgeLabel = roadEdge.getLabel();
            double numCrossings = ((RoadTransportRelationshipLabelValue)edgeLabel.getCurrentValue()).getNumberCrossings();
            double infectiousProportion = Math.min((Double)this.eGet((EStructuralFeature)roadAttribute) * numCrossings, 1.0);
            Node otherNode = roadEdge.getOtherNode(node);
            double otherInfective = 0.0;
            double totalPopulation = 0.0;
            EList nodeLabels = otherNode.getLabels();
            int j = 0;
            while (j < nodeLabels.size()) {
                NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                if (nlabel instanceof DiseaseModelLabel && this == ((DiseaseModelLabel)nlabel).getDecorator()) {
                    DiseaseModelLabel dml = (DiseaseModelLabel)nlabel;
                    DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)dml.getTempValue();
                    totalPopulation += dmlv.getPopulationCount();
                }
                ++j;
            }
            EList labs = otherNode.getLabels();
            int j2 = 0;
            while (j2 < labs.size()) {
                StandardDiseaseModelLabel otherDiseaseLabel;
                NodeLabel otherLabel = (NodeLabel)labs.get(j2);
                if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == this && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                    otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                    break;
                }
                ++j2;
            }
            infectiousChangeFromMixing += infectiousProportion * otherInfective;
            populationChangeFromMixing += infectiousProportion * totalPopulation;
            ++i;
        }
        this.edgeListObjectPool.release((Object)rEdges);
        double totalPopulation = 0.0;
        EList nodeLabels = node.getLabels();
        int j = 0;
        while (j < nodeLabels.size()) {
            NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
            if (nlabel instanceof DiseaseModelLabel && this == ((DiseaseModelLabel)nlabel).getDecorator()) {
                DiseaseModelLabel dml = (DiseaseModelLabel)nlabel;
                DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)dml.getTempValue();
                totalPopulation += dmlv.getPopulationCount();
            }
            ++j;
        }
        totalPopulation += populationChangeFromMixing;
        double retVal = 0.0;
        if (totalPopulation > 0.0) {
            retVal = (onsiteInfectious + infectiousChangeFromMixing) / totalPopulation;
        }
        return retVal;
    }

    private double doMixingViaCommonBorderEdges(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, EAttribute mixingAttribute, EAttribute roadAttribute) {
        double infectiousChangeFromMixing = 0.0;
        double populationChangeFromMixing = 0.0;
        List cEdges = (List)this.edgeListObjectPool.get();
        cEdges.clear();
        CommonBorderRelationshipLabelImpl.getCommonBorderEdgesFromNode((Node)node, (List)cEdges);
        int i = 0;
        while (i < cEdges.size()) {
            Edge borderEdge = (Edge)cEdges.get(i);
            Node otherNode = borderEdge.getOtherNode(node);
            double borderLength = ((CommonBorderRelationshipLabelValue)borderEdge.getLabel().getCurrentValue()).getBorderLength();
            if (otherNode instanceof Region) {
                double otherArea = 0.0;
                double otherInfective = 0.0;
                double totalPopulation = 0.0;
                EList nodeLabels = otherNode.getLabels();
                int j = 0;
                while (j < nodeLabels.size()) {
                    NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                    if (nlabel instanceof DiseaseModelLabel && this == ((DiseaseModelLabel)nlabel).getDecorator()) {
                        DiseaseModelLabel dml = (DiseaseModelLabel)nlabel;
                        DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)dml.getTempValue();
                        totalPopulation += dmlv.getPopulationCount();
                    }
                    ++j;
                }
                EList labs = otherNode.getLabels();
                int j2 = 0;
                while (j2 < labs.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    NodeLabel otherLabel = (NodeLabel)labs.get(j2);
                    if (otherLabel instanceof AreaLabel) {
                        otherArea = ((AreaLabel)otherLabel).getCurrentAreaValue().getArea();
                    } else if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == this && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                        otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                    }
                    ++j2;
                }
                double mixingFactor = Math.min((Double)this.eGet((EStructuralFeature)mixingAttribute) * borderLength / otherArea, 1.0);
                if (otherArea == 0.0) {
                    mixingFactor = 0.0;
                }
                infectiousChangeFromMixing += mixingFactor * otherInfective;
                populationChangeFromMixing += mixingFactor * totalPopulation;
            }
            ++i;
        }
        this.edgeListObjectPool.release((Object)cEdges);
        return this.addMixingRoadTransportationEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, infectiousChangeFromMixing, populationChangeFromMixing, roadAttribute);
    }

    protected EClass eStaticClass() {
        return MultipopulationPackage.Literals.MULTI_POPULATION_SI_DISEASE_MODEL;
    }

    @Override
    public DoubleValueMatrix getTransmissionRate() {
        return this.transmissionRate;
    }

    public NotificationChain basicSetTransmissionRate(DoubleValueMatrix newTransmissionRate, NotificationChain msgs) {
        this.transmissionRate = newTransmissionRate;
        return msgs;
    }

    @Override
    public void setTransmissionRate(DoubleValueMatrix newTransmissionRate) {
        if (newTransmissionRate != this.transmissionRate) {
            NotificationChain msgs = null;
            if (this.transmissionRate != null) {
                msgs = ((InternalEObject)this.transmissionRate).eInverseRemove((InternalEObject)this, -21, null, msgs);
            }
            if (newTransmissionRate != null) {
                msgs = ((InternalEObject)newTransmissionRate).eInverseAdd((InternalEObject)this, -21, null, msgs);
            }
            if ((msgs = this.basicSetTransmissionRate(newTransmissionRate, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public DoubleValueList getRecoveryRate() {
        return this.recoveryRate;
    }

    public NotificationChain basicSetRecoveryRate(DoubleValueList newRecoveryRate, NotificationChain msgs) {
        this.recoveryRate = newRecoveryRate;
        return msgs;
    }

    @Override
    public void setRecoveryRate(DoubleValueList newRecoveryRate) {
        if (newRecoveryRate != this.recoveryRate) {
            NotificationChain msgs = null;
            if (this.recoveryRate != null) {
                msgs = ((InternalEObject)this.recoveryRate).eInverseRemove((InternalEObject)this, -22, null, msgs);
            }
            if (newRecoveryRate != null) {
                msgs = ((InternalEObject)newRecoveryRate).eInverseAdd((InternalEObject)this, -22, null, msgs);
            }
            if ((msgs = this.basicSetRecoveryRate(newRecoveryRate, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public DoubleValueList getInfectiousMortalityRate() {
        return this.infectiousMortalityRate;
    }

    public double getInfectiousMortality(String populationName) {
        int populationIndex = this.getPopulationIndex(populationName);
        if (this.getInfectiousMortalityRate() != null) {
            return ((DoubleValue)this.getInfectiousMortalityRate().getValues().get(populationIndex)).getValue();
        }
        return 0.0;
    }

    public NotificationChain basicSetInfectiousMortalityRate(DoubleValueList newInfectiousMortalityRate, NotificationChain msgs) {
        this.infectiousMortalityRate = newInfectiousMortalityRate;
        return msgs;
    }

    @Override
    public void setInfectiousMortalityRate(DoubleValueList newInfectiousMortalityRate) {
        if (newInfectiousMortalityRate != this.infectiousMortalityRate) {
            NotificationChain msgs = null;
            if (this.infectiousMortalityRate != null) {
                msgs = ((InternalEObject)this.infectiousMortalityRate).eInverseRemove((InternalEObject)this, -23, null, msgs);
            }
            if (newInfectiousMortalityRate != null) {
                msgs = ((InternalEObject)newInfectiousMortalityRate).eInverseAdd((InternalEObject)this, -23, null, msgs);
            }
            if ((msgs = this.basicSetInfectiousMortalityRate(newInfectiousMortalityRate, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    @Override
    public StringValueList getPopulationGroups() {
        return this.populationGroups;
    }

    public NotificationChain basicSetPopulationGroups(StringValueList newPopulationGroups, NotificationChain msgs) {
        this.populationGroups = newPopulationGroups;
        return msgs;
    }

    @Override
    public void setPopulationGroups(StringValueList newPopulationGroups) {
        if (newPopulationGroups != this.populationGroups) {
            NotificationChain msgs = null;
            if (this.populationGroups != null) {
                msgs = ((InternalEObject)this.populationGroups).eInverseRemove((InternalEObject)this, -20, null, msgs);
            }
            if (newPopulationGroups != null) {
                msgs = ((InternalEObject)newPopulationGroups).eInverseAdd((InternalEObject)this, -20, null, msgs);
            }
            if ((msgs = this.basicSetPopulationGroups(newPopulationGroups, msgs)) != null) {
                msgs.dispatch();
            }
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 19: {
                return this.basicSetPopulationGroups(null, msgs);
            }
            case 20: {
                return this.basicSetTransmissionRate(null, msgs);
            }
            case 21: {
                return this.basicSetRecoveryRate(null, msgs);
            }
            case 22: {
                return this.basicSetInfectiousMortalityRate(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getPopulationGroups();
            }
            case 20: {
                return this.getTransmissionRate();
            }
            case 21: {
                return this.getRecoveryRate();
            }
            case 22: {
                return this.getInfectiousMortalityRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.setPopulationGroups((StringValueList)newValue);
                return;
            }
            case 20: {
                this.setTransmissionRate((DoubleValueMatrix)newValue);
                return;
            }
            case 21: {
                this.setRecoveryRate((DoubleValueList)newValue);
                return;
            }
            case 22: {
                this.setInfectiousMortalityRate((DoubleValueList)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.setPopulationGroups(null);
                return;
            }
            case 20: {
                this.setTransmissionRate(null);
                return;
            }
            case 21: {
                this.setRecoveryRate(null);
                return;
            }
            case 22: {
                this.setInfectiousMortalityRate(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return this.populationGroups != null;
            }
            case 20: {
                return this.transmissionRate != null;
            }
            case 21: {
                return this.recoveryRate != null;
            }
            case 22: {
                return this.infectiousMortalityRate != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public double getAdjustedInfectiousMortalityRate(long timeDelta, String populationName) {
        return this.getInfectiousMortality(populationName) * ((double)timeDelta / (double)this.getTimePeriod());
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SILabelValue currentSI = (SILabelValue)currentState;
            String thisPopulation = diseaseLabel.getPopulationModelLabel().getPopulationIdentifier();
            double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta, thisPopulation);
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSI.getI();
            int populationIndex = this.getPopulationIndex(thisPopulation);
            EList transmissionVector = ((DoubleValueList)this.getTransmissionRate().getValueLists().get(populationIndex)).getValues();
            double thisRecoveryRate = 0.0;
            if (this.getRecoveryRate() != null) {
                thisRecoveryRate = ((DoubleValue)this.getRecoveryRate().getValues().get(populationIndex)).getValue();
            }
            double numberOfSusceptibleToInfected = 0.0;
            double numberSusceptible = currentSI.getS();
            Node thisNode = diseaseLabel.getNode();
            EList groupList = this.getPopulationGroups().getValues();
            int i = 0;
            while (i < transmissionVector.size()) {
                String nextPop = ((StringValue)groupList.get(i)).getValue();
                double specificTransmission = ((DoubleValue)transmissionVector.get(i)).getValue();
                double adjustedTransmission = this.getAdjustedTransmissionRate(specificTransmission, timeDelta);
                if (!this.isFrequencyDependent()) {
                    adjustedTransmission *= this.getTransmissionRateScaleFactor(diseaseLabel);
                }
                EList nodeLabels = thisNode.getLabels();
                int j = 0;
                while (j < nodeLabels.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    String otherPopulation;
                    NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                    if (nlabel instanceof SILabel && this == ((SILabel)nlabel).getDecorator() && (otherPopulation = (otherDiseaseLabel = (StandardDiseaseModelLabel)nlabel).getPopulationModelLabel().getPopulationIdentifier()).equals(nextPop)) {
                        double onsiteInfectious = ((SILabelValue)otherDiseaseLabel.getTempValue()).getI();
                        double effectiveInfectious = this.getNormalizedEffectiveInfectious(thisNode, otherDiseaseLabel, onsiteInfectious, StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                        numberOfSusceptibleToInfected += adjustedTransmission * numberSusceptible * effectiveInfectious;
                    }
                    ++j;
                }
                ++i;
            }
            double numberOfInfectedToSusceptible = this.getAdjustedRecoveryRate(thisRecoveryRate, timeDelta) * currentSI.getI();
            double deltaS = -numberOfSusceptibleToInfected + numberOfInfectedToSusceptible;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToSusceptible - diseaseDeaths;
            SILabelValueImpl ret = (SILabelValueImpl)deltaValue;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)siExchange);
            Exchange isExchange = (Exchange)ExchangePool.POOL.get();
            isExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            isExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            isExchange.setCount(numberOfInfectedToSusceptible);
            isExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)isExchange);
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    protected int getPopulationIndex(String thisPopulation) {
        int populationIndex = -1;
        EList groupList = this.getPopulationGroups().getValues();
        int i = 0;
        while (i < groupList.size()) {
            String nextPop = ((StringValue)groupList.get(i)).getValue();
            if (nextPop.equalsIgnoreCase(thisPopulation)) {
                populationIndex = i;
                break;
            }
            ++i;
        }
        if (populationIndex < 0) {
            Activator.logError((String)("MultiPopulationSIDiseaseModel.computeDiseaseDeltas() Error, Population named " + thisPopulation + " not found. check spelling !!"), (Throwable)new Exception());
        }
        return populationIndex;
    }

    public double getAdjustedTransmissionRate(double specificTransmission, long timeDelta) {
        return specificTransmission * ((double)timeDelta / (double)this.getTimePeriod());
    }

    public double getAdjustedRecoveryRate(double specificRecoveryRate, long timeDelta) {
        return specificRecoveryRate * ((double)timeDelta / (double)this.getTimePeriod());
    }

    public double getTransmissionRateScaleFactor(StandardDiseaseModelLabel diseaseLabel) {
        double referenceDensity = this.getReferencePopulationDensity();
        assert (this.getArea(diseaseLabel.getPopulationLabel()) > 0.0);
        double localDensity = ((StandardDiseaseModelLabelValue)diseaseLabel.getTempValue()).getPopulationCount() / this.getArea(diseaseLabel.getPopulationLabel());
        return localDensity / referenceDensity;
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSILabel();
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSILabelValue();
    }

    public Infector createInfector() {
        SIInfector retValue = StandardFactory.eINSTANCE.createSIInfector();
        retValue.setDiseaseName(this.getDiseaseName());
        retValue.setPopulationIdentifier(this.getPopulationIdentifier());
        return retValue;
    }

    public EList<PopulationModelLabel> getPopulationModelLabels(String populationIdentifier, Graph graph) {
        BasicEList retValue = new BasicEList();
        EList labels = graph.getNodeLabelsByTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        for (NodeLabel pl : labels) {
            PopulationModelLabel populationLabel = (PopulationModelLabel)pl;
            boolean keep = false;
            for (StringValue g : this.getPopulationGroups().getValues()) {
                if (!g.getValue().equals(populationLabel.getPopulationIdentifier())) continue;
                keep = true;
                break;
            }
            if (!keep || populationLabel.getNode() == null) continue;
            retValue.add((Object)populationLabel);
        }
        return retValue;
    }

    public void prepare(Model model, STEMTime time) {
        for (StringValue sv : this.getPopulationGroups().getValues()) {
            boolean found = this.findPopulationModel(model, sv.getValue());
            if (found) continue;
            StandardPopulationModel spm = StandardFactoryImpl.eINSTANCE.createStandardPopulationModel();
            spm.setPopulationIdentifier(sv.getValue());
            String title = "Auto Generated " + sv.getValue() + " population model";
            String name = "auto_gen_" + sv.getValue() + "_population_model";
            spm.setURI(STEMURI.createURI((String)(String.valueOf(name) + "/" + STEMURI.generateUniquePart())));
            spm.setName(name);
            spm.getDublinCore().setTitle(title);
            model.getNodeDecorators().add(0, (Object)spm);
        }
    }

    public EList<String> getAllLabelIdentifiers() {
        BasicEList identifiers = new BasicEList();
        EList groups = this.getPopulationGroups().getValues();
        for (StringValue g : groups) {
            identifiers.add((Object)g.getValue());
        }
        return identifiers;
    }
}

