/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.lattice.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabel;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.lattice.GraphLatticeGeneratorInterface;
import org.eclipse.stem.definitions.nodes.NodesFactory;
import org.eclipse.stem.definitions.nodes.Region;

public abstract class GraphLatticeGenerator
implements GraphLatticeGeneratorInterface {
    public static Region createRegionNode(String uriPrefix, int x, int y, Graph graph) {
        Region node = NodesFactory.eINSTANCE.createRegion();
        DublinCore dc = node.getDublinCore();
        dc.setTitle(GraphLatticeGenerator.createNodeTitle(x, y));
        node.setURI(GraphLatticeGenerator.createRegionNodeURI(uriPrefix, x, y, graph));
        return node;
    }

    public static Region createRegionNode(String uriPrefix, String lat, String lng, Graph graph) {
        Region node = NodesFactory.eINSTANCE.createRegion();
        DublinCore dc = node.getDublinCore();
        dc.setTitle(GraphLatticeGenerator.createNodeTitle(lat, lng));
        node.setURI(GraphLatticeGenerator.createRegionNodeURI(uriPrefix, lat, lng, graph));
        return node;
    }

    public static String createNodeTitle(double x, double y) {
        StringBuilder sb = new StringBuilder("Node[");
        sb.append(Double.toString(x));
        sb.append(", ");
        sb.append(Double.toString(y));
        sb.append("]");
        return sb.toString();
    }

    public static String createNodeTitle(String x, String y) {
        StringBuilder sb = new StringBuilder("Node[");
        sb.append(x);
        sb.append(", ");
        sb.append(y);
        sb.append("]");
        return sb.toString();
    }

    public static URI createRegionNodeURI(String uriPrefix, int x, int y, Graph graph) {
        String nodeUriSuffix = String.valueOf(uriPrefix) + x + "_" + y;
        String nodeUriString = "node/" + graph.getURI().lastSegment() + "/" + nodeUriSuffix;
        URI uri = STEMURI.createURI((String)nodeUriString);
        return uri;
    }

    public static URI createRegionNodeURI(String uriPrefix, String x, String y, Graph graph) {
        String nodeUriSuffix = String.valueOf(uriPrefix) + x + "_" + y;
        String nodeUriString = "node/" + graph.getURI().lastSegment() + "/" + nodeUriSuffix;
        URI uri = STEMURI.createURI((String)nodeUriString);
        return uri;
    }

    private static URI createEdgeLabelURI(Node nodeA, Node nodeB) {
        URI uriA = nodeA.getURI();
        URI uriB = nodeB.getURI();
        String sA = uriA.lastSegment();
        String sB = uriB.lastSegment();
        sA = sA.replace('_', '.');
        sB = sB.replace('_', '.');
        String uriString = String.valueOf(sA) + "_" + sB;
        URI uri = STEMURI.createURI((String)uriString);
        return uri;
    }

    public static void createEdge(Graph graph, Node nodeA, Node nodeB, int borderLength) {
        Edge edge = CommonBorderRelationshipLabelImpl.createCommonBorderRelationship(nodeA, nodeB, borderLength);
        URI edgeURI = edge.getURI();
        String sEdge = edgeURI.toString();
        int last = sEdge.lastIndexOf("/");
        String sEdge1 = sEdge.substring(0, last);
        String sEdge2 = sEdge.substring(last, sEdge.length());
        sEdge = String.valueOf(sEdge1) + "/relationship/commonborder" + sEdge2;
        URI newURI = URI.createURI((String)sEdge);
        edge.setURI(newURI);
        CommonBorderRelationshipLabel label = (CommonBorderRelationshipLabel)edge.getLabel();
        label.setURI(GraphLatticeGenerator.createEdgeLabelURI(nodeA, nodeB));
        DublinCore dc = edge.getDublinCore();
        dc.setTitle(GraphLatticeGenerator.createEdgeTitle(nodeA, nodeB));
        graph.putEdge(edge);
    }

    public static String createEdgeTitle(Node nodeA, Node nodeB) {
        String nA = nodeA.getDublinCore().getTitle();
        String nB = nodeB.getDublinCore().getTitle();
        StringBuilder sb = new StringBuilder("Edge[(");
        sb.append(nA);
        sb.append(")<-->(");
        sb.append(nB);
        sb.append(")]");
        return sb.toString();
    }

    public static PopulationLabel createPopulationLabel(String populationIdentifier, double populationCount, Node node) {
        PopulationLabel retValue = LabelsFactory.eINSTANCE.createPopulationLabel();
        retValue.setPopulationIdentifier(populationIdentifier);
        retValue.getCurrentPopulationValue().setCount(populationCount);
        node.getLabels().add((Object)retValue);
        return retValue;
    }
}

